# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include finspace_service.R
NULL

#' Create a new FinSpace environment
#'
#' @description
#' Create a new FinSpace environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_environment/](https://www.paws-r-sdk.com/docs/finspace_create_environment/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the FinSpace environment to be created.
#' @param description The description of the FinSpace environment to be created.
#' @param kmsKeyId The KMS key id to encrypt your data in the FinSpace environment.
#' @param tags Add tags to your FinSpace environment.
#' @param federationMode Authentication mode for the environment.
#' 
#' -   `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via
#'     your Identity provider.
#' 
#' -   `LOCAL` - Users access FinSpace via email and password managed
#'     within the FinSpace environment.
#' @param federationParameters Configuration information when authentication mode is FEDERATED.
#' @param superuserParameters Configuration information for the superuser.
#' @param dataBundles The list of Amazon Resource Names (ARN) of the data bundles to install.
#' Currently supported data bundle ARNs:
#' 
#' -   `arn:aws:finspace:${Region}::data-bundle/capital-markets-sample` -
#'     Contains sample Capital Markets datasets, categories and controlled
#'     vocabularies.
#' 
#' -   `arn:aws:finspace:${Region}::data-bundle/taq` (default) - Contains
#'     trades and quotes data in addition to sample Capital Markets data.
#'
#' @keywords internal
#'
#' @rdname finspace_create_environment
finspace_create_environment <- function(name, description = NULL, kmsKeyId = NULL, tags = NULL, federationMode = NULL, federationParameters = NULL, superuserParameters = NULL, dataBundles = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/environment",
    paginator = list()
  )
  input <- .finspace$create_environment_input(name = name, description = description, kmsKeyId = kmsKeyId, tags = tags, federationMode = federationMode, federationParameters = federationParameters, superuserParameters = superuserParameters, dataBundles = dataBundles)
  output <- .finspace$create_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_environment <- finspace_create_environment

#' Creates a changeset for a kdb database
#'
#' @description
#' Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_changeset/](https://www.paws-r-sdk.com/docs/finspace_create_kx_changeset/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier of the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#' @param changeRequests &#91;required&#93; A list of change request objects that are run in order. A change request
#' object consists of `changeType` , `s3Path`, and `dbPath`. A changeType
#' can have the following values:
#' 
#' -   PUT – Adds or updates files in a database.
#' 
#' -   DELETE – Deletes files in a database.
#' 
#' All the change requests require a mandatory `dbPath` attribute that
#' defines the path within the database directory. All database paths must
#' start with a leading / and end with a trailing /. The `s3Path` attribute
#' defines the s3 source file path and is required for a PUT change type.
#' The `s3path` must end with a trailing / if it is a directory and must
#' end without a trailing / if it is a file.
#' 
#' Here are few examples of how you can use the change request object:
#' 
#' 1.  This request adds a single sym file at database root location.
#' 
#'     `{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}`
#' 
#' 2.  This request adds files in the given `s3Path` under the 2020.01.02
#'     partition of the database.
#' 
#'     `{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}`
#' 
#' 3.  This request adds files in the given `s3Path` under the *taq* table
#'     partition of the database.
#' 
#'     `[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
#' 
#' 4.  This request deletes the 2020.01.02 partition of the database.
#' 
#'     `[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]`
#' 
#' 5.  The *DELETE* request allows you to delete the existing files under
#'     the 2020.01.02 partition of the database, and the *PUT* request adds
#'     a new taq table under it.
#' 
#'     `[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_changeset
finspace_create_kx_changeset <- function(environmentId, databaseName, changeRequests, clientToken) {
  op <- new_operation(
    name = "CreateKxChangeset",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/changesets",
    paginator = list()
  )
  input <- .finspace$create_kx_changeset_input(environmentId = environmentId, databaseName = databaseName, changeRequests = changeRequests, clientToken = clientToken)
  output <- .finspace$create_kx_changeset_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_changeset <- finspace_create_kx_changeset

#' Creates a new kdb cluster
#'
#' @description
#' Creates a new kdb cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_cluster/](https://www.paws-r-sdk.com/docs/finspace_create_kx_cluster/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; A unique name for the cluster that you want to create.
#' @param clusterType &#91;required&#93; Specifies the type of KDB database that is being created. The following
#' types are available:
#' 
#' -   HDB – A Historical Database. The data is only accessible with
#'     read-only permissions from one of the FinSpace managed kdb databases
#'     mounted to the cluster.
#' 
#' -   RDB – A Realtime Database. This type of database captures all the
#'     data from a ticker plant and stores it in memory until the end of
#'     day, after which it writes all of its data to a disk and reloads the
#'     HDB. This cluster type requires local storage for temporary storage
#'     of data during the savedown process. If you specify this field in
#'     your request, you must provide the `savedownStorageConfiguration`
#'     parameter.
#' 
#' -   GATEWAY – A gateway cluster allows you to access data across
#'     processes in kdb systems. It allows you to create your own routing
#'     logic using the initialization scripts and custom code. This type of
#'     cluster does not require a writable local storage.
#' 
#' -   GP – A general purpose cluster allows you to quickly iterate on code
#'     during development by granting greater access to system commands and
#'     enabling a fast reload of custom code. This cluster type can
#'     optionally mount databases including cache and savedown storage. For
#'     this cluster type, the node count is fixed at 1. It does not support
#'     autoscaling and supports only `SINGLE` AZ mode.
#' 
#' -   Tickerplant – A tickerplant cluster allows you to subscribe to feed
#'     handlers based on IAM permissions. It can publish to RDBs, other
#'     Tickerplants, and real-time subscribers (RTS). Tickerplants can
#'     persist messages to log, which is readable by any RDB environment.
#'     It supports only single-node that is only one kdb process.
#' @param tickerplantLogConfiguration A configuration to store Tickerplant logs. It consists of a list of
#' volumes that will be mounted to your cluster. For the cluster type
#' `Tickerplant`, the location of the TP volume on the cluster will be
#' available by using the global variable `.aws.tp_log_path`.
#' @param databases A list of databases that will be available for querying.
#' @param cacheStorageConfigurations The configurations for a read only cache storage associated with a
#' cluster. This cache will be stored as an FSx Lustre that reads from the
#' S3 store.
#' @param autoScalingConfiguration The configuration based on which FinSpace will scale in or scale out
#' nodes in your cluster.
#' @param clusterDescription A description of the cluster.
#' @param capacityConfiguration A structure for the metadata of a cluster. It includes information like
#' the CPUs needed, memory of instances, and number of instances.
#' @param releaseLabel &#91;required&#93; The version of FinSpace managed kdb to run.
#' @param vpcConfiguration &#91;required&#93; Configuration details about the network where the Privatelink endpoint
#' of the cluster resides.
#' @param initializationScript Specifies a Q program that will be run at launch of a cluster. It is a
#' relative path within *.zip* file that contains the custom code, which
#' will be loaded on the cluster. It must include the file name itself. For
#' example, `somedir/init.q`.
#' @param commandLineArguments Defines the key-value pairs to make them available inside the cluster.
#' @param code The details of the custom code that you want to use inside a cluster
#' when analyzing a data. It consists of the S3 source bucket, location, S3
#' object version, and the relative path from where the custom code is
#' loaded into the cluster.
#' @param executionRole An IAM role that defines a set of permissions associated with a cluster.
#' These permissions are assumed when a cluster attempts to access another
#' cluster.
#' @param savedownStorageConfiguration The size and type of the temporary storage that is used to hold data
#' during the savedown process. This parameter is required when you choose
#' `clusterType` as RDB. All the data written to this storage space is lost
#' when the cluster node is restarted.
#' @param azMode &#91;required&#93; The number of availability zones you want to assign per cluster. This
#' can be one of the following
#' 
#' -   `SINGLE` – Assigns one availability zone per cluster.
#' 
#' -   `MULTI` – Assigns all the availability zones per cluster.
#' @param availabilityZoneId The availability zone identifiers for the requested regions.
#' @param tags A list of key-value pairs to label the cluster. You can add up to 50
#' tags to a cluster.
#' @param scalingGroupConfiguration The structure that stores the configuration details of a scaling group.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_cluster
finspace_create_kx_cluster <- function(clientToken = NULL, environmentId, clusterName, clusterType, tickerplantLogConfiguration = NULL, databases = NULL, cacheStorageConfigurations = NULL, autoScalingConfiguration = NULL, clusterDescription = NULL, capacityConfiguration = NULL, releaseLabel, vpcConfiguration, initializationScript = NULL, commandLineArguments = NULL, code = NULL, executionRole = NULL, savedownStorageConfiguration = NULL, azMode, availabilityZoneId = NULL, tags = NULL, scalingGroupConfiguration = NULL) {
  op <- new_operation(
    name = "CreateKxCluster",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/clusters",
    paginator = list()
  )
  input <- .finspace$create_kx_cluster_input(clientToken = clientToken, environmentId = environmentId, clusterName = clusterName, clusterType = clusterType, tickerplantLogConfiguration = tickerplantLogConfiguration, databases = databases, cacheStorageConfigurations = cacheStorageConfigurations, autoScalingConfiguration = autoScalingConfiguration, clusterDescription = clusterDescription, capacityConfiguration = capacityConfiguration, releaseLabel = releaseLabel, vpcConfiguration = vpcConfiguration, initializationScript = initializationScript, commandLineArguments = commandLineArguments, code = code, executionRole = executionRole, savedownStorageConfiguration = savedownStorageConfiguration, azMode = azMode, availabilityZoneId = availabilityZoneId, tags = tags, scalingGroupConfiguration = scalingGroupConfiguration)
  output <- .finspace$create_kx_cluster_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_cluster <- finspace_create_kx_cluster

#' Creates a new kdb database in the environment
#'
#' @description
#' Creates a new kdb database in the environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_database/](https://www.paws-r-sdk.com/docs/finspace_create_kx_database/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#' @param description A description of the database.
#' @param tags A list of key-value pairs to label the kdb database. You can add up to
#' 50 tags to your kdb database
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_database
finspace_create_kx_database <- function(environmentId, databaseName, description = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateKxDatabase",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/databases",
    paginator = list()
  )
  input <- .finspace$create_kx_database_input(environmentId = environmentId, databaseName = databaseName, description = description, tags = tags, clientToken = clientToken)
  output <- .finspace$create_kx_database_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_database <- finspace_create_kx_database

#' Creates a snapshot of kdb database with tiered storage capabilities and
#' a pre-warmed cache, ready for mounting on kdb clusters
#'
#' @description
#' Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on dedicated clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_dataview/](https://www.paws-r-sdk.com/docs/finspace_create_kx_dataview/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, where you want to create
#' the dataview.
#' @param databaseName &#91;required&#93; The name of the database where you want to create a dataview.
#' @param dataviewName &#91;required&#93; A unique identifier for the dataview.
#' @param azMode &#91;required&#93; The number of availability zones you want to assign per volume.
#' Currently, FinSpace only supports `SINGLE` for volumes. This places
#' dataview in a single AZ.
#' @param availabilityZoneId The identifier of the availability zones.
#' @param changesetId A unique identifier of the changeset that you want to use to ingest
#' data.
#' @param segmentConfigurations The configuration that contains the database path of the data that you
#' want to place on each selected volume. Each segment must have a unique
#' database path for each volume. If you do not explicitly specify any
#' database path for a volume, they are accessible from the cluster through
#' the default S3/object store segment.
#' @param autoUpdate The option to specify whether you want to apply all the future additions
#' and corrections automatically to the dataview, when you ingest new
#' changesets. The default value is false.
#' @param readWrite The option to specify whether you want to make the dataview writable to
#' perform database maintenance. The following are some considerations
#' related to writable dataviews.
#' 
#' -   You cannot create partial writable dataviews. When you create
#'     writeable dataviews you must provide the entire database path.
#' 
#' -   You cannot perform updates on a writeable dataview. Hence,
#'     `autoUpdate` must be set as **False** if `readWrite` is **True** for
#'     a dataview.
#' 
#' -   You must also use a unique volume for creating a writeable dataview.
#'     So, if you choose a volume that is already in use by another
#'     dataview, the dataview creation fails.
#' 
#' -   Once you create a dataview as writeable, you cannot change it to
#'     read-only. So, you cannot update the `readWrite` parameter later.
#' @param description A description of the dataview.
#' @param tags A list of key-value pairs to label the dataview. You can add up to 50
#' tags to a dataview.
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_dataview
finspace_create_kx_dataview <- function(environmentId, databaseName, dataviewName, azMode, availabilityZoneId = NULL, changesetId = NULL, segmentConfigurations = NULL, autoUpdate = NULL, readWrite = NULL, description = NULL, tags = NULL, clientToken) {
  op <- new_operation(
    name = "CreateKxDataview",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/dataviews",
    paginator = list()
  )
  input <- .finspace$create_kx_dataview_input(environmentId = environmentId, databaseName = databaseName, dataviewName = dataviewName, azMode = azMode, availabilityZoneId = availabilityZoneId, changesetId = changesetId, segmentConfigurations = segmentConfigurations, autoUpdate = autoUpdate, readWrite = readWrite, description = description, tags = tags, clientToken = clientToken)
  output <- .finspace$create_kx_dataview_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_dataview <- finspace_create_kx_dataview

#' Creates a managed kdb environment for the account
#'
#' @description
#' Creates a managed kdb environment for the account.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_environment/](https://www.paws-r-sdk.com/docs/finspace_create_kx_environment/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the kdb environment that you want to create.
#' @param description A description for the kdb environment.
#' @param kmsKeyId &#91;required&#93; The KMS key ID to encrypt your data in the FinSpace environment.
#' @param tags A list of key-value pairs to label the kdb environment. You can add up
#' to 50 tags to your kdb environment.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_environment
finspace_create_kx_environment <- function(name, description = NULL, kmsKeyId, tags = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "CreateKxEnvironment",
    http_method = "POST",
    http_path = "/kx/environments",
    paginator = list()
  )
  input <- .finspace$create_kx_environment_input(name = name, description = description, kmsKeyId = kmsKeyId, tags = tags, clientToken = clientToken)
  output <- .finspace$create_kx_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_environment <- finspace_create_kx_environment

#' Creates a new scaling group
#'
#' @description
#' Creates a new scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_scaling_group/](https://www.paws-r-sdk.com/docs/finspace_create_kx_scaling_group/) for full documentation.
#'
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, where you want to create
#' the scaling group.
#' @param scalingGroupName &#91;required&#93; A unique identifier for the kdb scaling group.
#' @param hostType &#91;required&#93; The memory and CPU capabilities of the scaling group host on which
#' FinSpace Managed kdb clusters will be placed.
#' 
#' You can add one of the following values:
#' 
#' -   `kx.sg.4xlarge` – The host type with a configuration of 108 GiB
#'     memory and 16 vCPUs.
#' 
#' -   `kx.sg.8xlarge` – The host type with a configuration of 216 GiB
#'     memory and 32 vCPUs.
#' 
#' -   `kx.sg.16xlarge` – The host type with a configuration of 432 GiB
#'     memory and 64 vCPUs.
#' 
#' -   `kx.sg.32xlarge` – The host type with a configuration of 864 GiB
#'     memory and 128 vCPUs.
#' 
#' -   `kx.sg1.16xlarge` – The host type with a configuration of 1949 GiB
#'     memory and 64 vCPUs.
#' 
#' -   `kx.sg1.24xlarge` – The host type with a configuration of 2948 GiB
#'     memory and 96 vCPUs.
#' @param availabilityZoneId &#91;required&#93; The identifier of the availability zones.
#' @param tags A list of key-value pairs to label the scaling group. You can add up to
#' 50 tags to a scaling group.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_scaling_group
finspace_create_kx_scaling_group <- function(clientToken, environmentId, scalingGroupName, hostType, availabilityZoneId, tags = NULL) {
  op <- new_operation(
    name = "CreateKxScalingGroup",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/scalingGroups",
    paginator = list()
  )
  input <- .finspace$create_kx_scaling_group_input(clientToken = clientToken, environmentId = environmentId, scalingGroupName = scalingGroupName, hostType = hostType, availabilityZoneId = availabilityZoneId, tags = tags)
  output <- .finspace$create_kx_scaling_group_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_scaling_group <- finspace_create_kx_scaling_group

#' Creates a user in FinSpace kdb environment with an associated IAM role
#'
#' @description
#' Creates a user in FinSpace kdb environment with an associated IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_user/](https://www.paws-r-sdk.com/docs/finspace_create_kx_user/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment where you want to create a
#' user.
#' @param userName &#91;required&#93; A unique identifier for the user.
#' @param iamRole &#91;required&#93; The IAM role ARN that will be associated with the user.
#' @param tags A list of key-value pairs to label the user. You can add up to 50 tags
#' to a user.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_user
finspace_create_kx_user <- function(environmentId, userName, iamRole, tags = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "CreateKxUser",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/users",
    paginator = list()
  )
  input <- .finspace$create_kx_user_input(environmentId = environmentId, userName = userName, iamRole = iamRole, tags = tags, clientToken = clientToken)
  output <- .finspace$create_kx_user_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_user <- finspace_create_kx_user

#' Creates a new volume with a specific amount of throughput and storage
#' capacity
#'
#' @description
#' Creates a new volume with a specific amount of throughput and storage capacity.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_create_kx_volume/](https://www.paws-r-sdk.com/docs/finspace_create_kx_volume/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, whose clusters can attach
#' to the volume.
#' @param volumeType &#91;required&#93; The type of file system volume. Currently, FinSpace only supports
#' `NAS_1` volume type. When you select `NAS_1` volume type, you must also
#' provide `nas1Configuration`.
#' @param volumeName &#91;required&#93; A unique identifier for the volume.
#' @param description A description of the volume.
#' @param nas1Configuration Specifies the configuration for the Network attached storage (NAS_1)
#' file system volume. This parameter is required when you choose
#' `volumeType` as *NAS_1*.
#' @param azMode &#91;required&#93; The number of availability zones you want to assign per volume.
#' Currently, FinSpace only supports `SINGLE` for volumes. This places
#' dataview in a single AZ.
#' @param availabilityZoneIds &#91;required&#93; The identifier of the availability zones.
#' @param tags A list of key-value pairs to label the volume. You can add up to 50 tags
#' to a volume.
#'
#' @keywords internal
#'
#' @rdname finspace_create_kx_volume
finspace_create_kx_volume <- function(clientToken = NULL, environmentId, volumeType, volumeName, description = NULL, nas1Configuration = NULL, azMode, availabilityZoneIds, tags = NULL) {
  op <- new_operation(
    name = "CreateKxVolume",
    http_method = "POST",
    http_path = "/kx/environments/{environmentId}/kxvolumes",
    paginator = list()
  )
  input <- .finspace$create_kx_volume_input(clientToken = clientToken, environmentId = environmentId, volumeType = volumeType, volumeName = volumeName, description = description, nas1Configuration = nas1Configuration, azMode = azMode, availabilityZoneIds = availabilityZoneIds, tags = tags)
  output <- .finspace$create_kx_volume_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_kx_volume <- finspace_create_kx_volume

#' Delete an FinSpace environment
#'
#' @description
#' Delete an FinSpace environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_environment/](https://www.paws-r-sdk.com/docs/finspace_delete_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier for the FinSpace environment.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_environment
finspace_delete_environment <- function(environmentId) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "DELETE",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$delete_environment_input(environmentId = environmentId)
  output <- .finspace$delete_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_environment <- finspace_delete_environment

#' Deletes a kdb cluster
#'
#' @description
#' Deletes a kdb cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_cluster/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_cluster/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; The name of the cluster that you want to delete.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_cluster
finspace_delete_kx_cluster <- function(environmentId, clusterName, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteKxCluster",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_cluster_input(environmentId = environmentId, clusterName = clusterName, clientToken = clientToken)
  output <- .finspace$delete_kx_cluster_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_cluster <- finspace_delete_kx_cluster

#' Deletes the specified nodes from a cluster
#'
#' @description
#' Deletes the specified nodes from a cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_cluster_node/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_cluster_node/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; The name of the cluster, for which you want to delete the nodes.
#' @param nodeId &#91;required&#93; A unique identifier for the node that you want to delete.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_cluster_node
finspace_delete_kx_cluster_node <- function(environmentId, clusterName, nodeId) {
  op <- new_operation(
    name = "DeleteKxClusterNode",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}/nodes/{nodeId}",
    paginator = list()
  )
  input <- .finspace$delete_kx_cluster_node_input(environmentId = environmentId, clusterName = clusterName, nodeId = nodeId)
  output <- .finspace$delete_kx_cluster_node_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_cluster_node <- finspace_delete_kx_cluster_node

#' Deletes the specified database and all of its associated data
#'
#' @description
#' Deletes the specified database and all of its associated data. This action is irreversible. You must copy any data out of the database before deleting it if the data is to be retained.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_database/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_database/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database that you want to delete.
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_database
finspace_delete_kx_database <- function(environmentId, databaseName, clientToken) {
  op <- new_operation(
    name = "DeleteKxDatabase",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_database_input(environmentId = environmentId, databaseName = databaseName, clientToken = clientToken)
  output <- .finspace$delete_kx_database_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_database <- finspace_delete_kx_database

#' Deletes the specified dataview
#'
#' @description
#' Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_dataview/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_dataview/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, from where you want to
#' delete the dataview.
#' @param databaseName &#91;required&#93; The name of the database whose dataview you want to delete.
#' @param dataviewName &#91;required&#93; The name of the dataview that you want to delete.
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_dataview
finspace_delete_kx_dataview <- function(environmentId, databaseName, dataviewName, clientToken) {
  op <- new_operation(
    name = "DeleteKxDataview",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_dataview_input(environmentId = environmentId, databaseName = databaseName, dataviewName = dataviewName, clientToken = clientToken)
  output <- .finspace$delete_kx_dataview_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_dataview <- finspace_delete_kx_dataview

#' Deletes the kdb environment
#'
#' @description
#' Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the associated data and any services running in it.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_environment/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_environment
finspace_delete_kx_environment <- function(environmentId, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteKxEnvironment",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}",
    paginator = list()
  )
  input <- .finspace$delete_kx_environment_input(environmentId = environmentId, clientToken = clientToken)
  output <- .finspace$delete_kx_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_environment <- finspace_delete_kx_environment

#' Deletes the specified scaling group
#'
#' @description
#' Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the clusters running on it have been deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_scaling_group/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_scaling_group/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, from where you want to
#' delete the dataview.
#' @param scalingGroupName &#91;required&#93; A unique identifier for the kdb scaling group.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_scaling_group
finspace_delete_kx_scaling_group <- function(environmentId, scalingGroupName, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteKxScalingGroup",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/scalingGroups/{scalingGroupName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_scaling_group_input(environmentId = environmentId, scalingGroupName = scalingGroupName, clientToken = clientToken)
  output <- .finspace$delete_kx_scaling_group_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_scaling_group <- finspace_delete_kx_scaling_group

#' Deletes a user in the specified kdb environment
#'
#' @description
#' Deletes a user in the specified kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_user/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_user/) for full documentation.
#'
#' @param userName &#91;required&#93; A unique identifier for the user that you want to delete.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_user
finspace_delete_kx_user <- function(userName, environmentId, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteKxUser",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/users/{userName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_user_input(userName = userName, environmentId = environmentId, clientToken = clientToken)
  output <- .finspace$delete_kx_user_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_user <- finspace_delete_kx_user

#' Deletes a volume
#'
#' @description
#' Deletes a volume. You can only delete a volume if it's not attached to a cluster or a dataview. When a volume is deleted, any data on the volume is lost. This action is irreversible.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_delete_kx_volume/](https://www.paws-r-sdk.com/docs/finspace_delete_kx_volume/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, whose clusters can attach
#' to the volume.
#' @param volumeName &#91;required&#93; The name of the volume that you want to delete.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_kx_volume
finspace_delete_kx_volume <- function(environmentId, volumeName, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteKxVolume",
    http_method = "DELETE",
    http_path = "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
    paginator = list()
  )
  input <- .finspace$delete_kx_volume_input(environmentId = environmentId, volumeName = volumeName, clientToken = clientToken)
  output <- .finspace$delete_kx_volume_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_kx_volume <- finspace_delete_kx_volume

#' Returns the FinSpace environment object
#'
#' @description
#' Returns the FinSpace environment object.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_environment/](https://www.paws-r-sdk.com/docs/finspace_get_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier of the FinSpace environment.
#'
#' @keywords internal
#'
#' @rdname finspace_get_environment
finspace_get_environment <- function(environmentId) {
  op <- new_operation(
    name = "GetEnvironment",
    http_method = "GET",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$get_environment_input(environmentId = environmentId)
  output <- .finspace$get_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_environment <- finspace_get_environment

#' Returns information about a kdb changeset
#'
#' @description
#' Returns information about a kdb changeset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_changeset/](https://www.paws-r-sdk.com/docs/finspace_get_kx_changeset/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#' @param changesetId &#91;required&#93; A unique identifier of the changeset for which you want to retrieve
#' data.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_changeset
finspace_get_kx_changeset <- function(environmentId, databaseName, changesetId) {
  op <- new_operation(
    name = "GetKxChangeset",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/changesets/{changesetId}",
    paginator = list()
  )
  input <- .finspace$get_kx_changeset_input(environmentId = environmentId, databaseName = databaseName, changesetId = changesetId)
  output <- .finspace$get_kx_changeset_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_changeset <- finspace_get_kx_changeset

#' Retrieves information about a kdb cluster
#'
#' @description
#' Retrieves information about a kdb cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_cluster/](https://www.paws-r-sdk.com/docs/finspace_get_kx_cluster/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; The name of the cluster that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_cluster
finspace_get_kx_cluster <- function(environmentId, clusterName) {
  op <- new_operation(
    name = "GetKxCluster",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}",
    paginator = list()
  )
  input <- .finspace$get_kx_cluster_input(environmentId = environmentId, clusterName = clusterName)
  output <- .finspace$get_kx_cluster_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_cluster <- finspace_get_kx_cluster

#' Retrieves a connection string for a user to connect to a kdb cluster
#'
#' @description
#' Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role that you have defined while creating a user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_connection_string/](https://www.paws-r-sdk.com/docs/finspace_get_kx_connection_string/) for full documentation.
#'
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the user. For more
#' information about ARNs and how to use ARNs in policies, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; A name of the kdb cluster.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_connection_string
finspace_get_kx_connection_string <- function(userArn, environmentId, clusterName) {
  op <- new_operation(
    name = "GetKxConnectionString",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/connectionString",
    paginator = list()
  )
  input <- .finspace$get_kx_connection_string_input(userArn = userArn, environmentId = environmentId, clusterName = clusterName)
  output <- .finspace$get_kx_connection_string_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_connection_string <- finspace_get_kx_connection_string

#' Returns database information for the specified environment ID
#'
#' @description
#' Returns database information for the specified environment ID.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_database/](https://www.paws-r-sdk.com/docs/finspace_get_kx_database/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_database
finspace_get_kx_database <- function(environmentId, databaseName) {
  op <- new_operation(
    name = "GetKxDatabase",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}",
    paginator = list()
  )
  input <- .finspace$get_kx_database_input(environmentId = environmentId, databaseName = databaseName)
  output <- .finspace$get_kx_database_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_database <- finspace_get_kx_database

#' Retrieves details of the dataview
#'
#' @description
#' Retrieves details of the dataview.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_dataview/](https://www.paws-r-sdk.com/docs/finspace_get_kx_dataview/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, from where you want to
#' retrieve the dataview details.
#' @param databaseName &#91;required&#93; The name of the database where you created the dataview.
#' @param dataviewName &#91;required&#93; A unique identifier for the dataview.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_dataview
finspace_get_kx_dataview <- function(environmentId, databaseName, dataviewName) {
  op <- new_operation(
    name = "GetKxDataview",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
    paginator = list()
  )
  input <- .finspace$get_kx_dataview_input(environmentId = environmentId, databaseName = databaseName, dataviewName = dataviewName)
  output <- .finspace$get_kx_dataview_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_dataview <- finspace_get_kx_dataview

#' Retrieves all the information for the specified kdb environment
#'
#' @description
#' Retrieves all the information for the specified kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_environment/](https://www.paws-r-sdk.com/docs/finspace_get_kx_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_environment
finspace_get_kx_environment <- function(environmentId) {
  op <- new_operation(
    name = "GetKxEnvironment",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}",
    paginator = list()
  )
  input <- .finspace$get_kx_environment_input(environmentId = environmentId)
  output <- .finspace$get_kx_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_environment <- finspace_get_kx_environment

#' Retrieves details of a scaling group
#'
#' @description
#' Retrieves details of a scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_scaling_group/](https://www.paws-r-sdk.com/docs/finspace_get_kx_scaling_group/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param scalingGroupName &#91;required&#93; A unique identifier for the kdb scaling group.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_scaling_group
finspace_get_kx_scaling_group <- function(environmentId, scalingGroupName) {
  op <- new_operation(
    name = "GetKxScalingGroup",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/scalingGroups/{scalingGroupName}",
    paginator = list()
  )
  input <- .finspace$get_kx_scaling_group_input(environmentId = environmentId, scalingGroupName = scalingGroupName)
  output <- .finspace$get_kx_scaling_group_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_scaling_group <- finspace_get_kx_scaling_group

#' Retrieves information about the specified kdb user
#'
#' @description
#' Retrieves information about the specified kdb user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_user/](https://www.paws-r-sdk.com/docs/finspace_get_kx_user/) for full documentation.
#'
#' @param userName &#91;required&#93; A unique identifier for the user.
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_user
finspace_get_kx_user <- function(userName, environmentId) {
  op <- new_operation(
    name = "GetKxUser",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/users/{userName}",
    paginator = list()
  )
  input <- .finspace$get_kx_user_input(userName = userName, environmentId = environmentId)
  output <- .finspace$get_kx_user_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_user <- finspace_get_kx_user

#' Retrieves the information about the volume
#'
#' @description
#' Retrieves the information about the volume.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_get_kx_volume/](https://www.paws-r-sdk.com/docs/finspace_get_kx_volume/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, whose clusters can attach
#' to the volume.
#' @param volumeName &#91;required&#93; A unique identifier for the volume.
#'
#' @keywords internal
#'
#' @rdname finspace_get_kx_volume
finspace_get_kx_volume <- function(environmentId, volumeName) {
  op <- new_operation(
    name = "GetKxVolume",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
    paginator = list()
  )
  input <- .finspace$get_kx_volume_input(environmentId = environmentId, volumeName = volumeName)
  output <- .finspace$get_kx_volume_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_kx_volume <- finspace_get_kx_volume

#' A list of all of your FinSpace environments
#'
#' @description
#' A list of all of your FinSpace environments.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_environments/](https://www.paws-r-sdk.com/docs/finspace_list_environments/) for full documentation.
#'
#' @param nextToken A token generated by FinSpace that specifies where to continue
#' pagination if a previous request was truncated. To get the next set of
#' pages, pass in the `nextToken`nextToken value from the response object
#' of the previous page call.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_environments
finspace_list_environments <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "GET",
    http_path = "/environment",
    paginator = list()
  )
  input <- .finspace$list_environments_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_environments_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_environments <- finspace_list_environments

#' Returns a list of all the changesets for a database
#'
#' @description
#' Returns a list of all the changesets for a database.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_changesets/](https://www.paws-r-sdk.com/docs/finspace_list_kx_changesets/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_changesets
finspace_list_kx_changesets <- function(environmentId, databaseName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxChangesets",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/changesets",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .finspace$list_kx_changesets_input(environmentId = environmentId, databaseName = databaseName, nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_changesets_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_changesets <- finspace_list_kx_changesets

#' Lists all the nodes in a kdb cluster
#'
#' @description
#' Lists all the nodes in a kdb cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_cluster_nodes/](https://www.paws-r-sdk.com/docs/finspace_list_kx_cluster_nodes/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterName &#91;required&#93; A unique name for the cluster.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_cluster_nodes
finspace_list_kx_cluster_nodes <- function(environmentId, clusterName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxClusterNodes",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}/nodes",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .finspace$list_kx_cluster_nodes_input(environmentId = environmentId, clusterName = clusterName, nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_cluster_nodes_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_cluster_nodes <- finspace_list_kx_cluster_nodes

#' Returns a list of clusters
#'
#' @description
#' Returns a list of clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_clusters/](https://www.paws-r-sdk.com/docs/finspace_list_kx_clusters/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param clusterType Specifies the type of KDB database that is being created. The following
#' types are available:
#' 
#' -   HDB – A Historical Database. The data is only accessible with
#'     read-only permissions from one of the FinSpace managed kdb databases
#'     mounted to the cluster.
#' 
#' -   RDB – A Realtime Database. This type of database captures all the
#'     data from a ticker plant and stores it in memory until the end of
#'     day, after which it writes all of its data to a disk and reloads the
#'     HDB. This cluster type requires local storage for temporary storage
#'     of data during the savedown process. If you specify this field in
#'     your request, you must provide the `savedownStorageConfiguration`
#'     parameter.
#' 
#' -   GATEWAY – A gateway cluster allows you to access data across
#'     processes in kdb systems. It allows you to create your own routing
#'     logic using the initialization scripts and custom code. This type of
#'     cluster does not require a writable local storage.
#' 
#' -   GP – A general purpose cluster allows you to quickly iterate on code
#'     during development by granting greater access to system commands and
#'     enabling a fast reload of custom code. This cluster type can
#'     optionally mount databases including cache and savedown storage. For
#'     this cluster type, the node count is fixed at 1. It does not support
#'     autoscaling and supports only `SINGLE` AZ mode.
#' 
#' -   Tickerplant – A tickerplant cluster allows you to subscribe to feed
#'     handlers based on IAM permissions. It can publish to RDBs, other
#'     Tickerplants, and real-time subscribers (RTS). Tickerplants can
#'     persist messages to log, which is readable by any RDB environment.
#'     It supports only single-node that is only one kdb process.
#' @param maxResults The maximum number of results to return in this request.
#' @param nextToken A token that indicates where a results page should begin.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_clusters
finspace_list_kx_clusters <- function(environmentId, clusterType = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListKxClusters",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/clusters",
    paginator = list()
  )
  input <- .finspace$list_kx_clusters_input(environmentId = environmentId, clusterType = clusterType, maxResults = maxResults, nextToken = nextToken)
  output <- .finspace$list_kx_clusters_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_clusters <- finspace_list_kx_clusters

#' Returns a list of all the databases in the kdb environment
#'
#' @description
#' Returns a list of all the databases in the kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_databases/](https://www.paws-r-sdk.com/docs/finspace_list_kx_databases/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_databases
finspace_list_kx_databases <- function(environmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxDatabases",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .finspace$list_kx_databases_input(environmentId = environmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_databases_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_databases <- finspace_list_kx_databases

#' Returns a list of all the dataviews in the database
#'
#' @description
#' Returns a list of all the dataviews in the database.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_dataviews/](https://www.paws-r-sdk.com/docs/finspace_list_kx_dataviews/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, for which you want to
#' retrieve a list of dataviews.
#' @param databaseName &#91;required&#93; The name of the database where the dataviews were created.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_dataviews
finspace_list_kx_dataviews <- function(environmentId, databaseName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxDataviews",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/dataviews",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .finspace$list_kx_dataviews_input(environmentId = environmentId, databaseName = databaseName, nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_dataviews_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_dataviews <- finspace_list_kx_dataviews

#' Returns a list of kdb environments created in an account
#'
#' @description
#' Returns a list of kdb environments created in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_environments/](https://www.paws-r-sdk.com/docs/finspace_list_kx_environments/) for full documentation.
#'
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_environments
finspace_list_kx_environments <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxEnvironments",
    http_method = "GET",
    http_path = "/kx/environments",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "environments")
  )
  input <- .finspace$list_kx_environments_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_environments_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_environments <- finspace_list_kx_environments

#' Returns a list of scaling groups in a kdb environment
#'
#' @description
#' Returns a list of scaling groups in a kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_scaling_groups/](https://www.paws-r-sdk.com/docs/finspace_list_kx_scaling_groups/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, for which you want to
#' retrieve a list of scaling groups.
#' @param maxResults The maximum number of results to return in this request.
#' @param nextToken A token that indicates where a results page should begin.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_scaling_groups
finspace_list_kx_scaling_groups <- function(environmentId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListKxScalingGroups",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/scalingGroups",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .finspace$list_kx_scaling_groups_input(environmentId = environmentId, maxResults = maxResults, nextToken = nextToken)
  output <- .finspace$list_kx_scaling_groups_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_scaling_groups <- finspace_list_kx_scaling_groups

#' Lists all the users in a kdb environment
#'
#' @description
#' Lists all the users in a kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_users/](https://www.paws-r-sdk.com/docs/finspace_list_kx_users/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_users
finspace_list_kx_users <- function(environmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKxUsers",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/users",
    paginator = list()
  )
  input <- .finspace$list_kx_users_input(environmentId = environmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_kx_users_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_users <- finspace_list_kx_users

#' Lists all the volumes in a kdb environment
#'
#' @description
#' Lists all the volumes in a kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_kx_volumes/](https://www.paws-r-sdk.com/docs/finspace_list_kx_volumes/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, whose clusters can attach
#' to the volume.
#' @param maxResults The maximum number of results to return in this request.
#' @param nextToken A token that indicates where a results page should begin.
#' @param volumeType The type of file system volume. Currently, FinSpace only supports
#' `NAS_1` volume type.
#'
#' @keywords internal
#'
#' @rdname finspace_list_kx_volumes
finspace_list_kx_volumes <- function(environmentId, maxResults = NULL, nextToken = NULL, volumeType = NULL) {
  op <- new_operation(
    name = "ListKxVolumes",
    http_method = "GET",
    http_path = "/kx/environments/{environmentId}/kxvolumes",
    paginator = list()
  )
  input <- .finspace$list_kx_volumes_input(environmentId = environmentId, maxResults = maxResults, nextToken = nextToken, volumeType = volumeType)
  output <- .finspace$list_kx_volumes_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_kx_volumes <- finspace_list_kx_volumes

#' A list of all tags for a resource
#'
#' @description
#' A list of all tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/finspace_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name of the resource.
#'
#' @keywords internal
#'
#' @rdname finspace_list_tags_for_resource
finspace_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .finspace$list_tags_for_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_tags_for_resource <- finspace_list_tags_for_resource

#' Adds metadata tags to a FinSpace resource
#'
#' @description
#' Adds metadata tags to a FinSpace resource.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_tag_resource/](https://www.paws-r-sdk.com/docs/finspace_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource.
#' @param tags &#91;required&#93; One or more tags to be assigned to the resource.
#'
#' @keywords internal
#'
#' @rdname finspace_tag_resource
finspace_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .finspace$tag_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$tag_resource <- finspace_tag_resource

#' Removes metadata tags from a FinSpace resource
#'
#' @description
#' Removes metadata tags from a FinSpace resource.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_untag_resource/](https://www.paws-r-sdk.com/docs/finspace_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; A FinSpace resource from which you want to remove a tag or tags. The
#' value for this parameter is an Amazon Resource Name (ARN).
#' @param tagKeys &#91;required&#93; The tag keys (names) of one or more tags to be removed.
#'
#' @keywords internal
#'
#' @rdname finspace_untag_resource
finspace_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .finspace$untag_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$untag_resource <- finspace_untag_resource

#' Update your FinSpace environment
#'
#' @description
#' Update your FinSpace environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_environment/](https://www.paws-r-sdk.com/docs/finspace_update_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier of the FinSpace environment.
#' @param name The name of the environment.
#' @param description The description of the environment.
#' @param federationMode Authentication mode for the environment.
#' 
#' -   `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via
#'     your Identity provider.
#' 
#' -   `LOCAL` - Users access FinSpace via email and password managed
#'     within the FinSpace environment.
#' @param federationParameters 
#'
#' @keywords internal
#'
#' @rdname finspace_update_environment
finspace_update_environment <- function(environmentId, name = NULL, description = NULL, federationMode = NULL, federationParameters = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "PUT",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$update_environment_input(environmentId = environmentId, name = name, description = description, federationMode = federationMode, federationParameters = federationParameters)
  output <- .finspace$update_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_environment <- finspace_update_environment

#' Allows you to update code configuration on a running cluster
#'
#' @description
#' Allows you to update code configuration on a running cluster. By using this API you can update the code, the initialization script path, and the command line arguments for a specific cluster. The configuration that you want to update will override any existing configurations on the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_code_configuration/](https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_code_configuration/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier of the kdb environment.
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param code &#91;required&#93; 
#' @param initializationScript Specifies a Q program that will be run at launch of a cluster. It is a
#' relative path within *.zip* file that contains the custom code, which
#' will be loaded on the cluster. It must include the file name itself. For
#' example, `somedir/init.q`.
#' 
#' You cannot update this parameter for a `NO_RESTART` deployment.
#' @param commandLineArguments Specifies the key-value pairs to make them available inside the cluster.
#' 
#' You cannot update this parameter for a `NO_RESTART` deployment.
#' @param deploymentConfiguration The configuration that allows you to choose how you want to update the
#' code on a cluster.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_cluster_code_configuration
finspace_update_kx_cluster_code_configuration <- function(environmentId, clusterName, clientToken = NULL, code, initializationScript = NULL, commandLineArguments = NULL, deploymentConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateKxClusterCodeConfiguration",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}/configuration/code",
    paginator = list()
  )
  input <- .finspace$update_kx_cluster_code_configuration_input(environmentId = environmentId, clusterName = clusterName, clientToken = clientToken, code = code, initializationScript = initializationScript, commandLineArguments = commandLineArguments, deploymentConfiguration = deploymentConfiguration)
  output <- .finspace$update_kx_cluster_code_configuration_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_cluster_code_configuration <- finspace_update_kx_cluster_code_configuration

#' Updates the databases mounted on a kdb cluster, which includes the
#' changesetId and all the dbPaths to be cached
#'
#' @description
#' Updates the databases mounted on a kdb cluster, which includes the `changesetId` and all the dbPaths to be cached. This API does not allow you to change a database name or add a database if you created a cluster without one.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_databases/](https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_databases/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The unique identifier of a kdb environment.
#' @param clusterName &#91;required&#93; A unique name for the cluster that you want to modify.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param databases &#91;required&#93; The structure of databases mounted on the cluster.
#' @param deploymentConfiguration The configuration that allows you to choose how you want to update the
#' databases on a cluster.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_cluster_databases
finspace_update_kx_cluster_databases <- function(environmentId, clusterName, clientToken = NULL, databases, deploymentConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateKxClusterDatabases",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/clusters/{clusterName}/configuration/databases",
    paginator = list()
  )
  input <- .finspace$update_kx_cluster_databases_input(environmentId = environmentId, clusterName = clusterName, clientToken = clientToken, databases = databases, deploymentConfiguration = deploymentConfiguration)
  output <- .finspace$update_kx_cluster_databases_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_cluster_databases <- finspace_update_kx_cluster_databases

#' Updates information for the given kdb database
#'
#' @description
#' Updates information for the given kdb database.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_database/](https://www.paws-r-sdk.com/docs/finspace_update_kx_database/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param databaseName &#91;required&#93; The name of the kdb database.
#' @param description A description of the database.
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_database
finspace_update_kx_database <- function(environmentId, databaseName, description = NULL, clientToken) {
  op <- new_operation(
    name = "UpdateKxDatabase",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}",
    paginator = list()
  )
  input <- .finspace$update_kx_database_input(environmentId = environmentId, databaseName = databaseName, description = description, clientToken = clientToken)
  output <- .finspace$update_kx_database_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_database <- finspace_update_kx_database

#' Updates the specified dataview
#'
#' @description
#' Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested. Each update of the dataview creates a new version, including changeset details and cache configurations
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_dataview/](https://www.paws-r-sdk.com/docs/finspace_update_kx_dataview/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment, where you want to update
#' the dataview.
#' @param databaseName &#91;required&#93; The name of the database.
#' @param dataviewName &#91;required&#93; The name of the dataview that you want to update.
#' @param description The description for a dataview.
#' @param changesetId A unique identifier for the changeset.
#' @param segmentConfigurations The configuration that contains the database path of the data that you
#' want to place on each selected volume. Each segment must have a unique
#' database path for each volume. If you do not explicitly specify any
#' database path for a volume, they are accessible from the cluster through
#' the default S3/object store segment.
#' @param clientToken &#91;required&#93; A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_dataview
finspace_update_kx_dataview <- function(environmentId, databaseName, dataviewName, description = NULL, changesetId = NULL, segmentConfigurations = NULL, clientToken) {
  op <- new_operation(
    name = "UpdateKxDataview",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
    paginator = list()
  )
  input <- .finspace$update_kx_dataview_input(environmentId = environmentId, databaseName = databaseName, dataviewName = dataviewName, description = description, changesetId = changesetId, segmentConfigurations = segmentConfigurations, clientToken = clientToken)
  output <- .finspace$update_kx_dataview_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_dataview <- finspace_update_kx_dataview

#' Updates information for the given kdb environment
#'
#' @description
#' Updates information for the given kdb environment.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_environment/](https://www.paws-r-sdk.com/docs/finspace_update_kx_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param name The name of the kdb environment.
#' @param description A description of the kdb environment.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_environment
finspace_update_kx_environment <- function(environmentId, name = NULL, description = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateKxEnvironment",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}",
    paginator = list()
  )
  input <- .finspace$update_kx_environment_input(environmentId = environmentId, name = name, description = description, clientToken = clientToken)
  output <- .finspace$update_kx_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_environment <- finspace_update_kx_environment

#' Updates environment network to connect to your internal network by using
#' a transit gateway
#'
#' @description
#' Updates environment network to connect to your internal network by using a transit gateway. This API supports request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom Route-53 outbound resolvers.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_environment_network/](https://www.paws-r-sdk.com/docs/finspace_update_kx_environment_network/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param transitGatewayConfiguration Specifies the transit gateway and network configuration to connect the
#' kdb environment to an internal network.
#' @param customDNSConfiguration A list of DNS server name and server IP. This is used to set up Route-53
#' outbound resolvers.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_environment_network
finspace_update_kx_environment_network <- function(environmentId, transitGatewayConfiguration = NULL, customDNSConfiguration = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateKxEnvironmentNetwork",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/network",
    paginator = list()
  )
  input <- .finspace$update_kx_environment_network_input(environmentId = environmentId, transitGatewayConfiguration = transitGatewayConfiguration, customDNSConfiguration = customDNSConfiguration, clientToken = clientToken)
  output <- .finspace$update_kx_environment_network_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_environment_network <- finspace_update_kx_environment_network

#' Updates the user details
#'
#' @description
#' Updates the user details. You can only update the IAM role associated with a user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_user/](https://www.paws-r-sdk.com/docs/finspace_update_kx_user/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment.
#' @param userName &#91;required&#93; A unique identifier for the user.
#' @param iamRole &#91;required&#93; The IAM role ARN that is associated with the user.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_user
finspace_update_kx_user <- function(environmentId, userName, iamRole, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateKxUser",
    http_method = "PUT",
    http_path = "/kx/environments/{environmentId}/users/{userName}",
    paginator = list()
  )
  input <- .finspace$update_kx_user_input(environmentId = environmentId, userName = userName, iamRole = iamRole, clientToken = clientToken)
  output <- .finspace$update_kx_user_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_user <- finspace_update_kx_user

#' Updates the throughput or capacity of a volume
#'
#' @description
#' Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable for a few minutes. You can retry any operations after the update is complete.
#'
#' See [https://www.paws-r-sdk.com/docs/finspace_update_kx_volume/](https://www.paws-r-sdk.com/docs/finspace_update_kx_volume/) for full documentation.
#'
#' @param environmentId &#91;required&#93; A unique identifier for the kdb environment where you created the
#' storage volume.
#' @param volumeName &#91;required&#93; A unique identifier for the volume.
#' @param description A description of the volume.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param nas1Configuration Specifies the configuration for the Network attached storage (NAS_1)
#' file system volume.
#'
#' @keywords internal
#'
#' @rdname finspace_update_kx_volume
finspace_update_kx_volume <- function(environmentId, volumeName, description = NULL, clientToken = NULL, nas1Configuration = NULL) {
  op <- new_operation(
    name = "UpdateKxVolume",
    http_method = "PATCH",
    http_path = "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
    paginator = list()
  )
  input <- .finspace$update_kx_volume_input(environmentId = environmentId, volumeName = volumeName, description = description, clientToken = clientToken, nas1Configuration = nas1Configuration)
  output <- .finspace$update_kx_volume_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_kx_volume <- finspace_update_kx_volume
