# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' FinSpace User Environment Management service
#'
#' @description
#' The FinSpace management service provides the APIs for managing FinSpace
#' environments.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- finspace(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- finspace()
#' svc$create_environment(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=finspace_create_environment]{create_environment} \tab Create a new FinSpace environment\cr
#'  \link[=finspace_create_kx_changeset]{create_kx_changeset} \tab Creates a changeset for a kdb database\cr
#'  \link[=finspace_create_kx_cluster]{create_kx_cluster} \tab Creates a new kdb cluster\cr
#'  \link[=finspace_create_kx_database]{create_kx_database} \tab Creates a new kdb database in the environment\cr
#'  \link[=finspace_create_kx_dataview]{create_kx_dataview} \tab Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters\cr
#'  \link[=finspace_create_kx_environment]{create_kx_environment} \tab Creates a managed kdb environment for the account\cr
#'  \link[=finspace_create_kx_scaling_group]{create_kx_scaling_group} \tab Creates a new scaling group\cr
#'  \link[=finspace_create_kx_user]{create_kx_user} \tab Creates a user in FinSpace kdb environment with an associated IAM role\cr
#'  \link[=finspace_create_kx_volume]{create_kx_volume} \tab Creates a new volume with a specific amount of throughput and storage capacity\cr
#'  \link[=finspace_delete_environment]{delete_environment} \tab Delete an FinSpace environment\cr
#'  \link[=finspace_delete_kx_cluster]{delete_kx_cluster} \tab Deletes a kdb cluster\cr
#'  \link[=finspace_delete_kx_cluster_node]{delete_kx_cluster_node} \tab Deletes the specified nodes from a cluster\cr
#'  \link[=finspace_delete_kx_database]{delete_kx_database} \tab Deletes the specified database and all of its associated data\cr
#'  \link[=finspace_delete_kx_dataview]{delete_kx_dataview} \tab Deletes the specified dataview\cr
#'  \link[=finspace_delete_kx_environment]{delete_kx_environment} \tab Deletes the kdb environment\cr
#'  \link[=finspace_delete_kx_scaling_group]{delete_kx_scaling_group} \tab Deletes the specified scaling group\cr
#'  \link[=finspace_delete_kx_user]{delete_kx_user} \tab Deletes a user in the specified kdb environment\cr
#'  \link[=finspace_delete_kx_volume]{delete_kx_volume} \tab Deletes a volume\cr
#'  \link[=finspace_get_environment]{get_environment} \tab Returns the FinSpace environment object\cr
#'  \link[=finspace_get_kx_changeset]{get_kx_changeset} \tab Returns information about a kdb changeset\cr
#'  \link[=finspace_get_kx_cluster]{get_kx_cluster} \tab Retrieves information about a kdb cluster\cr
#'  \link[=finspace_get_kx_connection_string]{get_kx_connection_string} \tab Retrieves a connection string for a user to connect to a kdb cluster\cr
#'  \link[=finspace_get_kx_database]{get_kx_database} \tab Returns database information for the specified environment ID\cr
#'  \link[=finspace_get_kx_dataview]{get_kx_dataview} \tab Retrieves details of the dataview\cr
#'  \link[=finspace_get_kx_environment]{get_kx_environment} \tab Retrieves all the information for the specified kdb environment\cr
#'  \link[=finspace_get_kx_scaling_group]{get_kx_scaling_group} \tab Retrieves details of a scaling group\cr
#'  \link[=finspace_get_kx_user]{get_kx_user} \tab Retrieves information about the specified kdb user\cr
#'  \link[=finspace_get_kx_volume]{get_kx_volume} \tab Retrieves the information about the volume\cr
#'  \link[=finspace_list_environments]{list_environments} \tab A list of all of your FinSpace environments\cr
#'  \link[=finspace_list_kx_changesets]{list_kx_changesets} \tab Returns a list of all the changesets for a database\cr
#'  \link[=finspace_list_kx_cluster_nodes]{list_kx_cluster_nodes} \tab Lists all the nodes in a kdb cluster\cr
#'  \link[=finspace_list_kx_clusters]{list_kx_clusters} \tab Returns a list of clusters\cr
#'  \link[=finspace_list_kx_databases]{list_kx_databases} \tab Returns a list of all the databases in the kdb environment\cr
#'  \link[=finspace_list_kx_dataviews]{list_kx_dataviews} \tab Returns a list of all the dataviews in the database\cr
#'  \link[=finspace_list_kx_environments]{list_kx_environments} \tab Returns a list of kdb environments created in an account\cr
#'  \link[=finspace_list_kx_scaling_groups]{list_kx_scaling_groups} \tab Returns a list of scaling groups in a kdb environment\cr
#'  \link[=finspace_list_kx_users]{list_kx_users} \tab Lists all the users in a kdb environment\cr
#'  \link[=finspace_list_kx_volumes]{list_kx_volumes} \tab Lists all the volumes in a kdb environment\cr
#'  \link[=finspace_list_tags_for_resource]{list_tags_for_resource} \tab A list of all tags for a resource\cr
#'  \link[=finspace_tag_resource]{tag_resource} \tab Adds metadata tags to a FinSpace resource\cr
#'  \link[=finspace_untag_resource]{untag_resource} \tab Removes metadata tags from a FinSpace resource\cr
#'  \link[=finspace_update_environment]{update_environment} \tab Update your FinSpace environment\cr
#'  \link[=finspace_update_kx_cluster_code_configuration]{update_kx_cluster_code_configuration} \tab Allows you to update code configuration on a running cluster\cr
#'  \link[=finspace_update_kx_cluster_databases]{update_kx_cluster_databases} \tab Updates the databases mounted on a kdb cluster, which includes the changesetId and all the dbPaths to be cached\cr
#'  \link[=finspace_update_kx_database]{update_kx_database} \tab Updates information for the given kdb database\cr
#'  \link[=finspace_update_kx_dataview]{update_kx_dataview} \tab Updates the specified dataview\cr
#'  \link[=finspace_update_kx_environment]{update_kx_environment} \tab Updates information for the given kdb environment\cr
#'  \link[=finspace_update_kx_environment_network]{update_kx_environment_network} \tab Updates environment network to connect to your internal network by using a transit gateway\cr
#'  \link[=finspace_update_kx_user]{update_kx_user} \tab Updates the user details\cr
#'  \link[=finspace_update_kx_volume]{update_kx_volume} \tab Updates the throughput or capacity of a volume
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname finspace
#' @export
finspace <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .finspace$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.finspace <- list()

.finspace$operations <- list()

.finspace$metadata <- list(
  service_name = "finspace",
  endpoints = list("*" = list(endpoint = "finspace.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "finspace.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "finspace.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "finspace.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "finspace.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "finspace.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "finspace",
  api_version = "2021-03-12",
  signing_name = "finspace",
  json_version = "1.1",
  target_prefix = ""
)

.finspace$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.finspace$metadata, handlers, config, op)
}
