% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_composite_alarm}
\alias{cloudwatch_put_composite_alarm}
\title{Creates or updates a composite alarm}
\usage{
cloudwatch_put_composite_alarm(
  ActionsEnabled = NULL,
  AlarmActions = NULL,
  AlarmDescription = NULL,
  AlarmName,
  AlarmRule,
  InsufficientDataActions = NULL,
  OKActions = NULL,
  Tags = NULL,
  ActionsSuppressor = NULL,
  ActionsSuppressorWaitPeriod = NULL,
  ActionsSuppressorExtensionPeriod = NULL
)
}
\arguments{
\item{ActionsEnabled}{Indicates whether actions should be executed during any changes to the
alarm state of the composite alarm. The default is \code{TRUE}.}

\item{AlarmActions}{The actions to execute when this alarm transitions to the \code{ALARM} state
from any other state. Each action is specified as an Amazon Resource
Name (ARN).

Valid Values: ]

\strong{Amazon SNS actions:}

\code{arn:aws:sns:region:account-id:sns-topic-name }

\strong{Lambda actions:}
\itemize{
\item Invoke the latest version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name }
\item Invoke a specific version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:version-number }
\item Invoke a function by using an alias Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:alias-name }
}

\strong{Systems Manager actions:}

\code{arn:aws:ssm:region:account-id:opsitem:severity }}

\item{AlarmDescription}{The description for the composite alarm.}

\item{AlarmName}{[required] The name for the composite alarm. This name must be unique within the
Region.}

\item{AlarmRule}{[required] An expression that specifies which other alarms are to be evaluated to
determine this composite alarm's state. For each alarm that you
reference, you designate a function that specifies whether that alarm
needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You
can use operators (AND, OR and NOT) to combine multiple functions in a
single expression. You can use parenthesis to logically group the
functions in your expression.

You can use either alarm names or ARNs to reference the other alarms
that are to be evaluated.

Functions can include the following:
\itemize{
\item \code{ALARM("alarm-name or alarm-ARN")} is TRUE if the named alarm is in
ALARM state.
\item \code{OK("alarm-name or alarm-ARN")} is TRUE if the named alarm is in OK
state.
\item \code{INSUFFICIENT_DATA("alarm-name or alarm-ARN")} is TRUE if the named
alarm is in INSUFFICIENT_DATA state.
\item \code{TRUE} always evaluates to TRUE.
\item \code{FALSE} always evaluates to FALSE.
}

TRUE and FALSE are useful for testing a complex \code{AlarmRule} structure,
and for testing your alarm actions.

Alarm names specified in \code{AlarmRule} can be surrounded with
double-quotes ("), but do not have to be.

The following are some examples of \code{AlarmRule}:
\itemize{
\item \verb{ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)}
specifies that the composite alarm goes into ALARM state only if
both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in
ALARM state.
\item \verb{ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)}
specifies that the alarm goes to ALARM state if
CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is
not in ALARM state. This example reduces alarm noise during a known
deployment window.
\item \verb{(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)}
goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh
is in ALARM state, and if NetworkOutTooHigh is in OK state. This
provides another example of using a composite alarm to prevent
noise. This rule ensures that you are not notified with an alarm
action on high CPU or disk usage if a known network problem is also
occurring.
}

The \code{AlarmRule} can specify as many as 100 "children" alarms. The
\code{AlarmRule} expression can have as many as 500 elements. Elements are
child alarms, TRUE or FALSE statements, and parentheses.}

\item{InsufficientDataActions}{The actions to execute when this alarm transitions to the
\code{INSUFFICIENT_DATA} state from any other state. Each action is specified
as an Amazon Resource Name (ARN).

Valid Values: ]

\strong{Amazon SNS actions:}

\code{arn:aws:sns:region:account-id:sns-topic-name }

\strong{Lambda actions:}
\itemize{
\item Invoke the latest version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name }
\item Invoke a specific version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:version-number }
\item Invoke a function by using an alias Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:alias-name }
}}

\item{OKActions}{The actions to execute when this alarm transitions to an \code{OK} state from
any other state. Each action is specified as an Amazon Resource Name
(ARN).

Valid Values: ]

\strong{Amazon SNS actions:}

\code{arn:aws:sns:region:account-id:sns-topic-name }

\strong{Lambda actions:}
\itemize{
\item Invoke the latest version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name }
\item Invoke a specific version of a Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:version-number }
\item Invoke a function by using an alias Lambda function:
\verb{arn:aws:lambda:region:account-id:function:function-name:alias-name }
}}

\item{Tags}{A list of key-value pairs to associate with the alarm. You can associate
as many as 50 tags with an alarm. To be able to associate tags with the
alarm when you create the alarm, you must have the
\code{cloudwatch:TagResource} permission.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

If you are using this operation to update an existing alarm, any tags
you specify in this parameter are ignored. To change the tags of an
existing alarm, use \code{\link[=cloudwatch_tag_resource]{tag_resource}} or
\code{\link[=cloudwatch_untag_resource]{untag_resource}}.}

\item{ActionsSuppressor}{Actions will be suppressed if the suppressor alarm is in the \code{ALARM}
state. \code{ActionsSuppressor} can be an AlarmName or an Amazon Resource
Name (ARN) from an existing alarm.}

\item{ActionsSuppressorWaitPeriod}{The maximum time in seconds that the composite alarm waits for the
suppressor alarm to go into the \code{ALARM} state. After this time, the
composite alarm performs its actions.

\code{WaitPeriod} is required only when \code{ActionsSuppressor} is specified.}

\item{ActionsSuppressorExtensionPeriod}{The maximum time in seconds that the composite alarm waits after
suppressor alarm goes out of the \code{ALARM} state. After this time, the
composite alarm performs its actions.

\code{ExtensionPeriod} is required only when \code{ActionsSuppressor} is
specified.}
}
\description{
Creates or updates a \emph{composite alarm}. When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_put_composite_alarm/} for full documentation.
}
\keyword{internal}
