% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_recommendation_templates}
\alias{resiliencehub_list_recommendation_templates}
\title{Lists the recommendation templates for the Resilience Hub applications}
\usage{
resiliencehub_list_recommendation_templates(
  assessmentArn = NULL,
  maxResults = NULL,
  name = NULL,
  nextToken = NULL,
  recommendationTemplateArn = NULL,
  reverseOrder = NULL,
  status = NULL
)
}
\arguments{
\item{assessmentArn}{Amazon Resource Name (ARN) of the assessment. The format for this ARN
is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app-assessment/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{maxResults}{Maximum number of results to include in the response. If more results
exist than the specified \code{MaxResults} value, a token is included in the
response so that the remaining results can be retrieved.}

\item{name}{The name for one of the listed recommendation templates.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}

\item{recommendationTemplateArn}{The Amazon Resource Name (ARN) for a recommendation template.}

\item{reverseOrder}{The default is to sort by ascending \strong{startTime}. To sort by descending
\strong{startTime}, set reverseOrder to \code{true}.}

\item{status}{Status of the action.}
}
\description{
Lists the recommendation templates for the Resilience Hub applications.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_recommendation_templates/} for full documentation.
}
\keyword{internal}
