% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_alarm_recommendations}
\alias{resiliencehub_list_alarm_recommendations}
\title{Lists the alarm recommendations for an Resilience Hub application}
\usage{
resiliencehub_list_alarm_recommendations(
  assessmentArn,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{assessmentArn}{[required] Amazon Resource Name (ARN) of the assessment. The format for this ARN
is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app-assessment/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{maxResults}{Maximum number of results to include in the response. If more results
exist than the specified \code{MaxResults} value, a token is included in the
response so that the remaining results can be retrieved.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}
}
\description{
Lists the alarm recommendations for an Resilience Hub application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_alarm_recommendations/} for full documentation.
}
\keyword{internal}
