% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_disassociate_connection_from_lag}
\alias{directconnect_disassociate_connection_from_lag}
\title{Disassociates a connection from a link aggregation group (LAG)}
\usage{
directconnect_disassociate_connection_from_lag(connectionId, lagId)
}
\arguments{
\item{connectionId}{[required] The ID of the connection.}

\item{lagId}{[required] The ID of the LAG.}
}
\description{
Disassociates a connection from a link aggregation group (LAG). The
connection is interrupted and re-established as a standalone connection
(the connection is not deleted; to delete the connection, use the
DeleteConnection request). If the LAG has associated virtual interfaces
or hosted connections, they remain associated with the LAG. A
disassociated connection owned by an AWS Direct Connect Partner is
automatically converted to an interconnect.

If disassociating the connection would cause the LAG to fall below its
setting for minimum number of operational connections, the request
fails, except when it's the last member of the LAG. If all connections
are disassociated, the LAG continues to exist as an empty LAG with no
physical connections.
}
\section{Request syntax}{
\preformatted{svc$disassociate_connection_from_lag(
  connectionId = "string",
  lagId = "string"
)
}
}

\keyword{internal}
