% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_listener}
\alias{elbv2_create_listener}
\title{Creates a listener for the specified Application Load Balancer, Network
Load Balancer}
\usage{
elbv2_create_listener(LoadBalancerArn, Protocol, Port, SslPolicy,
  Certificates, DefaultActions, AlpnPolicy, Tags)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{Protocol}{The protocol for connections from clients to the load balancer. For
Application Load Balancers, the supported protocols are HTTP and HTTPS.
For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if
dual-stack mode is enabled. You cannot specify a protocol for a Gateway
Load Balancer.}

\item{Port}{The port on which the load balancer is listening. You cannot specify a
port for a Gateway Load Balancer.}

\item{SslPolicy}{[HTTPS and TLS listeners] The security policy that defines which
protocols and ciphers are supported.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies}{Security policies}
in the \emph{Application Load Balancers Guide} and \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies}{Security policies}
in the \emph{Network Load Balancers Guide}.}

\item{Certificates}{[HTTPS and TLS listeners] The default certificate for the listener.
You must provide exactly one certificate. Set \code{CertificateArn} to the
certificate ARN but do not set \code{IsDefault}.}

\item{DefaultActions}{[required] The actions for the default rule.}

\item{AlpnPolicy}{[TLS listeners] The name of the Application-Layer Protocol Negotiation
(ALPN) policy. You can specify one policy name. The following are the
possible values:
\itemize{
\item \code{HTTP1Only}
\item \code{HTTP2Only}
\item \code{HTTP2Optional}
\item \code{HTTP2Preferred}
\item \code{None}
}

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies}{ALPN policies}
in the \emph{Network Load Balancers Guide}.}

\item{Tags}{The tags to assign to the listener.}
}
\value{
A list with the following syntax:\preformatted{list(
  Listeners = list(
    list(
      ListenerArn = "string",
      LoadBalancerArn = "string",
      Port = 123,
      Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
      Certificates = list(
        list(
          CertificateArn = "string",
          IsDefault = TRUE|FALSE
        )
      ),
      SslPolicy = "string",
      DefaultActions = list(
        list(
          Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
          TargetGroupArn = "string",
          AuthenticateOidcConfig = list(
            Issuer = "string",
            AuthorizationEndpoint = "string",
            TokenEndpoint = "string",
            UserInfoEndpoint = "string",
            ClientId = "string",
            ClientSecret = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
            UseExistingClientSecret = TRUE|FALSE
          ),
          AuthenticateCognitoConfig = list(
            UserPoolArn = "string",
            UserPoolClientId = "string",
            UserPoolDomain = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
          ),
          Order = 123,
          RedirectConfig = list(
            Protocol = "string",
            Port = "string",
            Host = "string",
            Path = "string",
            Query = "string",
            StatusCode = "HTTP_301"|"HTTP_302"
          ),
          FixedResponseConfig = list(
            MessageBody = "string",
            StatusCode = "string",
            ContentType = "string"
          ),
          ForwardConfig = list(
            TargetGroups = list(
              list(
                TargetGroupArn = "string",
                Weight = 123
              )
            ),
            TargetGroupStickinessConfig = list(
              Enabled = TRUE|FALSE,
              DurationSeconds = 123
            )
          )
        )
      ),
      AlpnPolicy = list(
        "string"
      )
    )
  )
)
}
}
\description{
Creates a listener for the specified Application Load Balancer, Network
Load Balancer. or Gateway Load Balancer.

For more information, see the following:
\itemize{
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html}{Listeners for your Application Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html}{Listeners for your Network Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html}{Listeners for your Gateway Load Balancers}
}

This operation is idempotent, which means that it completes at most one
time. If you attempt to create multiple listeners with the same
settings, each call succeeds.
}
\section{Request syntax}{
\preformatted{svc$create_listener(
  LoadBalancerArn = "string",
  Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
  Port = 123,
  SslPolicy = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  ),
  DefaultActions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      ),
      ForwardConfig = list(
        TargetGroups = list(
          list(
            TargetGroupArn = "string",
            Weight = 123
          )
        ),
        TargetGroupStickinessConfig = list(
          Enabled = TRUE|FALSE,
          DurationSeconds = 123
        )
      )
    )
  ),
  AlpnPolicy = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates an HTTP listener for the specified load balancer
# that forwards requests to the specified target group.
svc$create_listener(
  DefaultActions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012...",
      Type = "forward"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:lo...",
  Port = 80L,
  Protocol = "HTTP"
)

# This example creates an HTTPS listener for the specified load balancer
# that forwards requests to the specified target group. Note that you must
# specify an SSL certificate for an HTTPS listener. You can create and
# manage certificates using AWS Certificate Manager (ACM). Alternatively,
# you can create a certificate using SSL/TLS tools, get the certificate
# signed by a certificate authority (CA), and upload the certificate to
# AWS Identity and Access Management (IAM).
svc$create_listener(
  Certificates = list(
    list(
      CertificateArn = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
    )
  ),
  DefaultActions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012...",
      Type = "forward"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:lo...",
  Port = 443L,
  Protocol = "HTTPS",
  SslPolicy = "ELBSecurityPolicy-2015-05"
)
}

}
\keyword{internal}
