# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cognitoidentityprovider_service.R
NULL

#' Adds additional user attributes to the user pool schema
#'
#' Adds additional user attributes to the user pool schema.
#'
#' @usage
#' cognitoidentityprovider_add_custom_attributes(UserPoolId,
#'   CustomAttributes)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to add custom
#' attributes.
#' @param CustomAttributes &#91;required&#93; An array of custom attributes, such as Mutable and Name.
#'
#' @section Request syntax:
#' ```
#' svc$add_custom_attributes(
#'   UserPoolId = "string",
#'   CustomAttributes = list(
#'     list(
#'       Name = "string",
#'       AttributeDataType = "String"|"Number"|"DateTime"|"Boolean",
#'       DeveloperOnlyAttribute = TRUE|FALSE,
#'       Mutable = TRUE|FALSE,
#'       Required = TRUE|FALSE,
#'       NumberAttributeConstraints = list(
#'         MinValue = "string",
#'         MaxValue = "string"
#'       ),
#'       StringAttributeConstraints = list(
#'         MinLength = "string",
#'         MaxLength = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_add_custom_attributes
cognitoidentityprovider_add_custom_attributes <- function(UserPoolId, CustomAttributes) {
  op <- new_operation(
    name = "AddCustomAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$add_custom_attributes_input(UserPoolId = UserPoolId, CustomAttributes = CustomAttributes)
  output <- .cognitoidentityprovider$add_custom_attributes_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$add_custom_attributes <- cognitoidentityprovider_add_custom_attributes

#' Adds the specified user to the specified group
#'
#' Adds the specified user to the specified group.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_add_user_to_group(UserPoolId, Username,
#'   GroupName)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Username &#91;required&#93; The username for the user.
#' @param GroupName &#91;required&#93; The group name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_add_user_to_group(
#'   UserPoolId = "string",
#'   Username = "string",
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_add_user_to_group
cognitoidentityprovider_admin_add_user_to_group <- function(UserPoolId, Username, GroupName) {
  op <- new_operation(
    name = "AdminAddUserToGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_add_user_to_group_input(UserPoolId = UserPoolId, Username = Username, GroupName = GroupName)
  output <- .cognitoidentityprovider$admin_add_user_to_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_add_user_to_group <- cognitoidentityprovider_admin_add_user_to_group

#' Confirms user registration as an admin without using a confirmation code
#'
#' Confirms user registration as an admin without using a confirmation
#' code. Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_confirm_sign_up(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for which you want to confirm user registration.
#' @param Username &#91;required&#93; The user name for which you want to confirm user registration.
#'
#' @section Request syntax:
#' ```
#' svc$admin_confirm_sign_up(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_confirm_sign_up
cognitoidentityprovider_admin_confirm_sign_up <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminConfirmSignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_confirm_sign_up_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_confirm_sign_up_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_confirm_sign_up <- cognitoidentityprovider_admin_confirm_sign_up

#' Creates a new user in the specified user pool
#'
#' Creates a new user in the specified user pool.
#' 
#' If `MessageAction` is not set, the default is to send a welcome message
#' via email or phone (SMS).
#' 
#' This message is based on a template that you configured in your call to
#' or . This template includes your custom sign-up instructions and
#' placeholders for user name and temporary password.
#' 
#' Alternatively, you can call AdminCreateUser with "SUPPRESS" for the
#' `MessageAction` parameter, and Amazon Cognito will not send any email.
#' 
#' In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state
#' until they sign in and change their password.
#' 
#' AdminCreateUser requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_create_user(UserPoolId, Username,
#'   UserAttributes, ValidationData, TemporaryPassword, ForceAliasCreation,
#'   MessageAction, DesiredDeliveryMediums)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where the user will be created.
#' @param Username &#91;required&#93; The username for the user. Must be unique within the user pool. Must be
#' a UTF-8 string between 1 and 128 characters. After the user is created,
#' the username cannot be changed.
#' @param UserAttributes An array of name-value pairs that contain user attributes and attribute
#' values to be set for the user to be created. You can create a user
#' without specifying any attributes other than `Username`. However, any
#' attributes that you specify as required (in or in the **Attributes** tab
#' of the console) must be supplied either by you (in your call to
#' `AdminCreateUser`) or by the user (when he or she signs up in response
#' to your welcome message).
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' 
#' To send a message inviting the user to sign up, you must specify the
#' user\'s email address or phone number. This can be done in your call to
#' AdminCreateUser or in the **Users** tab of the Amazon Cognito console
#' for managing your user pools.
#' 
#' In your call to `AdminCreateUser`, you can set the `email_verified`
#' attribute to `True`, and you can set the `phone_number_verified`
#' attribute to `True`. (You can also do this by calling .)
#' 
#' -   **email**: The email address of the user to whom the message that
#'     contains the code and username will be sent. Required if the
#'     `email_verified` attribute is set to `True`, or if `"EMAIL"` is
#'     specified in the `DesiredDeliveryMediums` parameter.
#' 
#' -   **phone\\_number**: The phone number of the user to whom the message
#'     that contains the code and username will be sent. Required if the
#'     `phone_number_verified` attribute is set to `True`, or if `"SMS"` is
#'     specified in the `DesiredDeliveryMediums` parameter.
#' @param ValidationData The user\'s validation data. This is an array of name-value pairs that
#' contain user attributes and attribute values that you can use for custom
#' validation, such as restricting the types of user accounts that can be
#' registered. For example, you might choose to allow or disallow user
#' sign-up based on the user\'s domain.
#' 
#' To configure custom validation, you must create a Pre Sign-up Lambda
#' trigger for the user pool as described in the Amazon Cognito Developer
#' Guide. The Lambda trigger receives the validation data and uses it in
#' the validation process.
#' 
#' The user\'s validation data is not persisted.
#' @param TemporaryPassword The user\'s temporary password. This password must conform to the
#' password policy that you specified when you created the user pool.
#' 
#' The temporary password is valid only once. To complete the Admin Create
#' User flow, the user must enter the temporary password in the sign-in
#' page along with a new password to be used in all future sign-ins.
#' 
#' This parameter is not required. If you do not specify a value, Amazon
#' Cognito generates one for you.
#' 
#' The temporary password can only be used until the user account
#' expiration limit that you specified when you created the user pool. To
#' reset the account after that time limit, you must call `AdminCreateUser`
#' again, specifying `"RESEND"` for the `MessageAction` parameter.
#' @param ForceAliasCreation This parameter is only used if the `phone_number_verified` or
#' `email_verified` attribute is set to `True`. Otherwise, it is ignored.
#' 
#' If this parameter is set to `True` and the phone number or email address
#' specified in the UserAttributes parameter already exists as an alias
#' with a different user, the API call will migrate the alias from the
#' previous user to the newly created user. The previous user will no
#' longer be able to log in using that alias.
#' 
#' If this parameter is set to `False`, the API throws an
#' `AliasExistsException` error if the alias already exists. The default
#' value is `False`.
#' @param MessageAction Set to `"RESEND"` to resend the invitation message to a user that
#' already exists and reset the expiration limit on the user\'s account.
#' Set to `"SUPPRESS"` to suppress sending the message. Only one value can
#' be specified.
#' @param DesiredDeliveryMediums Specify `"EMAIL"` if email will be used to send the welcome message.
#' Specify `"SMS"` if the phone number will be used. The default value is
#' `"SMS"`. More than one value can be specified.
#'
#' @section Request syntax:
#' ```
#' svc$admin_create_user(
#'   UserPoolId = "string",
#'   Username = "string",
#'   UserAttributes = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ValidationData = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TemporaryPassword = "string",
#'   ForceAliasCreation = TRUE|FALSE,
#'   MessageAction = "RESEND"|"SUPPRESS",
#'   DesiredDeliveryMediums = list(
#'     "SMS"|"EMAIL"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_create_user
cognitoidentityprovider_admin_create_user <- function(UserPoolId, Username, UserAttributes = NULL, ValidationData = NULL, TemporaryPassword = NULL, ForceAliasCreation = NULL, MessageAction = NULL, DesiredDeliveryMediums = NULL) {
  op <- new_operation(
    name = "AdminCreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_create_user_input(UserPoolId = UserPoolId, Username = Username, UserAttributes = UserAttributes, ValidationData = ValidationData, TemporaryPassword = TemporaryPassword, ForceAliasCreation = ForceAliasCreation, MessageAction = MessageAction, DesiredDeliveryMediums = DesiredDeliveryMediums)
  output <- .cognitoidentityprovider$admin_create_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_create_user <- cognitoidentityprovider_admin_create_user

#' Deletes a user as an administrator
#'
#' Deletes a user as an administrator. Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_delete_user(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete the user.
#' @param Username &#91;required&#93; The user name of the user you wish to delete.
#'
#' @section Request syntax:
#' ```
#' svc$admin_delete_user(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_delete_user
cognitoidentityprovider_admin_delete_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminDeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_delete_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_delete_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_delete_user <- cognitoidentityprovider_admin_delete_user

#' Deletes the user attributes in a user pool as an administrator
#'
#' Deletes the user attributes in a user pool as an administrator. Works on
#' any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_delete_user_attributes(UserPoolId,
#'   Username, UserAttributeNames)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete user
#' attributes.
#' @param Username &#91;required&#93; The user name of the user from which you would like to delete
#' attributes.
#' @param UserAttributeNames &#91;required&#93; An array of strings representing the user attribute names you wish to
#' delete.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_delete_user_attributes(
#'   UserPoolId = "string",
#'   Username = "string",
#'   UserAttributeNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_delete_user_attributes
cognitoidentityprovider_admin_delete_user_attributes <- function(UserPoolId, Username, UserAttributeNames) {
  op <- new_operation(
    name = "AdminDeleteUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_delete_user_attributes_input(UserPoolId = UserPoolId, Username = Username, UserAttributeNames = UserAttributeNames)
  output <- .cognitoidentityprovider$admin_delete_user_attributes_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_delete_user_attributes <- cognitoidentityprovider_admin_delete_user_attributes

#' Disables the user from signing in with the specified external (SAML or
#' social) identity provider
#'
#' Disables the user from signing in with the specified external (SAML or
#' social) identity provider. If the user to disable is a Cognito User
#' Pools native username + password user, they are not permitted to use
#' their password to sign-in. If the user to disable is a linked external
#' IdP user, any link between that user and an existing user is removed.
#' The next time the external user (no longer attached to the previously
#' linked `DestinationUser`) signs in, they must create a new user account.
#' See .
#' 
#' This action is enabled only for admin access and requires developer
#' credentials.
#' 
#' The `ProviderName` must match the value specified when creating an IdP
#' for the pool.
#' 
#' To disable a native username + password user, the `ProviderName` value
#' must be `Cognito` and the `ProviderAttributeName` must be
#' `Cognito_Subject`, with the `ProviderAttributeValue` being the name that
#' is used in the user pool for the user.
#' 
#' The `ProviderAttributeName` must always be `Cognito_Subject` for social
#' identity providers. The `ProviderAttributeValue` must always be the
#' exact subject that was used when the user was originally linked as a
#' source user.
#' 
#' For de-linking a SAML identity, there are two scenarios. If the linked
#' identity has not yet been used to sign-in, the `ProviderAttributeName`
#' and `ProviderAttributeValue` must be the same values that were used for
#' the `SourceUser` when the identities were originally linked in the call.
#' (If the linking was done with `ProviderAttributeName` set to
#' `Cognito_Subject`, the same applies here). However, if the user has
#' already signed in, the `ProviderAttributeName` must be `Cognito_Subject`
#' and `ProviderAttributeValue` must be the subject of the SAML assertion.
#'
#' @usage
#' cognitoidentityprovider_admin_disable_provider_for_user(UserPoolId,
#'   User)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param User &#91;required&#93; The user to be disabled.
#'
#' @section Request syntax:
#' ```
#' svc$admin_disable_provider_for_user(
#'   UserPoolId = "string",
#'   User = list(
#'     ProviderName = "string",
#'     ProviderAttributeName = "string",
#'     ProviderAttributeValue = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_disable_provider_for_user
cognitoidentityprovider_admin_disable_provider_for_user <- function(UserPoolId, User) {
  op <- new_operation(
    name = "AdminDisableProviderForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_disable_provider_for_user_input(UserPoolId = UserPoolId, User = User)
  output <- .cognitoidentityprovider$admin_disable_provider_for_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_disable_provider_for_user <- cognitoidentityprovider_admin_disable_provider_for_user

#' Disables the specified user as an administrator
#'
#' Disables the specified user as an administrator. Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_disable_user(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to disable the user.
#' @param Username &#91;required&#93; The user name of the user you wish to disable.
#'
#' @section Request syntax:
#' ```
#' svc$admin_disable_user(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_disable_user
cognitoidentityprovider_admin_disable_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminDisableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_disable_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_disable_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_disable_user <- cognitoidentityprovider_admin_disable_user

#' Enables the specified user as an administrator
#'
#' Enables the specified user as an administrator. Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_enable_user(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to enable the user.
#' @param Username &#91;required&#93; The user name of the user you wish to enable.
#'
#' @section Request syntax:
#' ```
#' svc$admin_enable_user(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_enable_user
cognitoidentityprovider_admin_enable_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminEnableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_enable_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_enable_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_enable_user <- cognitoidentityprovider_admin_enable_user

#' Forgets the device, as an administrator
#'
#' Forgets the device, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_forget_device(UserPoolId, Username,
#'   DeviceKey)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param DeviceKey &#91;required&#93; The device key.
#'
#' @section Request syntax:
#' ```
#' svc$admin_forget_device(
#'   UserPoolId = "string",
#'   Username = "string",
#'   DeviceKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_forget_device
cognitoidentityprovider_admin_forget_device <- function(UserPoolId, Username, DeviceKey) {
  op <- new_operation(
    name = "AdminForgetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_forget_device_input(UserPoolId = UserPoolId, Username = Username, DeviceKey = DeviceKey)
  output <- .cognitoidentityprovider$admin_forget_device_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_forget_device <- cognitoidentityprovider_admin_forget_device

#' Gets the device, as an administrator
#'
#' Gets the device, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_get_device(DeviceKey, UserPoolId,
#'   Username)
#'
#' @param DeviceKey &#91;required&#93; The device key.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_get_device(
#'   DeviceKey = "string",
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_get_device
cognitoidentityprovider_admin_get_device <- function(DeviceKey, UserPoolId, Username) {
  op <- new_operation(
    name = "AdminGetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_get_device_input(DeviceKey = DeviceKey, UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_get_device_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_get_device <- cognitoidentityprovider_admin_get_device

#' Gets the specified user by user name in a user pool as an administrator
#'
#' Gets the specified user by user name in a user pool as an administrator.
#' Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_get_user(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to get information
#' about the user.
#' @param Username &#91;required&#93; The user name of the user you wish to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$admin_get_user(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_get_user
cognitoidentityprovider_admin_get_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminGetUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_get_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_get_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_get_user <- cognitoidentityprovider_admin_get_user

#' Initiates the authentication flow, as an administrator
#'
#' Initiates the authentication flow, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_initiate_auth(UserPoolId, ClientId,
#'   AuthFlow, AuthParameters, ClientMetadata, AnalyticsMetadata,
#'   ContextData)
#'
#' @param UserPoolId &#91;required&#93; The ID of the Amazon Cognito user pool.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param AuthFlow &#91;required&#93; The authentication flow for this call to execute. The API action will
#' depend on this value. For example:
#' 
#' -   `REFRESH_TOKEN_AUTH` will take in a valid refresh token and return
#'     new tokens.
#' 
#' -   `USER_SRP_AUTH` will take in `USERNAME` and `SRP_A` and return the
#'     SRP variables to be used for next challenge execution.
#' 
#' -   `USER_PASSWORD_AUTH` will take in `USERNAME` and `PASSWORD` and
#'     return the next challenge or tokens.
#' 
#' Valid values include:
#' 
#' -   `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password
#'     (SRP) protocol.
#' 
#' -   `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for
#'     refreshing the access token and ID token by supplying a valid
#'     refresh token.
#' 
#' -   `CUSTOM_AUTH`: Custom authentication flow.
#' 
#' -   `ADMIN_NO_SRP_AUTH`: Non-SRP authentication flow; you can pass in
#'     the USERNAME and PASSWORD directly if the flow is enabled for
#'     calling the app client.
#' 
#' -   `USER_PASSWORD_AUTH`: Non-SRP authentication flow; USERNAME and
#'     PASSWORD are passed directly. If a user migration Lambda trigger is
#'     set, this flow will invoke the user migration Lambda if the USERNAME
#'     is not found in the user pool.
#' @param AuthParameters The authentication parameters. These are inputs corresponding to the
#' `AuthFlow` that you are invoking. The required values depend on the
#' value of `AuthFlow`:
#' 
#' -   For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`
#' 
#' -   For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`
#' 
#' -   For `ADMIN_NO_SRP_AUTH`: `USERNAME` (required), `SECRET_HASH` (if
#'     app client is configured with client secret), `PASSWORD` (required),
#'     `DEVICE_KEY`
#' 
#' -   For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app
#'     client is configured with client secret), `DEVICE_KEY`
#' @param ClientMetadata This is a random key-value pair map which can contain any key and will
#' be passed to your PreAuthentication Lambda trigger as-is. It can be used
#' to implement additional validations around authentication.
#' @param AnalyticsMetadata The analytics metadata for collecting Amazon Pinpoint metrics for
#' `AdminInitiateAuth` calls.
#' @param ContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$admin_initiate_auth(
#'   UserPoolId = "string",
#'   ClientId = "string",
#'   AuthFlow = "USER_SRP_AUTH"|"REFRESH_TOKEN_AUTH"|"REFRESH_TOKEN"|"CUSTOM_AUTH"|"ADMIN_NO_SRP_AUTH"|"USER_PASSWORD_AUTH",
#'   AuthParameters = list(
#'     "string"
#'   ),
#'   ClientMetadata = list(
#'     "string"
#'   ),
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   ContextData = list(
#'     IpAddress = "string",
#'     ServerName = "string",
#'     ServerPath = "string",
#'     HttpHeaders = list(
#'       list(
#'         headerName = "string",
#'         headerValue = "string"
#'       )
#'     ),
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_initiate_auth
cognitoidentityprovider_admin_initiate_auth <- function(UserPoolId, ClientId, AuthFlow, AuthParameters = NULL, ClientMetadata = NULL, AnalyticsMetadata = NULL, ContextData = NULL) {
  op <- new_operation(
    name = "AdminInitiateAuth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_initiate_auth_input(UserPoolId = UserPoolId, ClientId = ClientId, AuthFlow = AuthFlow, AuthParameters = AuthParameters, ClientMetadata = ClientMetadata, AnalyticsMetadata = AnalyticsMetadata, ContextData = ContextData)
  output <- .cognitoidentityprovider$admin_initiate_auth_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_initiate_auth <- cognitoidentityprovider_admin_initiate_auth

#' Links an existing user account in a user pool (DestinationUser) to an
#' identity from an external identity provider (SourceUser) based on a
#' specified attribute name and value from the external identity provider
#'
#' Links an existing user account in a user pool (`DestinationUser`) to an
#' identity from an external identity provider (`SourceUser`) based on a
#' specified attribute name and value from the external identity provider.
#' This allows you to create a link from the existing user account to an
#' external federated user identity that has not yet been used to sign in,
#' so that the federated user identity can be used to sign in as the
#' existing user account.
#' 
#' For example, if there is an existing user with a username and password,
#' this API links that user to a federated user identity, so that when the
#' federated user identity is used, the user signs in as the existing user
#' account.
#' 
#' Because this API allows a user with an external federated identity to
#' sign in as an existing user in the user pool, it is critical that it
#' only be used with external identity providers and provider attributes
#' that have been trusted by the application owner.
#' 
#' See also .
#' 
#' This action is enabled only for admin access and requires developer
#' credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_link_provider_for_user(UserPoolId,
#'   DestinationUser, SourceUser)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param DestinationUser &#91;required&#93; The existing user in the user pool to be linked to the external identity
#' provider user account. Can be a native (Username + Password) Cognito
#' User Pools user or a federated user (for example, a SAML or Facebook
#' user). If the user doesn\'t exist, an exception is thrown. This is the
#' user that is returned when the new user (with the linked identity
#' provider attribute) signs in.
#' 
#' For a native username + password user, the `ProviderAttributeValue` for
#' the `DestinationUser` should be the username in the user pool. For a
#' federated user, it should be the provider-specific `user_id`.
#' 
#' The `ProviderAttributeName` of the `DestinationUser` is ignored.
#' 
#' The `ProviderName` should be set to `Cognito` for users in Cognito user
#' pools.
#' @param SourceUser &#91;required&#93; An external identity provider account for a user who does not currently
#' exist yet in the user pool. This user must be a federated user (for
#' example, a SAML or Facebook user), not another native user.
#' 
#' If the `SourceUser` is a federated social identity provider user
#' (Facebook, Google, or Login with Amazon), you must set the
#' `ProviderAttributeName` to `Cognito_Subject`. For social identity
#' providers, the `ProviderName` will be `Facebook`, `Google`, or
#' `LoginWithAmazon`, and Cognito will automatically parse the Facebook,
#' Google, and Login with Amazon tokens for `id`, `sub`, and `user_id`,
#' respectively. The `ProviderAttributeValue` for the user must be the same
#' value as the `id`, `sub`, or `user_id` value found in the social
#' identity provider token.
#' 
#' For SAML, the `ProviderAttributeName` can be any value that matches a
#' claim in the SAML assertion. If you wish to link SAML users based on the
#' subject of the SAML assertion, you should map the subject to a claim
#' through the SAML identity provider and submit that claim name as the
#' `ProviderAttributeName`. If you set `ProviderAttributeName` to
#' `Cognito_Subject`, Cognito will automatically parse the default unique
#' identifier found in the subject from the SAML token.
#'
#' @section Request syntax:
#' ```
#' svc$admin_link_provider_for_user(
#'   UserPoolId = "string",
#'   DestinationUser = list(
#'     ProviderName = "string",
#'     ProviderAttributeName = "string",
#'     ProviderAttributeValue = "string"
#'   ),
#'   SourceUser = list(
#'     ProviderName = "string",
#'     ProviderAttributeName = "string",
#'     ProviderAttributeValue = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_link_provider_for_user
cognitoidentityprovider_admin_link_provider_for_user <- function(UserPoolId, DestinationUser, SourceUser) {
  op <- new_operation(
    name = "AdminLinkProviderForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_link_provider_for_user_input(UserPoolId = UserPoolId, DestinationUser = DestinationUser, SourceUser = SourceUser)
  output <- .cognitoidentityprovider$admin_link_provider_for_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_link_provider_for_user <- cognitoidentityprovider_admin_link_provider_for_user

#' Lists devices, as an administrator
#'
#' Lists devices, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_list_devices(UserPoolId, Username, Limit,
#'   PaginationToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param Limit The limit of the devices request.
#' @param PaginationToken The pagination token.
#'
#' @section Request syntax:
#' ```
#' svc$admin_list_devices(
#'   UserPoolId = "string",
#'   Username = "string",
#'   Limit = 123,
#'   PaginationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_devices
cognitoidentityprovider_admin_list_devices <- function(UserPoolId, Username, Limit = NULL, PaginationToken = NULL) {
  op <- new_operation(
    name = "AdminListDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_devices_input(UserPoolId = UserPoolId, Username = Username, Limit = Limit, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$admin_list_devices_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_devices <- cognitoidentityprovider_admin_list_devices

#' Lists the groups that the user belongs to
#'
#' Lists the groups that the user belongs to.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_list_groups_for_user(Username, UserPoolId,
#'   Limit, NextToken)
#'
#' @param Username &#91;required&#93; The username for the user.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Limit The limit of the request to list groups.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @section Request syntax:
#' ```
#' svc$admin_list_groups_for_user(
#'   Username = "string",
#'   UserPoolId = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_groups_for_user
cognitoidentityprovider_admin_list_groups_for_user <- function(Username, UserPoolId, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "AdminListGroupsForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_groups_for_user_input(Username = Username, UserPoolId = UserPoolId, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$admin_list_groups_for_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_groups_for_user <- cognitoidentityprovider_admin_list_groups_for_user

#' Lists a history of user activity and any risks detected as part of
#' Amazon Cognito advanced security
#'
#' Lists a history of user activity and any risks detected as part of
#' Amazon Cognito advanced security.
#'
#' @usage
#' cognitoidentityprovider_admin_list_user_auth_events(UserPoolId,
#'   Username, MaxResults, NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username or an alias.
#' @param MaxResults The maximum number of authentication events to return.
#' @param NextToken A pagination token.
#'
#' @section Request syntax:
#' ```
#' svc$admin_list_user_auth_events(
#'   UserPoolId = "string",
#'   Username = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_user_auth_events
cognitoidentityprovider_admin_list_user_auth_events <- function(UserPoolId, Username, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "AdminListUserAuthEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_user_auth_events_input(UserPoolId = UserPoolId, Username = Username, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$admin_list_user_auth_events_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_user_auth_events <- cognitoidentityprovider_admin_list_user_auth_events

#' Removes the specified user from the specified group
#'
#' Removes the specified user from the specified group.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_remove_user_from_group(UserPoolId,
#'   Username, GroupName)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Username &#91;required&#93; The username for the user.
#' @param GroupName &#91;required&#93; The group name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_remove_user_from_group(
#'   UserPoolId = "string",
#'   Username = "string",
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_remove_user_from_group
cognitoidentityprovider_admin_remove_user_from_group <- function(UserPoolId, Username, GroupName) {
  op <- new_operation(
    name = "AdminRemoveUserFromGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_remove_user_from_group_input(UserPoolId = UserPoolId, Username = Username, GroupName = GroupName)
  output <- .cognitoidentityprovider$admin_remove_user_from_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_remove_user_from_group <- cognitoidentityprovider_admin_remove_user_from_group

#' Resets the specified user's password in a user pool as an administrator
#'
#' Resets the specified user\'s password in a user pool as an
#' administrator. Works on any user.
#' 
#' When a developer calls this API, the current password is invalidated, so
#' it must be changed. If a user tries to sign in after the API is called,
#' the app will get a PasswordResetRequiredException exception back and
#' should direct the user down the flow to reset the password, which is the
#' same as the forgot password flow. In addition, if the user pool has
#' phone verification selected and a verified phone number exists for the
#' user, or if email verification is selected and a verified email exists
#' for the user, calling this API will also result in sending a message to
#' the end user with the code to change their password.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_reset_user_password(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to reset the user\'s
#' password.
#' @param Username &#91;required&#93; The user name of the user whose password you wish to reset.
#'
#' @section Request syntax:
#' ```
#' svc$admin_reset_user_password(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_reset_user_password
cognitoidentityprovider_admin_reset_user_password <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminResetUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_reset_user_password_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_reset_user_password_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_reset_user_password <- cognitoidentityprovider_admin_reset_user_password

#' Responds to an authentication challenge, as an administrator
#'
#' Responds to an authentication challenge, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_respond_to_auth_challenge(UserPoolId,
#'   ClientId, ChallengeName, ChallengeResponses, Session, AnalyticsMetadata,
#'   ContextData)
#'
#' @param UserPoolId &#91;required&#93; The ID of the Amazon Cognito user pool.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param ChallengeName &#91;required&#93; The challenge name. For more information, see .
#' @param ChallengeResponses The challenge responses. These are inputs corresponding to the value of
#' `ChallengeName`, for example:
#' 
#' -   `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`, `SECRET_HASH` (if app client
#'     is configured with client secret).
#' 
#' -   `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`,
#'     `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`,
#'     `SECRET_HASH` (if app client is configured with client secret).
#' 
#' -   `ADMIN_NO_SRP_AUTH`: `PASSWORD`, `USERNAME`, `SECRET_HASH` (if app
#'     client is configured with client secret).
#' 
#' -   `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, any other required
#'     attributes, `USERNAME`, `SECRET_HASH` (if app client is configured
#'     with client secret).
#' 
#' The value of the `USERNAME` attribute must be the user\'s actual
#' username, not an alias (such as email address or phone number). To make
#' this easier, the `AdminInitiateAuth` response includes the actual
#' username value in the `USERNAMEUSER_ID_FOR_SRP` attribute, even if you
#' specified an alias in your call to `AdminInitiateAuth`.
#' @param Session The session which should be passed both ways in challenge-response calls
#' to the service. If `InitiateAuth` or `RespondToAuthChallenge` API call
#' determines that the caller needs to go through another challenge, they
#' return a session with other challenge parameters. This session should be
#' passed as it is to the next `RespondToAuthChallenge` API call.
#' @param AnalyticsMetadata The analytics metadata for collecting Amazon Pinpoint metrics for
#' `AdminRespondToAuthChallenge` calls.
#' @param ContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$admin_respond_to_auth_challenge(
#'   UserPoolId = "string",
#'   ClientId = "string",
#'   ChallengeName = "SMS_MFA"|"SOFTWARE_TOKEN_MFA"|"SELECT_MFA_TYPE"|"MFA_SETUP"|"PASSWORD_VERIFIER"|"CUSTOM_CHALLENGE"|"DEVICE_SRP_AUTH"|"DEVICE_PASSWORD_VERIFIER"|"ADMIN_NO_SRP_AUTH"|"NEW_PASSWORD_REQUIRED",
#'   ChallengeResponses = list(
#'     "string"
#'   ),
#'   Session = "string",
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   ContextData = list(
#'     IpAddress = "string",
#'     ServerName = "string",
#'     ServerPath = "string",
#'     HttpHeaders = list(
#'       list(
#'         headerName = "string",
#'         headerValue = "string"
#'       )
#'     ),
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_respond_to_auth_challenge
cognitoidentityprovider_admin_respond_to_auth_challenge <- function(UserPoolId, ClientId, ChallengeName, ChallengeResponses = NULL, Session = NULL, AnalyticsMetadata = NULL, ContextData = NULL) {
  op <- new_operation(
    name = "AdminRespondToAuthChallenge",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_respond_to_auth_challenge_input(UserPoolId = UserPoolId, ClientId = ClientId, ChallengeName = ChallengeName, ChallengeResponses = ChallengeResponses, Session = Session, AnalyticsMetadata = AnalyticsMetadata, ContextData = ContextData)
  output <- .cognitoidentityprovider$admin_respond_to_auth_challenge_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_respond_to_auth_challenge <- cognitoidentityprovider_admin_respond_to_auth_challenge

#' Sets the user's multi-factor authentication (MFA) preference
#'
#' Sets the user\'s multi-factor authentication (MFA) preference.
#'
#' @usage
#' cognitoidentityprovider_admin_set_user_mfa_preference(SMSMfaSettings,
#'   SoftwareTokenMfaSettings, Username, UserPoolId)
#'
#' @param SMSMfaSettings The SMS text message MFA settings.
#' @param SoftwareTokenMfaSettings The time-based one-time password software token MFA settings.
#' @param Username &#91;required&#93; The user pool username or alias.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @section Request syntax:
#' ```
#' svc$admin_set_user_mfa_preference(
#'   SMSMfaSettings = list(
#'     Enabled = TRUE|FALSE,
#'     PreferredMfa = TRUE|FALSE
#'   ),
#'   SoftwareTokenMfaSettings = list(
#'     Enabled = TRUE|FALSE,
#'     PreferredMfa = TRUE|FALSE
#'   ),
#'   Username = "string",
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_set_user_mfa_preference
cognitoidentityprovider_admin_set_user_mfa_preference <- function(SMSMfaSettings = NULL, SoftwareTokenMfaSettings = NULL, Username, UserPoolId) {
  op <- new_operation(
    name = "AdminSetUserMFAPreference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_set_user_mfa_preference_input(SMSMfaSettings = SMSMfaSettings, SoftwareTokenMfaSettings = SoftwareTokenMfaSettings, Username = Username, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$admin_set_user_mfa_preference_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_set_user_mfa_preference <- cognitoidentityprovider_admin_set_user_mfa_preference

#' Sets all the user settings for a specified user name
#'
#' Sets all the user settings for a specified user name. Works on any user.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_set_user_settings(UserPoolId, Username,
#'   MFAOptions)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to set the user\'s
#' settings, such as MFA options.
#' @param Username &#91;required&#93; The user name of the user for whom you wish to set user settings.
#' @param MFAOptions &#91;required&#93; Specifies the options for MFA (e.g., email or phone number).
#'
#' @section Request syntax:
#' ```
#' svc$admin_set_user_settings(
#'   UserPoolId = "string",
#'   Username = "string",
#'   MFAOptions = list(
#'     list(
#'       DeliveryMedium = "SMS"|"EMAIL",
#'       AttributeName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_set_user_settings
cognitoidentityprovider_admin_set_user_settings <- function(UserPoolId, Username, MFAOptions) {
  op <- new_operation(
    name = "AdminSetUserSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_set_user_settings_input(UserPoolId = UserPoolId, Username = Username, MFAOptions = MFAOptions)
  output <- .cognitoidentityprovider$admin_set_user_settings_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_set_user_settings <- cognitoidentityprovider_admin_set_user_settings

#' Provides feedback for an authentication event as to whether it was from
#' a valid user
#'
#' Provides feedback for an authentication event as to whether it was from
#' a valid user. This feedback is used for improving the risk evaluation
#' decision for the user pool as part of Amazon Cognito advanced security.
#'
#' @usage
#' cognitoidentityprovider_admin_update_auth_event_feedback(UserPoolId,
#'   Username, EventId, FeedbackValue)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username.
#' @param EventId &#91;required&#93; The authentication event ID.
#' @param FeedbackValue &#91;required&#93; The authentication event feedback value.
#'
#' @section Request syntax:
#' ```
#' svc$admin_update_auth_event_feedback(
#'   UserPoolId = "string",
#'   Username = "string",
#'   EventId = "string",
#'   FeedbackValue = "Valid"|"Invalid"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_auth_event_feedback
cognitoidentityprovider_admin_update_auth_event_feedback <- function(UserPoolId, Username, EventId, FeedbackValue) {
  op <- new_operation(
    name = "AdminUpdateAuthEventFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_auth_event_feedback_input(UserPoolId = UserPoolId, Username = Username, EventId = EventId, FeedbackValue = FeedbackValue)
  output <- .cognitoidentityprovider$admin_update_auth_event_feedback_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_auth_event_feedback <- cognitoidentityprovider_admin_update_auth_event_feedback

#' Updates the device status as an administrator
#'
#' Updates the device status as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_update_device_status(UserPoolId, Username,
#'   DeviceKey, DeviceRememberedStatus)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceRememberedStatus The status indicating whether a device has been remembered or not.
#'
#' @section Request syntax:
#' ```
#' svc$admin_update_device_status(
#'   UserPoolId = "string",
#'   Username = "string",
#'   DeviceKey = "string",
#'   DeviceRememberedStatus = "remembered"|"not_remembered"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_device_status
cognitoidentityprovider_admin_update_device_status <- function(UserPoolId, Username, DeviceKey, DeviceRememberedStatus = NULL) {
  op <- new_operation(
    name = "AdminUpdateDeviceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_device_status_input(UserPoolId = UserPoolId, Username = Username, DeviceKey = DeviceKey, DeviceRememberedStatus = DeviceRememberedStatus)
  output <- .cognitoidentityprovider$admin_update_device_status_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_device_status <- cognitoidentityprovider_admin_update_device_status

#' Updates the specified user's attributes, including developer attributes,
#' as an administrator
#'
#' Updates the specified user\'s attributes, including developer
#' attributes, as an administrator. Works on any user.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' 
#' In addition to updating user attributes, this API can also be used to
#' mark phone and email as verified.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_update_user_attributes(UserPoolId,
#'   Username, UserAttributes)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to update user
#' attributes.
#' @param Username &#91;required&#93; The user name of the user for whom you want to update user attributes.
#' @param UserAttributes &#91;required&#93; An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_update_user_attributes(
#'   UserPoolId = "string",
#'   Username = "string",
#'   UserAttributes = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_user_attributes
cognitoidentityprovider_admin_update_user_attributes <- function(UserPoolId, Username, UserAttributes) {
  op <- new_operation(
    name = "AdminUpdateUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_user_attributes_input(UserPoolId = UserPoolId, Username = Username, UserAttributes = UserAttributes)
  output <- .cognitoidentityprovider$admin_update_user_attributes_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_user_attributes <- cognitoidentityprovider_admin_update_user_attributes

#' Signs out users from all devices, as an administrator
#'
#' Signs out users from all devices, as an administrator.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_admin_user_global_sign_out(UserPoolId, Username)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#'
#' @section Request syntax:
#' ```
#' svc$admin_user_global_sign_out(
#'   UserPoolId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_user_global_sign_out
cognitoidentityprovider_admin_user_global_sign_out <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminUserGlobalSignOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_user_global_sign_out_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_user_global_sign_out_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_user_global_sign_out <- cognitoidentityprovider_admin_user_global_sign_out

#' Returns a unique generated shared secret key code for the user account
#'
#' Returns a unique generated shared secret key code for the user account.
#' The request takes an access token or a session string, but not both.
#'
#' @usage
#' cognitoidentityprovider_associate_software_token(AccessToken, Session)
#'
#' @param AccessToken The access token.
#' @param Session The session which should be passed both ways in challenge-response calls
#' to the service. This allows authentication of the user as part of the
#' MFA setup process.
#'
#' @section Request syntax:
#' ```
#' svc$associate_software_token(
#'   AccessToken = "string",
#'   Session = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_associate_software_token
cognitoidentityprovider_associate_software_token <- function(AccessToken = NULL, Session = NULL) {
  op <- new_operation(
    name = "AssociateSoftwareToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$associate_software_token_input(AccessToken = AccessToken, Session = Session)
  output <- .cognitoidentityprovider$associate_software_token_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$associate_software_token <- cognitoidentityprovider_associate_software_token

#' Changes the password for a specified user in a user pool
#'
#' Changes the password for a specified user in a user pool.
#'
#' @usage
#' cognitoidentityprovider_change_password(PreviousPassword,
#'   ProposedPassword, AccessToken)
#'
#' @param PreviousPassword &#91;required&#93; The old password.
#' @param ProposedPassword &#91;required&#93; The new password.
#' @param AccessToken &#91;required&#93; The access token.
#'
#' @section Request syntax:
#' ```
#' svc$change_password(
#'   PreviousPassword = "string",
#'   ProposedPassword = "string",
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_change_password
cognitoidentityprovider_change_password <- function(PreviousPassword, ProposedPassword, AccessToken) {
  op <- new_operation(
    name = "ChangePassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$change_password_input(PreviousPassword = PreviousPassword, ProposedPassword = ProposedPassword, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$change_password_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$change_password <- cognitoidentityprovider_change_password

#' Confirms tracking of the device
#'
#' Confirms tracking of the device. This API call is the call that begins
#' device tracking.
#'
#' @usage
#' cognitoidentityprovider_confirm_device(AccessToken, DeviceKey,
#'   DeviceSecretVerifierConfig, DeviceName)
#'
#' @param AccessToken &#91;required&#93; The access token.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceSecretVerifierConfig The configuration of the device secret verifier.
#' @param DeviceName The device name.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_device(
#'   AccessToken = "string",
#'   DeviceKey = "string",
#'   DeviceSecretVerifierConfig = list(
#'     PasswordVerifier = "string",
#'     Salt = "string"
#'   ),
#'   DeviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_device
cognitoidentityprovider_confirm_device <- function(AccessToken, DeviceKey, DeviceSecretVerifierConfig = NULL, DeviceName = NULL) {
  op <- new_operation(
    name = "ConfirmDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_device_input(AccessToken = AccessToken, DeviceKey = DeviceKey, DeviceSecretVerifierConfig = DeviceSecretVerifierConfig, DeviceName = DeviceName)
  output <- .cognitoidentityprovider$confirm_device_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_device <- cognitoidentityprovider_confirm_device

#' Allows a user to enter a confirmation code to reset a forgotten password
#'
#' Allows a user to enter a confirmation code to reset a forgotten
#' password.
#'
#' @usage
#' cognitoidentityprovider_confirm_forgot_password(ClientId, SecretHash,
#'   Username, ConfirmationCode, Password, AnalyticsMetadata,
#'   UserContextData)
#'
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user for whom you want to enter a code to retrieve
#' a forgotten password.
#' @param ConfirmationCode &#91;required&#93; The confirmation code sent by a user\'s request to retrieve a forgotten
#' password. For more information, see
#' @param Password &#91;required&#93; The password sent by a user\'s request to retrieve a forgotten password.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `ConfirmForgotPassword` calls.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_forgot_password(
#'   ClientId = "string",
#'   SecretHash = "string",
#'   Username = "string",
#'   ConfirmationCode = "string",
#'   Password = "string",
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   UserContextData = list(
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_forgot_password
cognitoidentityprovider_confirm_forgot_password <- function(ClientId, SecretHash = NULL, Username, ConfirmationCode, Password, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "ConfirmForgotPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_forgot_password_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, ConfirmationCode = ConfirmationCode, Password = Password, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$confirm_forgot_password_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_forgot_password <- cognitoidentityprovider_confirm_forgot_password

#' Confirms registration of a user and handles the existing alias from a
#' previous user
#'
#' Confirms registration of a user and handles the existing alias from a
#' previous user.
#'
#' @usage
#' cognitoidentityprovider_confirm_sign_up(ClientId, SecretHash, Username,
#'   ConfirmationCode, ForceAliasCreation, AnalyticsMetadata,
#'   UserContextData)
#'
#' @param ClientId &#91;required&#93; The ID of the app client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user whose registration you wish to confirm.
#' @param ConfirmationCode &#91;required&#93; The confirmation code sent by a user\'s request to confirm registration.
#' @param ForceAliasCreation Boolean to be specified to force user confirmation irrespective of
#' existing alias. By default set to `False`. If this parameter is set to
#' `True` and the phone number/email used for sign up confirmation already
#' exists as an alias with a different user, the API call will migrate the
#' alias from the previous user to the newly created user being confirmed.
#' If set to `False`, the API will throw an **AliasExistsException** error.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `ConfirmSignUp` calls.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_sign_up(
#'   ClientId = "string",
#'   SecretHash = "string",
#'   Username = "string",
#'   ConfirmationCode = "string",
#'   ForceAliasCreation = TRUE|FALSE,
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   UserContextData = list(
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_sign_up
cognitoidentityprovider_confirm_sign_up <- function(ClientId, SecretHash = NULL, Username, ConfirmationCode, ForceAliasCreation = NULL, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "ConfirmSignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_sign_up_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, ConfirmationCode = ConfirmationCode, ForceAliasCreation = ForceAliasCreation, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$confirm_sign_up_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_sign_up <- cognitoidentityprovider_confirm_sign_up

#' Creates a new group in the specified user pool
#'
#' Creates a new group in the specified user pool.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_create_group(GroupName, UserPoolId, Description,
#'   RoleArn, Precedence)
#'
#' @param GroupName &#91;required&#93; The name of the group. Must be unique.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Description A string containing the description of the group.
#' @param RoleArn The role ARN for the group.
#' @param Precedence A nonnegative integer value that specifies the precedence of this group
#' relative to the other groups that a user can belong to in the user pool.
#' Zero is the highest precedence value. Groups with lower `Precedence`
#' values take precedence over groups with higher or null `Precedence`
#' values. If a user belongs to two or more groups, it is the group with
#' the lowest precedence value whose role ARN will be used in the
#' `cognito:roles` and `cognito:preferred_role` claims in the user\'s
#' tokens.
#' 
#' Two groups can have the same `Precedence` value. If this happens,
#' neither group takes precedence over the other. If two groups with the
#' same `Precedence` have the same role ARN, that role is used in the
#' `cognito:preferred_role` claim in tokens for users in each group. If the
#' two groups have different role ARNs, the `cognito:preferred_role` claim
#' is not set in users\' tokens.
#' 
#' The default `Precedence` value is null.
#'
#' @section Request syntax:
#' ```
#' svc$create_group(
#'   GroupName = "string",
#'   UserPoolId = "string",
#'   Description = "string",
#'   RoleArn = "string",
#'   Precedence = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_group
cognitoidentityprovider_create_group <- function(GroupName, UserPoolId, Description = NULL, RoleArn = NULL, Precedence = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_group_input(GroupName = GroupName, UserPoolId = UserPoolId, Description = Description, RoleArn = RoleArn, Precedence = Precedence)
  output <- .cognitoidentityprovider$create_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_group <- cognitoidentityprovider_create_group

#' Creates an identity provider for a user pool
#'
#' Creates an identity provider for a user pool.
#'
#' @usage
#' cognitoidentityprovider_create_identity_provider(UserPoolId,
#'   ProviderName, ProviderType, ProviderDetails, AttributeMapping,
#'   IdpIdentifiers)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The identity provider name.
#' @param ProviderType &#91;required&#93; The identity provider type.
#' @param ProviderDetails &#91;required&#93; The identity provider details, such as `MetadataURL` and `MetadataFile`.
#' @param AttributeMapping A mapping of identity provider attributes to standard and custom user
#' pool attributes.
#' @param IdpIdentifiers A list of identity provider identifiers.
#'
#' @section Request syntax:
#' ```
#' svc$create_identity_provider(
#'   UserPoolId = "string",
#'   ProviderName = "string",
#'   ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"OIDC",
#'   ProviderDetails = list(
#'     "string"
#'   ),
#'   AttributeMapping = list(
#'     "string"
#'   ),
#'   IdpIdentifiers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_identity_provider
cognitoidentityprovider_create_identity_provider <- function(UserPoolId, ProviderName, ProviderType, ProviderDetails, AttributeMapping = NULL, IdpIdentifiers = NULL) {
  op <- new_operation(
    name = "CreateIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName, ProviderType = ProviderType, ProviderDetails = ProviderDetails, AttributeMapping = AttributeMapping, IdpIdentifiers = IdpIdentifiers)
  output <- .cognitoidentityprovider$create_identity_provider_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_identity_provider <- cognitoidentityprovider_create_identity_provider

#' Creates a new OAuth2
#'
#' Creates a new OAuth2.0 resource server and defines custom scopes in it.
#'
#' @usage
#' cognitoidentityprovider_create_resource_server(UserPoolId, Identifier,
#'   Name, Scopes)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Identifier &#91;required&#93; A unique resource server identifier for the resource server. This could
#' be an HTTPS endpoint where the resource server is located. For example,
#' `https://my-weather-api.example.com`.
#' @param Name &#91;required&#93; A friendly name for the resource server.
#' @param Scopes A list of scopes. Each scope is map, where the keys are `name` and
#' `description`.
#'
#' @section Request syntax:
#' ```
#' svc$create_resource_server(
#'   UserPoolId = "string",
#'   Identifier = "string",
#'   Name = "string",
#'   Scopes = list(
#'     list(
#'       ScopeName = "string",
#'       ScopeDescription = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_resource_server
cognitoidentityprovider_create_resource_server <- function(UserPoolId, Identifier, Name, Scopes = NULL) {
  op <- new_operation(
    name = "CreateResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier, Name = Name, Scopes = Scopes)
  output <- .cognitoidentityprovider$create_resource_server_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_resource_server <- cognitoidentityprovider_create_resource_server

#' Creates the user import job
#'
#' Creates the user import job.
#'
#' @usage
#' cognitoidentityprovider_create_user_import_job(JobName, UserPoolId,
#'   CloudWatchLogsRoleArn)
#'
#' @param JobName &#91;required&#93; The job name for the user import job.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param CloudWatchLogsRoleArn &#91;required&#93; The role ARN for the Amazon CloudWatch Logging role for the user import
#' job.
#'
#' @section Request syntax:
#' ```
#' svc$create_user_import_job(
#'   JobName = "string",
#'   UserPoolId = "string",
#'   CloudWatchLogsRoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_import_job
cognitoidentityprovider_create_user_import_job <- function(JobName, UserPoolId, CloudWatchLogsRoleArn) {
  op <- new_operation(
    name = "CreateUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_import_job_input(JobName = JobName, UserPoolId = UserPoolId, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn)
  output <- .cognitoidentityprovider$create_user_import_job_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_import_job <- cognitoidentityprovider_create_user_import_job

#' Creates a new Amazon Cognito user pool and sets the password policy for
#' the pool
#'
#' Creates a new Amazon Cognito user pool and sets the password policy for
#' the pool.
#'
#' @usage
#' cognitoidentityprovider_create_user_pool(PoolName, Policies,
#'   LambdaConfig, AutoVerifiedAttributes, AliasAttributes,
#'   UsernameAttributes, SmsVerificationMessage, EmailVerificationMessage,
#'   EmailVerificationSubject, VerificationMessageTemplate,
#'   SmsAuthenticationMessage, MfaConfiguration, DeviceConfiguration,
#'   EmailConfiguration, SmsConfiguration, UserPoolTags,
#'   AdminCreateUserConfig, Schema, UserPoolAddOns)
#'
#' @param PoolName &#91;required&#93; A string used to name the user pool.
#' @param Policies The policies associated with the new user pool.
#' @param LambdaConfig The Lambda trigger configuration information for the new user pool.
#' 
#' In a push model, event sources (such as Amazon S3 and custom
#' applications) need permission to invoke a function. So you will need to
#' make an extra call to add permission for these event sources to invoke
#' your Lambda function.
#' 
#' For more information on using the Lambda API to add permission, see
#' [AddPermission](https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html).
#' 
#' For adding permission using the AWS CLI, see
#' [add-permission](https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html).
#' @param AutoVerifiedAttributes The attributes to be auto-verified. Possible values: **email**,
#' **phone\\_number**.
#' @param AliasAttributes Attributes supported as an alias for this user pool. Possible values:
#' **phone\\_number**, **email**, or **preferred\\_username**.
#' @param UsernameAttributes Specifies whether email addresses or phone numbers can be specified as
#' usernames when a user signs up.
#' @param SmsVerificationMessage A string representing the SMS verification message.
#' @param EmailVerificationMessage A string representing the email verification message.
#' @param EmailVerificationSubject A string representing the email verification subject.
#' @param VerificationMessageTemplate The template for the verification message that the user sees when the
#' app requests permission to access the user\'s information.
#' @param SmsAuthenticationMessage A string representing the SMS authentication message.
#' @param MfaConfiguration Specifies MFA configuration details.
#' @param DeviceConfiguration The device configuration.
#' @param EmailConfiguration The email configuration.
#' @param SmsConfiguration The SMS configuration.
#' @param UserPoolTags The tag keys and values to assign to the user pool. A tag is a label
#' that you can use to categorize and manage user pools in different ways,
#' such as by purpose, owner, environment, or other criteria.
#' @param AdminCreateUserConfig The configuration for `AdminCreateUser` requests.
#' @param Schema An array of schema attributes for the new user pool. These attributes
#' can be standard or custom attributes.
#' @param UserPoolAddOns Used to enable advanced security risk detection. Set the key
#' `AdvancedSecurityMode` to the value \"AUDIT\".
#'
#' @section Request syntax:
#' ```
#' svc$create_user_pool(
#'   PoolName = "string",
#'   Policies = list(
#'     PasswordPolicy = list(
#'       MinimumLength = 123,
#'       RequireUppercase = TRUE|FALSE,
#'       RequireLowercase = TRUE|FALSE,
#'       RequireNumbers = TRUE|FALSE,
#'       RequireSymbols = TRUE|FALSE
#'     )
#'   ),
#'   LambdaConfig = list(
#'     PreSignUp = "string",
#'     CustomMessage = "string",
#'     PostConfirmation = "string",
#'     PreAuthentication = "string",
#'     PostAuthentication = "string",
#'     DefineAuthChallenge = "string",
#'     CreateAuthChallenge = "string",
#'     VerifyAuthChallengeResponse = "string",
#'     PreTokenGeneration = "string",
#'     UserMigration = "string"
#'   ),
#'   AutoVerifiedAttributes = list(
#'     "phone_number"|"email"
#'   ),
#'   AliasAttributes = list(
#'     "phone_number"|"email"|"preferred_username"
#'   ),
#'   UsernameAttributes = list(
#'     "phone_number"|"email"
#'   ),
#'   SmsVerificationMessage = "string",
#'   EmailVerificationMessage = "string",
#'   EmailVerificationSubject = "string",
#'   VerificationMessageTemplate = list(
#'     SmsMessage = "string",
#'     EmailMessage = "string",
#'     EmailSubject = "string",
#'     EmailMessageByLink = "string",
#'     EmailSubjectByLink = "string",
#'     DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
#'   ),
#'   SmsAuthenticationMessage = "string",
#'   MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
#'   DeviceConfiguration = list(
#'     ChallengeRequiredOnNewDevice = TRUE|FALSE,
#'     DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
#'   ),
#'   EmailConfiguration = list(
#'     SourceArn = "string",
#'     ReplyToEmailAddress = "string"
#'   ),
#'   SmsConfiguration = list(
#'     SnsCallerArn = "string",
#'     ExternalId = "string"
#'   ),
#'   UserPoolTags = list(
#'     "string"
#'   ),
#'   AdminCreateUserConfig = list(
#'     AllowAdminCreateUserOnly = TRUE|FALSE,
#'     UnusedAccountValidityDays = 123,
#'     InviteMessageTemplate = list(
#'       SMSMessage = "string",
#'       EmailMessage = "string",
#'       EmailSubject = "string"
#'     )
#'   ),
#'   Schema = list(
#'     list(
#'       Name = "string",
#'       AttributeDataType = "String"|"Number"|"DateTime"|"Boolean",
#'       DeveloperOnlyAttribute = TRUE|FALSE,
#'       Mutable = TRUE|FALSE,
#'       Required = TRUE|FALSE,
#'       NumberAttributeConstraints = list(
#'         MinValue = "string",
#'         MaxValue = "string"
#'       ),
#'       StringAttributeConstraints = list(
#'         MinLength = "string",
#'         MaxLength = "string"
#'       )
#'     )
#'   ),
#'   UserPoolAddOns = list(
#'     AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool
cognitoidentityprovider_create_user_pool <- function(PoolName, Policies = NULL, LambdaConfig = NULL, AutoVerifiedAttributes = NULL, AliasAttributes = NULL, UsernameAttributes = NULL, SmsVerificationMessage = NULL, EmailVerificationMessage = NULL, EmailVerificationSubject = NULL, VerificationMessageTemplate = NULL, SmsAuthenticationMessage = NULL, MfaConfiguration = NULL, DeviceConfiguration = NULL, EmailConfiguration = NULL, SmsConfiguration = NULL, UserPoolTags = NULL, AdminCreateUserConfig = NULL, Schema = NULL, UserPoolAddOns = NULL) {
  op <- new_operation(
    name = "CreateUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_input(PoolName = PoolName, Policies = Policies, LambdaConfig = LambdaConfig, AutoVerifiedAttributes = AutoVerifiedAttributes, AliasAttributes = AliasAttributes, UsernameAttributes = UsernameAttributes, SmsVerificationMessage = SmsVerificationMessage, EmailVerificationMessage = EmailVerificationMessage, EmailVerificationSubject = EmailVerificationSubject, VerificationMessageTemplate = VerificationMessageTemplate, SmsAuthenticationMessage = SmsAuthenticationMessage, MfaConfiguration = MfaConfiguration, DeviceConfiguration = DeviceConfiguration, EmailConfiguration = EmailConfiguration, SmsConfiguration = SmsConfiguration, UserPoolTags = UserPoolTags, AdminCreateUserConfig = AdminCreateUserConfig, Schema = Schema, UserPoolAddOns = UserPoolAddOns)
  output <- .cognitoidentityprovider$create_user_pool_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool <- cognitoidentityprovider_create_user_pool

#' Creates the user pool client
#'
#' Creates the user pool client.
#'
#' @usage
#' cognitoidentityprovider_create_user_pool_client(UserPoolId, ClientName,
#'   GenerateSecret, RefreshTokenValidity, ReadAttributes, WriteAttributes,
#'   ExplicitAuthFlows, SupportedIdentityProviders, CallbackURLs, LogoutURLs,
#'   DefaultRedirectURI, AllowedOAuthFlows, AllowedOAuthScopes,
#'   AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to create a user pool
#' client.
#' @param ClientName &#91;required&#93; The client name for the user pool client you would like to create.
#' @param GenerateSecret Boolean to specify whether you want to generate a secret for the user
#' pool client being created.
#' @param RefreshTokenValidity The time limit, in days, after which the refresh token is no longer
#' valid and cannot be used.
#' @param ReadAttributes The read attributes.
#' @param WriteAttributes The user pool attributes that the app client can write to.
#' 
#' If your app client allows users to sign in through an identity provider,
#' this array must include all attributes that are mapped to identity
#' provider attributes. Amazon Cognito updates mapped attributes when users
#' sign in to your application through an identity provider. If your app
#' client lacks write access to a mapped attribute, Amazon Cognito throws
#' an error when it attempts to update the attribute. For more information,
#' see [Specifying Identity Provider Attribute Mappings for Your User
#' Pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
#' @param ExplicitAuthFlows The explicit authentication flows.
#' @param SupportedIdentityProviders A list of provider names for the identity providers that are supported
#' on this client.
#' @param CallbackURLs A list of allowed redirect (callback) URLs for the identity providers.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param LogoutURLs A list of allowed logout URLs for the identity providers.
#' @param DefaultRedirectURI The default redirect URI. Must be in the `CallbackURLs` list.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param AllowedOAuthFlows Set to `code` to initiate a code grant flow, which provides an
#' authorization code as the response. This code can be exchanged for
#' access tokens with the token endpoint.
#' 
#' Set to `token` to specify that the client should get the access token
#' (and, optionally, ID token, based on scopes) directly.
#' @param AllowedOAuthScopes A list of allowed `OAuth` scopes. Currently supported values are
#' `"phone"`, `"email"`, `"openid"`, and `"Cognito"`.
#' @param AllowedOAuthFlowsUserPoolClient Set to `True` if the client is allowed to follow the OAuth protocol when
#' interacting with Cognito user pools.
#' @param AnalyticsConfiguration The Amazon Pinpoint analytics configuration for collecting metrics for
#' this user pool.
#'
#' @section Request syntax:
#' ```
#' svc$create_user_pool_client(
#'   UserPoolId = "string",
#'   ClientName = "string",
#'   GenerateSecret = TRUE|FALSE,
#'   RefreshTokenValidity = 123,
#'   ReadAttributes = list(
#'     "string"
#'   ),
#'   WriteAttributes = list(
#'     "string"
#'   ),
#'   ExplicitAuthFlows = list(
#'     "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"
#'   ),
#'   SupportedIdentityProviders = list(
#'     "string"
#'   ),
#'   CallbackURLs = list(
#'     "string"
#'   ),
#'   LogoutURLs = list(
#'     "string"
#'   ),
#'   DefaultRedirectURI = "string",
#'   AllowedOAuthFlows = list(
#'     "code"|"implicit"|"client_credentials"
#'   ),
#'   AllowedOAuthScopes = list(
#'     "string"
#'   ),
#'   AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
#'   AnalyticsConfiguration = list(
#'     ApplicationId = "string",
#'     RoleArn = "string",
#'     ExternalId = "string",
#'     UserDataShared = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool_client
cognitoidentityprovider_create_user_pool_client <- function(UserPoolId, ClientName, GenerateSecret = NULL, RefreshTokenValidity = NULL, ReadAttributes = NULL, WriteAttributes = NULL, ExplicitAuthFlows = NULL, SupportedIdentityProviders = NULL, CallbackURLs = NULL, LogoutURLs = NULL, DefaultRedirectURI = NULL, AllowedOAuthFlows = NULL, AllowedOAuthScopes = NULL, AllowedOAuthFlowsUserPoolClient = NULL, AnalyticsConfiguration = NULL) {
  op <- new_operation(
    name = "CreateUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_client_input(UserPoolId = UserPoolId, ClientName = ClientName, GenerateSecret = GenerateSecret, RefreshTokenValidity = RefreshTokenValidity, ReadAttributes = ReadAttributes, WriteAttributes = WriteAttributes, ExplicitAuthFlows = ExplicitAuthFlows, SupportedIdentityProviders = SupportedIdentityProviders, CallbackURLs = CallbackURLs, LogoutURLs = LogoutURLs, DefaultRedirectURI = DefaultRedirectURI, AllowedOAuthFlows = AllowedOAuthFlows, AllowedOAuthScopes = AllowedOAuthScopes, AllowedOAuthFlowsUserPoolClient = AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration = AnalyticsConfiguration)
  output <- .cognitoidentityprovider$create_user_pool_client_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool_client <- cognitoidentityprovider_create_user_pool_client

#' Creates a new domain for a user pool
#'
#' Creates a new domain for a user pool.
#'
#' @usage
#' cognitoidentityprovider_create_user_pool_domain(Domain, UserPoolId,
#'   CustomDomainConfig)
#'
#' @param Domain &#91;required&#93; The domain string.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param CustomDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in
#' webpages for your application.
#' 
#' Provide this parameter only if you want to use a custom domain for your
#' user pool. Otherwise, you can exclude this parameter and use the Amazon
#' Cognito hosted domain instead.
#' 
#' For more information about the hosted domain and custom domains, see
#' [Configuring a User Pool
#' Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_user_pool_domain(
#'   Domain = "string",
#'   UserPoolId = "string",
#'   CustomDomainConfig = list(
#'     CertificateArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool_domain
cognitoidentityprovider_create_user_pool_domain <- function(Domain, UserPoolId, CustomDomainConfig = NULL) {
  op <- new_operation(
    name = "CreateUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId, CustomDomainConfig = CustomDomainConfig)
  output <- .cognitoidentityprovider$create_user_pool_domain_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool_domain <- cognitoidentityprovider_create_user_pool_domain

#' Deletes a group
#'
#' Deletes a group. Currently only groups with no members can be deleted.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_delete_group(GroupName, UserPoolId)
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$delete_group(
#'   GroupName = "string",
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_group
cognitoidentityprovider_delete_group <- function(GroupName, UserPoolId) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_group_input(GroupName = GroupName, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_group <- cognitoidentityprovider_delete_group

#' Deletes an identity provider for a user pool
#'
#' Deletes an identity provider for a user pool.
#'
#' @usage
#' cognitoidentityprovider_delete_identity_provider(UserPoolId,
#'   ProviderName)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The identity provider name.
#'
#' @section Request syntax:
#' ```
#' svc$delete_identity_provider(
#'   UserPoolId = "string",
#'   ProviderName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_identity_provider
cognitoidentityprovider_delete_identity_provider <- function(UserPoolId, ProviderName) {
  op <- new_operation(
    name = "DeleteIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName)
  output <- .cognitoidentityprovider$delete_identity_provider_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_identity_provider <- cognitoidentityprovider_delete_identity_provider

#' Deletes a resource server
#'
#' Deletes a resource server.
#'
#' @usage
#' cognitoidentityprovider_delete_resource_server(UserPoolId, Identifier)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that hosts the resource server.
#' @param Identifier &#91;required&#93; The identifier for the resource server.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_server(
#'   UserPoolId = "string",
#'   Identifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_resource_server
cognitoidentityprovider_delete_resource_server <- function(UserPoolId, Identifier) {
  op <- new_operation(
    name = "DeleteResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier)
  output <- .cognitoidentityprovider$delete_resource_server_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_resource_server <- cognitoidentityprovider_delete_resource_server

#' Allows a user to delete himself or herself
#'
#' Allows a user to delete himself or herself.
#'
#' @usage
#' cognitoidentityprovider_delete_user(AccessToken)
#'
#' @param AccessToken &#91;required&#93; The access token from a request to delete a user.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user
cognitoidentityprovider_delete_user <- function(AccessToken) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$delete_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user <- cognitoidentityprovider_delete_user

#' Deletes the attributes for a user
#'
#' Deletes the attributes for a user.
#'
#' @usage
#' cognitoidentityprovider_delete_user_attributes(UserAttributeNames,
#'   AccessToken)
#'
#' @param UserAttributeNames &#91;required&#93; An array of strings representing the user attribute names you wish to
#' delete.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' @param AccessToken &#91;required&#93; The access token used in the request to delete user attributes.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_attributes(
#'   UserAttributeNames = list(
#'     "string"
#'   ),
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_attributes
cognitoidentityprovider_delete_user_attributes <- function(UserAttributeNames, AccessToken) {
  op <- new_operation(
    name = "DeleteUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_attributes_input(UserAttributeNames = UserAttributeNames, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$delete_user_attributes_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_attributes <- cognitoidentityprovider_delete_user_attributes

#' Deletes the specified Amazon Cognito user pool
#'
#' Deletes the specified Amazon Cognito user pool.
#'
#' @usage
#' cognitoidentityprovider_delete_user_pool(UserPoolId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_pool(
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool
cognitoidentityprovider_delete_user_pool <- function(UserPoolId) {
  op <- new_operation(
    name = "DeleteUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_user_pool_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool <- cognitoidentityprovider_delete_user_pool

#' Allows the developer to delete the user pool client
#'
#' Allows the developer to delete the user pool client.
#'
#' @usage
#' cognitoidentityprovider_delete_user_pool_client(UserPoolId, ClientId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete the client.
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_pool_client(
#'   UserPoolId = "string",
#'   ClientId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool_client
cognitoidentityprovider_delete_user_pool_client <- function(UserPoolId, ClientId) {
  op <- new_operation(
    name = "DeleteUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$delete_user_pool_client_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool_client <- cognitoidentityprovider_delete_user_pool_client

#' Deletes a domain for a user pool
#'
#' Deletes a domain for a user pool.
#'
#' @usage
#' cognitoidentityprovider_delete_user_pool_domain(Domain, UserPoolId)
#'
#' @param Domain &#91;required&#93; The domain string.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_pool_domain(
#'   Domain = "string",
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool_domain
cognitoidentityprovider_delete_user_pool_domain <- function(Domain, UserPoolId) {
  op <- new_operation(
    name = "DeleteUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_user_pool_domain_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool_domain <- cognitoidentityprovider_delete_user_pool_domain

#' Gets information about a specific identity provider
#'
#' Gets information about a specific identity provider.
#'
#' @usage
#' cognitoidentityprovider_describe_identity_provider(UserPoolId,
#'   ProviderName)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The identity provider name.
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_provider(
#'   UserPoolId = "string",
#'   ProviderName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_identity_provider
cognitoidentityprovider_describe_identity_provider <- function(UserPoolId, ProviderName) {
  op <- new_operation(
    name = "DescribeIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName)
  output <- .cognitoidentityprovider$describe_identity_provider_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_identity_provider <- cognitoidentityprovider_describe_identity_provider

#' Describes a resource server
#'
#' Describes a resource server.
#'
#' @usage
#' cognitoidentityprovider_describe_resource_server(UserPoolId, Identifier)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that hosts the resource server.
#' @param Identifier &#91;required&#93; The identifier for the resource server
#'
#' @section Request syntax:
#' ```
#' svc$describe_resource_server(
#'   UserPoolId = "string",
#'   Identifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_resource_server
cognitoidentityprovider_describe_resource_server <- function(UserPoolId, Identifier) {
  op <- new_operation(
    name = "DescribeResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier)
  output <- .cognitoidentityprovider$describe_resource_server_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_resource_server <- cognitoidentityprovider_describe_resource_server

#' Describes the risk configuration
#'
#' Describes the risk configuration.
#'
#' @usage
#' cognitoidentityprovider_describe_risk_configuration(UserPoolId,
#'   ClientId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ClientId The app client ID.
#'
#' @section Request syntax:
#' ```
#' svc$describe_risk_configuration(
#'   UserPoolId = "string",
#'   ClientId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_risk_configuration
cognitoidentityprovider_describe_risk_configuration <- function(UserPoolId, ClientId = NULL) {
  op <- new_operation(
    name = "DescribeRiskConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_risk_configuration_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$describe_risk_configuration_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_risk_configuration <- cognitoidentityprovider_describe_risk_configuration

#' Describes the user import job
#'
#' Describes the user import job.
#'
#' @usage
#' cognitoidentityprovider_describe_user_import_job(UserPoolId, JobId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_import_job(
#'   UserPoolId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_import_job
cognitoidentityprovider_describe_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "DescribeUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$describe_user_import_job_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_import_job <- cognitoidentityprovider_describe_user_import_job

#' Returns the configuration information and metadata of the specified user
#' pool
#'
#' Returns the configuration information and metadata of the specified user
#' pool.
#'
#' @usage
#' cognitoidentityprovider_describe_user_pool(UserPoolId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_pool(
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool
cognitoidentityprovider_describe_user_pool <- function(UserPoolId) {
  op <- new_operation(
    name = "DescribeUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$describe_user_pool_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool <- cognitoidentityprovider_describe_user_pool

#' Client method for returning the configuration information and metadata
#' of the specified user pool app client
#'
#' Client method for returning the configuration information and metadata
#' of the specified user pool app client.
#'
#' @usage
#' cognitoidentityprovider_describe_user_pool_client(UserPoolId, ClientId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to describe.
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_pool_client(
#'   UserPoolId = "string",
#'   ClientId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool_client
cognitoidentityprovider_describe_user_pool_client <- function(UserPoolId, ClientId) {
  op <- new_operation(
    name = "DescribeUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$describe_user_pool_client_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool_client <- cognitoidentityprovider_describe_user_pool_client

#' Gets information about a domain
#'
#' Gets information about a domain.
#'
#' @usage
#' cognitoidentityprovider_describe_user_pool_domain(Domain)
#'
#' @param Domain &#91;required&#93; The domain string.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_pool_domain(
#'   Domain = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool_domain
cognitoidentityprovider_describe_user_pool_domain <- function(Domain) {
  op <- new_operation(
    name = "DescribeUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_domain_input(Domain = Domain)
  output <- .cognitoidentityprovider$describe_user_pool_domain_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool_domain <- cognitoidentityprovider_describe_user_pool_domain

#' Forgets the specified device
#'
#' Forgets the specified device.
#'
#' @usage
#' cognitoidentityprovider_forget_device(AccessToken, DeviceKey)
#'
#' @param AccessToken The access token for the forgotten device request.
#' @param DeviceKey &#91;required&#93; The device key.
#'
#' @section Request syntax:
#' ```
#' svc$forget_device(
#'   AccessToken = "string",
#'   DeviceKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_forget_device
cognitoidentityprovider_forget_device <- function(AccessToken = NULL, DeviceKey) {
  op <- new_operation(
    name = "ForgetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$forget_device_input(AccessToken = AccessToken, DeviceKey = DeviceKey)
  output <- .cognitoidentityprovider$forget_device_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$forget_device <- cognitoidentityprovider_forget_device

#' Calling this API causes a message to be sent to the end user with a
#' confirmation code that is required to change the user's password
#'
#' Calling this API causes a message to be sent to the end user with a
#' confirmation code that is required to change the user\'s password. For
#' the `Username` parameter, you can use the username or user alias. If a
#' verified phone number exists for the user, the confirmation code is sent
#' to the phone number. Otherwise, if a verified email exists, the
#' confirmation code is sent to the email. If neither a verified phone
#' number nor a verified email exists, `InvalidParameterException` is
#' thrown. To use the confirmation code for resetting the password, call .
#'
#' @usage
#' cognitoidentityprovider_forgot_password(ClientId, SecretHash,
#'   UserContextData, Username, AnalyticsMetadata)
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#' @param Username &#91;required&#93; The user name of the user for whom you want to enter a code to reset a
#' forgotten password.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `ForgotPassword` calls.
#'
#' @section Request syntax:
#' ```
#' svc$forgot_password(
#'   ClientId = "string",
#'   SecretHash = "string",
#'   UserContextData = list(
#'     EncodedData = "string"
#'   ),
#'   Username = "string",
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_forgot_password
cognitoidentityprovider_forgot_password <- function(ClientId, SecretHash = NULL, UserContextData = NULL, Username, AnalyticsMetadata = NULL) {
  op <- new_operation(
    name = "ForgotPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$forgot_password_input(ClientId = ClientId, SecretHash = SecretHash, UserContextData = UserContextData, Username = Username, AnalyticsMetadata = AnalyticsMetadata)
  output <- .cognitoidentityprovider$forgot_password_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$forgot_password <- cognitoidentityprovider_forgot_password

#' Gets the header information for the
#'
#' Gets the header information for the .csv file to be used as input for
#' the user import job.
#'
#' @usage
#' cognitoidentityprovider_get_csv_header(UserPoolId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are to be imported
#' into.
#'
#' @section Request syntax:
#' ```
#' svc$get_csv_header(
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_csv_header
cognitoidentityprovider_get_csv_header <- function(UserPoolId) {
  op <- new_operation(
    name = "GetCSVHeader",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_csv_header_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_csv_header_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_csv_header <- cognitoidentityprovider_get_csv_header

#' Gets the device
#'
#' Gets the device.
#'
#' @usage
#' cognitoidentityprovider_get_device(DeviceKey, AccessToken)
#'
#' @param DeviceKey &#91;required&#93; The device key.
#' @param AccessToken The access token.
#'
#' @section Request syntax:
#' ```
#' svc$get_device(
#'   DeviceKey = "string",
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_device
cognitoidentityprovider_get_device <- function(DeviceKey, AccessToken = NULL) {
  op <- new_operation(
    name = "GetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_device_input(DeviceKey = DeviceKey, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$get_device_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_device <- cognitoidentityprovider_get_device

#' Gets a group
#'
#' Gets a group.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_get_group(GroupName, UserPoolId)
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$get_group(
#'   GroupName = "string",
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_group
cognitoidentityprovider_get_group <- function(GroupName, UserPoolId) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_group_input(GroupName = GroupName, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_group <- cognitoidentityprovider_get_group

#' Gets the specified identity provider
#'
#' Gets the specified identity provider.
#'
#' @usage
#' cognitoidentityprovider_get_identity_provider_by_identifier(UserPoolId,
#'   IdpIdentifier)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param IdpIdentifier &#91;required&#93; The identity provider ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_provider_by_identifier(
#'   UserPoolId = "string",
#'   IdpIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_identity_provider_by_identifier
cognitoidentityprovider_get_identity_provider_by_identifier <- function(UserPoolId, IdpIdentifier) {
  op <- new_operation(
    name = "GetIdentityProviderByIdentifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_identity_provider_by_identifier_input(UserPoolId = UserPoolId, IdpIdentifier = IdpIdentifier)
  output <- .cognitoidentityprovider$get_identity_provider_by_identifier_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_identity_provider_by_identifier <- cognitoidentityprovider_get_identity_provider_by_identifier

#' This method takes a user pool ID, and returns the signing certificate
#'
#' This method takes a user pool ID, and returns the signing certificate.
#'
#' @usage
#' cognitoidentityprovider_get_signing_certificate(UserPoolId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_signing_certificate(
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_signing_certificate
cognitoidentityprovider_get_signing_certificate <- function(UserPoolId) {
  op <- new_operation(
    name = "GetSigningCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_signing_certificate_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_signing_certificate_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_signing_certificate <- cognitoidentityprovider_get_signing_certificate

#' Gets the UI Customization information for a particular app client's app
#' UI, if there is something set
#'
#' Gets the UI Customization information for a particular app client\'s app
#' UI, if there is something set. If nothing is set for the particular
#' client, but there is an existing pool level customization (app
#' `clientId` will be `ALL`), then that is returned. If nothing is present,
#' then an empty shape is returned.
#'
#' @usage
#' cognitoidentityprovider_get_ui_customization(UserPoolId, ClientId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param ClientId The client ID for the client app.
#'
#' @section Request syntax:
#' ```
#' svc$get_ui_customization(
#'   UserPoolId = "string",
#'   ClientId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_ui_customization
cognitoidentityprovider_get_ui_customization <- function(UserPoolId, ClientId = NULL) {
  op <- new_operation(
    name = "GetUICustomization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_ui_customization_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$get_ui_customization_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_ui_customization <- cognitoidentityprovider_get_ui_customization

#' Gets the user attributes and metadata for a user
#'
#' Gets the user attributes and metadata for a user.
#'
#' @usage
#' cognitoidentityprovider_get_user(AccessToken)
#'
#' @param AccessToken &#91;required&#93; The access token returned by the server response to get information
#' about the user.
#'
#' @section Request syntax:
#' ```
#' svc$get_user(
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user
cognitoidentityprovider_get_user <- function(AccessToken) {
  op <- new_operation(
    name = "GetUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$get_user_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user <- cognitoidentityprovider_get_user

#' Gets the user attribute verification code for the specified attribute
#' name
#'
#' Gets the user attribute verification code for the specified attribute
#' name.
#'
#' @usage
#' cognitoidentityprovider_get_user_attribute_verification_code(
#'   AccessToken, AttributeName)
#'
#' @param AccessToken &#91;required&#93; The access token returned by the server response to get the user
#' attribute verification code.
#' @param AttributeName &#91;required&#93; The attribute name returned by the server response to get the user
#' attribute verification code.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_attribute_verification_code(
#'   AccessToken = "string",
#'   AttributeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user_attribute_verification_code
cognitoidentityprovider_get_user_attribute_verification_code <- function(AccessToken, AttributeName) {
  op <- new_operation(
    name = "GetUserAttributeVerificationCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_attribute_verification_code_input(AccessToken = AccessToken, AttributeName = AttributeName)
  output <- .cognitoidentityprovider$get_user_attribute_verification_code_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user_attribute_verification_code <- cognitoidentityprovider_get_user_attribute_verification_code

#' Gets the user pool multi-factor authentication (MFA) configuration
#'
#' Gets the user pool multi-factor authentication (MFA) configuration.
#'
#' @usage
#' cognitoidentityprovider_get_user_pool_mfa_config(UserPoolId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_pool_mfa_config(
#'   UserPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user_pool_mfa_config
cognitoidentityprovider_get_user_pool_mfa_config <- function(UserPoolId) {
  op <- new_operation(
    name = "GetUserPoolMfaConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_pool_mfa_config_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_user_pool_mfa_config_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user_pool_mfa_config <- cognitoidentityprovider_get_user_pool_mfa_config

#' Signs out users from all devices
#'
#' Signs out users from all devices.
#'
#' @usage
#' cognitoidentityprovider_global_sign_out(AccessToken)
#'
#' @param AccessToken &#91;required&#93; The access token.
#'
#' @section Request syntax:
#' ```
#' svc$global_sign_out(
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_global_sign_out
cognitoidentityprovider_global_sign_out <- function(AccessToken) {
  op <- new_operation(
    name = "GlobalSignOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$global_sign_out_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$global_sign_out_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$global_sign_out <- cognitoidentityprovider_global_sign_out

#' Initiates the authentication flow
#'
#' Initiates the authentication flow.
#'
#' @usage
#' cognitoidentityprovider_initiate_auth(AuthFlow, AuthParameters,
#'   ClientMetadata, ClientId, AnalyticsMetadata, UserContextData)
#'
#' @param AuthFlow &#91;required&#93; The authentication flow for this call to execute. The API action will
#' depend on this value. For example:
#' 
#' -   `REFRESH_TOKEN_AUTH` will take in a valid refresh token and return
#'     new tokens.
#' 
#' -   `USER_SRP_AUTH` will take in `USERNAME` and `SRP_A` and return the
#'     SRP variables to be used for next challenge execution.
#' 
#' -   `USER_PASSWORD_AUTH` will take in `USERNAME` and `PASSWORD` and
#'     return the next challenge or tokens.
#' 
#' Valid values include:
#' 
#' -   `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password
#'     (SRP) protocol.
#' 
#' -   `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for
#'     refreshing the access token and ID token by supplying a valid
#'     refresh token.
#' 
#' -   `CUSTOM_AUTH`: Custom authentication flow.
#' 
#' -   `USER_PASSWORD_AUTH`: Non-SRP authentication flow; USERNAME and
#'     PASSWORD are passed directly. If a user migration Lambda trigger is
#'     set, this flow will invoke the user migration Lambda if the USERNAME
#'     is not found in the user pool.
#' 
#' `ADMIN_NO_SRP_AUTH` is not a valid value.
#' @param AuthParameters The authentication parameters. These are inputs corresponding to the
#' `AuthFlow` that you are invoking. The required values depend on the
#' value of `AuthFlow`:
#' 
#' -   For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`
#' 
#' -   For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`
#' 
#' -   For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app
#'     client is configured with client secret), `DEVICE_KEY`
#' @param ClientMetadata This is a random key-value pair map which can contain any key and will
#' be passed to your PreAuthentication Lambda trigger as-is. It can be used
#' to implement additional validations around authentication.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `InitiateAuth` calls.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$initiate_auth(
#'   AuthFlow = "USER_SRP_AUTH"|"REFRESH_TOKEN_AUTH"|"REFRESH_TOKEN"|"CUSTOM_AUTH"|"ADMIN_NO_SRP_AUTH"|"USER_PASSWORD_AUTH",
#'   AuthParameters = list(
#'     "string"
#'   ),
#'   ClientMetadata = list(
#'     "string"
#'   ),
#'   ClientId = "string",
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   UserContextData = list(
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_initiate_auth
cognitoidentityprovider_initiate_auth <- function(AuthFlow, AuthParameters = NULL, ClientMetadata = NULL, ClientId, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "InitiateAuth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$initiate_auth_input(AuthFlow = AuthFlow, AuthParameters = AuthParameters, ClientMetadata = ClientMetadata, ClientId = ClientId, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$initiate_auth_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$initiate_auth <- cognitoidentityprovider_initiate_auth

#' Lists the devices
#'
#' Lists the devices.
#'
#' @usage
#' cognitoidentityprovider_list_devices(AccessToken, Limit,
#'   PaginationToken)
#'
#' @param AccessToken &#91;required&#93; The access tokens for the request to list devices.
#' @param Limit The limit of the device request.
#' @param PaginationToken The pagination token for the list request.
#'
#' @section Request syntax:
#' ```
#' svc$list_devices(
#'   AccessToken = "string",
#'   Limit = 123,
#'   PaginationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_devices
cognitoidentityprovider_list_devices <- function(AccessToken, Limit = NULL, PaginationToken = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_devices_input(AccessToken = AccessToken, Limit = Limit, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$list_devices_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_devices <- cognitoidentityprovider_list_devices

#' Lists the groups associated with a user pool
#'
#' Lists the groups associated with a user pool.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_list_groups(UserPoolId, Limit, NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Limit The limit of the request to list groups.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @section Request syntax:
#' ```
#' svc$list_groups(
#'   UserPoolId = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_groups
cognitoidentityprovider_list_groups <- function(UserPoolId, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_groups_input(UserPoolId = UserPoolId, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_groups_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_groups <- cognitoidentityprovider_list_groups

#' Lists information about all identity providers for a user pool
#'
#' Lists information about all identity providers for a user pool.
#'
#' @usage
#' cognitoidentityprovider_list_identity_providers(UserPoolId, MaxResults,
#'   NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param MaxResults The maximum number of identity providers to return.
#' @param NextToken A pagination token.
#'
#' @section Request syntax:
#' ```
#' svc$list_identity_providers(
#'   UserPoolId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_identity_providers
cognitoidentityprovider_list_identity_providers <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_identity_providers_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_identity_providers_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_identity_providers <- cognitoidentityprovider_list_identity_providers

#' Lists the resource servers for a user pool
#'
#' Lists the resource servers for a user pool.
#'
#' @usage
#' cognitoidentityprovider_list_resource_servers(UserPoolId, MaxResults,
#'   NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param MaxResults The maximum number of resource servers to return.
#' @param NextToken A pagination token.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_servers(
#'   UserPoolId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_resource_servers
cognitoidentityprovider_list_resource_servers <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResourceServers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_resource_servers_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_resource_servers_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_resource_servers <- cognitoidentityprovider_list_resource_servers

#' Lists the tags that are assigned to an Amazon Cognito user pool
#'
#' Lists the tags that are assigned to an Amazon Cognito user pool.
#' 
#' A tag is a label that you can apply to user pools to categorize and
#' manage them in different ways, such as by purpose, owner, environment,
#' or other criteria.
#' 
#' You can use this action up to 10 times per second, per account.
#'
#' @usage
#' cognitoidentityprovider_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool that the tags are
#' assigned to.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_tags_for_resource
cognitoidentityprovider_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cognitoidentityprovider$list_tags_for_resource_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_tags_for_resource <- cognitoidentityprovider_list_tags_for_resource

#' Lists the user import jobs
#'
#' Lists the user import jobs.
#'
#' @usage
#' cognitoidentityprovider_list_user_import_jobs(UserPoolId, MaxResults,
#'   PaginationToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param MaxResults &#91;required&#93; The maximum number of import jobs you want the request to return.
#' @param PaginationToken An identifier that was returned from the previous call to
#' `ListUserImportJobs`, which can be used to return the next set of import
#' jobs in the list.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_import_jobs(
#'   UserPoolId = "string",
#'   MaxResults = 123,
#'   PaginationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_import_jobs
cognitoidentityprovider_list_user_import_jobs <- function(UserPoolId, MaxResults, PaginationToken = NULL) {
  op <- new_operation(
    name = "ListUserImportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_import_jobs_input(UserPoolId = UserPoolId, MaxResults = MaxResults, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$list_user_import_jobs_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_import_jobs <- cognitoidentityprovider_list_user_import_jobs

#' Lists the clients that have been created for the specified user pool
#'
#' Lists the clients that have been created for the specified user pool.
#'
#' @usage
#' cognitoidentityprovider_list_user_pool_clients(UserPoolId, MaxResults,
#'   NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to list user pool
#' clients.
#' @param MaxResults The maximum number of results you want the request to return when
#' listing the user pool clients.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_pool_clients(
#'   UserPoolId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_pool_clients
cognitoidentityprovider_list_user_pool_clients <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUserPoolClients",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_pool_clients_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_user_pool_clients_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_pool_clients <- cognitoidentityprovider_list_user_pool_clients

#' Lists the user pools associated with an AWS account
#'
#' Lists the user pools associated with an AWS account.
#'
#' @usage
#' cognitoidentityprovider_list_user_pools(NextToken, MaxResults)
#'
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#' @param MaxResults &#91;required&#93; The maximum number of results you want the request to return when
#' listing the user pools.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_pools(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_pools
cognitoidentityprovider_list_user_pools <- function(NextToken = NULL, MaxResults) {
  op <- new_operation(
    name = "ListUserPools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_pools_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cognitoidentityprovider$list_user_pools_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_pools <- cognitoidentityprovider_list_user_pools

#' Lists the users in the Amazon Cognito user pool
#'
#' Lists the users in the Amazon Cognito user pool.
#'
#' @usage
#' cognitoidentityprovider_list_users(UserPoolId, AttributesToGet, Limit,
#'   PaginationToken, Filter)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool on which the search should be
#' performed.
#' @param AttributesToGet An array of strings, where each string is the name of a user attribute
#' to be returned for each user in the search results. If the array is
#' null, all attributes are returned.
#' @param Limit Maximum number of users to be returned.
#' @param PaginationToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#' @param Filter A filter string of the form \"*AttributeName* *Filter-Type*
#' \"*AttributeValue*\"\". Quotation marks within the filter string must be
#' escaped using the backslash (\\) character. For example, \"`family_name`
#' = \\\"Reddy\\\"\".
#' 
#' -   *AttributeName*: The name of the attribute to search for. You can
#'     only search for one attribute at a time.
#' 
#' -   *Filter-Type*: For an exact match, use =, for example,
#'     \"`given_name` = \\\"Jon\\\"\". For a prefix (\"starts with\")
#'     match, use \\^=, for example, \"`given_name` \\^= \\\"Jon\\\"\".
#' 
#' -   *AttributeValue*: The attribute value that must be matched for each
#'     user.
#' 
#' If the filter string is empty, `ListUsers` returns all users in the user
#' pool.
#' 
#' You can only search for the following standard attributes:
#' 
#' -   `username` (case-sensitive)
#' 
#' -   `email`
#' 
#' -   `phone_number`
#' 
#' -   `name`
#' 
#' -   `given_name`
#' 
#' -   `family_name`
#' 
#' -   `preferred_username`
#' 
#' -   `cognito:user_status` (called **Status** in the Console)
#'     (case-insensitive)
#' 
#' -   `status (called <b>Enabled</b> in the Console) (case-sensitive)`
#' 
#' -   `sub`
#' 
#' Custom attributes are not searchable.
#' 
#' For more information, see [Searching for Users Using the ListUsers
#' API](http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api)
#' and [Examples of Using the ListUsers
#' API](http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples)
#' in the *Amazon Cognito Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$list_users(
#'   UserPoolId = "string",
#'   AttributesToGet = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   PaginationToken = "string",
#'   Filter = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_users
cognitoidentityprovider_list_users <- function(UserPoolId, AttributesToGet = NULL, Limit = NULL, PaginationToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_users_input(UserPoolId = UserPoolId, AttributesToGet = AttributesToGet, Limit = Limit, PaginationToken = PaginationToken, Filter = Filter)
  output <- .cognitoidentityprovider$list_users_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_users <- cognitoidentityprovider_list_users

#' Lists the users in the specified group
#'
#' Lists the users in the specified group.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_list_users_in_group(UserPoolId, GroupName,
#'   Limit, NextToken)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param GroupName &#91;required&#93; The name of the group.
#' @param Limit The limit of the request to list users.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @section Request syntax:
#' ```
#' svc$list_users_in_group(
#'   UserPoolId = "string",
#'   GroupName = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_users_in_group
cognitoidentityprovider_list_users_in_group <- function(UserPoolId, GroupName, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUsersInGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_users_in_group_input(UserPoolId = UserPoolId, GroupName = GroupName, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_users_in_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_users_in_group <- cognitoidentityprovider_list_users_in_group

#' Resends the confirmation (for confirmation of registration) to a
#' specific user in the user pool
#'
#' Resends the confirmation (for confirmation of registration) to a
#' specific user in the user pool.
#'
#' @usage
#' cognitoidentityprovider_resend_confirmation_code(ClientId, SecretHash,
#'   UserContextData, Username, AnalyticsMetadata)
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#' @param Username &#91;required&#93; The user name of the user to whom you wish to resend a confirmation
#' code.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `ResendConfirmationCode` calls.
#'
#' @section Request syntax:
#' ```
#' svc$resend_confirmation_code(
#'   ClientId = "string",
#'   SecretHash = "string",
#'   UserContextData = list(
#'     EncodedData = "string"
#'   ),
#'   Username = "string",
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_resend_confirmation_code
cognitoidentityprovider_resend_confirmation_code <- function(ClientId, SecretHash = NULL, UserContextData = NULL, Username, AnalyticsMetadata = NULL) {
  op <- new_operation(
    name = "ResendConfirmationCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$resend_confirmation_code_input(ClientId = ClientId, SecretHash = SecretHash, UserContextData = UserContextData, Username = Username, AnalyticsMetadata = AnalyticsMetadata)
  output <- .cognitoidentityprovider$resend_confirmation_code_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$resend_confirmation_code <- cognitoidentityprovider_resend_confirmation_code

#' Responds to the authentication challenge
#'
#' Responds to the authentication challenge.
#'
#' @usage
#' cognitoidentityprovider_respond_to_auth_challenge(ClientId,
#'   ChallengeName, Session, ChallengeResponses, AnalyticsMetadata,
#'   UserContextData)
#'
#' @param ClientId &#91;required&#93; The app client ID.
#' @param ChallengeName &#91;required&#93; The challenge name. For more information, see .
#' 
#' `ADMIN_NO_SRP_AUTH` is not a valid value.
#' @param Session The session which should be passed both ways in challenge-response calls
#' to the service. If `InitiateAuth` or `RespondToAuthChallenge` API call
#' determines that the caller needs to go through another challenge, they
#' return a session with other challenge parameters. This session should be
#' passed as it is to the next `RespondToAuthChallenge` API call.
#' @param ChallengeResponses The challenge responses. These are inputs corresponding to the value of
#' `ChallengeName`, for example:
#' 
#' -   `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`, `SECRET_HASH` (if app client
#'     is configured with client secret).
#' 
#' -   `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`,
#'     `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`,
#'     `SECRET_HASH` (if app client is configured with client secret).
#' 
#' -   `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, any other required
#'     attributes, `USERNAME`, `SECRET_HASH` (if app client is configured
#'     with client secret).
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `RespondToAuthChallenge` calls.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$respond_to_auth_challenge(
#'   ClientId = "string",
#'   ChallengeName = "SMS_MFA"|"SOFTWARE_TOKEN_MFA"|"SELECT_MFA_TYPE"|"MFA_SETUP"|"PASSWORD_VERIFIER"|"CUSTOM_CHALLENGE"|"DEVICE_SRP_AUTH"|"DEVICE_PASSWORD_VERIFIER"|"ADMIN_NO_SRP_AUTH"|"NEW_PASSWORD_REQUIRED",
#'   Session = "string",
#'   ChallengeResponses = list(
#'     "string"
#'   ),
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   UserContextData = list(
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_respond_to_auth_challenge
cognitoidentityprovider_respond_to_auth_challenge <- function(ClientId, ChallengeName, Session = NULL, ChallengeResponses = NULL, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "RespondToAuthChallenge",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$respond_to_auth_challenge_input(ClientId = ClientId, ChallengeName = ChallengeName, Session = Session, ChallengeResponses = ChallengeResponses, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$respond_to_auth_challenge_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$respond_to_auth_challenge <- cognitoidentityprovider_respond_to_auth_challenge

#' Configures actions on detected risks
#'
#' Configures actions on detected risks. To delete the risk configuration
#' for `UserPoolId` or `ClientId`, pass null values for all four
#' configuration types.
#' 
#' To enable Amazon Cognito advanced security features, update the user
#' pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
#' 
#' See .
#'
#' @usage
#' cognitoidentityprovider_set_risk_configuration(UserPoolId, ClientId,
#'   CompromisedCredentialsRiskConfiguration,
#'   AccountTakeoverRiskConfiguration, RiskExceptionConfiguration)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ClientId The app client ID. If `ClientId` is null, then the risk configuration is
#' mapped to `userPoolId`. When the client ID is null, the same risk
#' configuration is applied to all the clients in the userPool.
#' 
#' Otherwise, `ClientId` is mapped to the client. When the client ID is not
#' null, the user pool configuration is overridden and the risk
#' configuration for the client is used instead.
#' @param CompromisedCredentialsRiskConfiguration The compromised credentials risk configuration.
#' @param AccountTakeoverRiskConfiguration The account takeover risk configuration.
#' @param RiskExceptionConfiguration The configuration to override the risk decision.
#'
#' @section Request syntax:
#' ```
#' svc$set_risk_configuration(
#'   UserPoolId = "string",
#'   ClientId = "string",
#'   CompromisedCredentialsRiskConfiguration = list(
#'     EventFilter = list(
#'       "SIGN_IN"|"PASSWORD_CHANGE"|"SIGN_UP"
#'     ),
#'     Actions = list(
#'       EventAction = "BLOCK"|"NO_ACTION"
#'     )
#'   ),
#'   AccountTakeoverRiskConfiguration = list(
#'     NotifyConfiguration = list(
#'       From = "string",
#'       ReplyTo = "string",
#'       SourceArn = "string",
#'       BlockEmail = list(
#'         Subject = "string",
#'         HtmlBody = "string",
#'         TextBody = "string"
#'       ),
#'       NoActionEmail = list(
#'         Subject = "string",
#'         HtmlBody = "string",
#'         TextBody = "string"
#'       ),
#'       MfaEmail = list(
#'         Subject = "string",
#'         HtmlBody = "string",
#'         TextBody = "string"
#'       )
#'     ),
#'     Actions = list(
#'       LowAction = list(
#'         Notify = TRUE|FALSE,
#'         EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
#'       ),
#'       MediumAction = list(
#'         Notify = TRUE|FALSE,
#'         EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
#'       ),
#'       HighAction = list(
#'         Notify = TRUE|FALSE,
#'         EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
#'       )
#'     )
#'   ),
#'   RiskExceptionConfiguration = list(
#'     BlockedIPRangeList = list(
#'       "string"
#'     ),
#'     SkippedIPRangeList = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_risk_configuration
cognitoidentityprovider_set_risk_configuration <- function(UserPoolId, ClientId = NULL, CompromisedCredentialsRiskConfiguration = NULL, AccountTakeoverRiskConfiguration = NULL, RiskExceptionConfiguration = NULL) {
  op <- new_operation(
    name = "SetRiskConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_risk_configuration_input(UserPoolId = UserPoolId, ClientId = ClientId, CompromisedCredentialsRiskConfiguration = CompromisedCredentialsRiskConfiguration, AccountTakeoverRiskConfiguration = AccountTakeoverRiskConfiguration, RiskExceptionConfiguration = RiskExceptionConfiguration)
  output <- .cognitoidentityprovider$set_risk_configuration_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_risk_configuration <- cognitoidentityprovider_set_risk_configuration

#' Sets the UI customization information for a user pool's built-in app UI
#'
#' Sets the UI customization information for a user pool\'s built-in app
#' UI.
#' 
#' You can specify app UI customization settings for a single client (with
#' a specific `clientId`) or for all clients (by setting the `clientId` to
#' `ALL`). If you specify `ALL`, the default configuration will be used for
#' every client that has no UI customization set previously. If you specify
#' UI customization settings for a particular client, it will no longer
#' fall back to the `ALL` configuration.
#' 
#' To use this API, your user pool must have a domain associated with it.
#' Otherwise, there is no place to host the app\'s pages, and the service
#' will throw an error.
#'
#' @usage
#' cognitoidentityprovider_set_ui_customization(UserPoolId, ClientId, CSS,
#'   ImageFile)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param ClientId The client ID for the client app.
#' @param CSS The CSS values in the UI customization.
#' @param ImageFile The uploaded logo image for the UI customization.
#'
#' @section Request syntax:
#' ```
#' svc$set_ui_customization(
#'   UserPoolId = "string",
#'   ClientId = "string",
#'   CSS = "string",
#'   ImageFile = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_ui_customization
cognitoidentityprovider_set_ui_customization <- function(UserPoolId, ClientId = NULL, CSS = NULL, ImageFile = NULL) {
  op <- new_operation(
    name = "SetUICustomization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_ui_customization_input(UserPoolId = UserPoolId, ClientId = ClientId, CSS = CSS, ImageFile = ImageFile)
  output <- .cognitoidentityprovider$set_ui_customization_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_ui_customization <- cognitoidentityprovider_set_ui_customization

#' Set the user's multi-factor authentication (MFA) method preference
#'
#' Set the user\'s multi-factor authentication (MFA) method preference.
#'
#' @usage
#' cognitoidentityprovider_set_user_mfa_preference(SMSMfaSettings,
#'   SoftwareTokenMfaSettings, AccessToken)
#'
#' @param SMSMfaSettings The SMS text message multi-factor authentication (MFA) settings.
#' @param SoftwareTokenMfaSettings The time-based one-time password software token MFA settings.
#' @param AccessToken &#91;required&#93; The access token.
#'
#' @section Request syntax:
#' ```
#' svc$set_user_mfa_preference(
#'   SMSMfaSettings = list(
#'     Enabled = TRUE|FALSE,
#'     PreferredMfa = TRUE|FALSE
#'   ),
#'   SoftwareTokenMfaSettings = list(
#'     Enabled = TRUE|FALSE,
#'     PreferredMfa = TRUE|FALSE
#'   ),
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_mfa_preference
cognitoidentityprovider_set_user_mfa_preference <- function(SMSMfaSettings = NULL, SoftwareTokenMfaSettings = NULL, AccessToken) {
  op <- new_operation(
    name = "SetUserMFAPreference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_mfa_preference_input(SMSMfaSettings = SMSMfaSettings, SoftwareTokenMfaSettings = SoftwareTokenMfaSettings, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$set_user_mfa_preference_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_mfa_preference <- cognitoidentityprovider_set_user_mfa_preference

#' Set the user pool MFA configuration
#'
#' Set the user pool MFA configuration.
#'
#' @usage
#' cognitoidentityprovider_set_user_pool_mfa_config(UserPoolId,
#'   SmsMfaConfiguration, SoftwareTokenMfaConfiguration, MfaConfiguration)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param SmsMfaConfiguration The SMS text message MFA configuration.
#' @param SoftwareTokenMfaConfiguration The software token MFA configuration.
#' @param MfaConfiguration The MFA configuration.
#'
#' @section Request syntax:
#' ```
#' svc$set_user_pool_mfa_config(
#'   UserPoolId = "string",
#'   SmsMfaConfiguration = list(
#'     SmsAuthenticationMessage = "string",
#'     SmsConfiguration = list(
#'       SnsCallerArn = "string",
#'       ExternalId = "string"
#'     )
#'   ),
#'   SoftwareTokenMfaConfiguration = list(
#'     Enabled = TRUE|FALSE
#'   ),
#'   MfaConfiguration = "OFF"|"ON"|"OPTIONAL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_pool_mfa_config
cognitoidentityprovider_set_user_pool_mfa_config <- function(UserPoolId, SmsMfaConfiguration = NULL, SoftwareTokenMfaConfiguration = NULL, MfaConfiguration = NULL) {
  op <- new_operation(
    name = "SetUserPoolMfaConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_pool_mfa_config_input(UserPoolId = UserPoolId, SmsMfaConfiguration = SmsMfaConfiguration, SoftwareTokenMfaConfiguration = SoftwareTokenMfaConfiguration, MfaConfiguration = MfaConfiguration)
  output <- .cognitoidentityprovider$set_user_pool_mfa_config_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_pool_mfa_config <- cognitoidentityprovider_set_user_pool_mfa_config

#' Sets the user settings like multi-factor authentication (MFA)
#'
#' Sets the user settings like multi-factor authentication (MFA). If MFA is
#' to be removed for a particular attribute pass the attribute with code
#' delivery as null. If null list is passed, all MFA options are removed.
#'
#' @usage
#' cognitoidentityprovider_set_user_settings(AccessToken, MFAOptions)
#'
#' @param AccessToken &#91;required&#93; The access token for the set user settings request.
#' @param MFAOptions &#91;required&#93; Specifies the options for MFA (e.g., email or phone number).
#'
#' @section Request syntax:
#' ```
#' svc$set_user_settings(
#'   AccessToken = "string",
#'   MFAOptions = list(
#'     list(
#'       DeliveryMedium = "SMS"|"EMAIL",
#'       AttributeName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_settings
cognitoidentityprovider_set_user_settings <- function(AccessToken, MFAOptions) {
  op <- new_operation(
    name = "SetUserSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_settings_input(AccessToken = AccessToken, MFAOptions = MFAOptions)
  output <- .cognitoidentityprovider$set_user_settings_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_settings <- cognitoidentityprovider_set_user_settings

#' Registers the user in the specified user pool and creates a user name,
#' password, and user attributes
#'
#' Registers the user in the specified user pool and creates a user name,
#' password, and user attributes.
#'
#' @usage
#' cognitoidentityprovider_sign_up(ClientId, SecretHash, Username,
#'   Password, UserAttributes, ValidationData, AnalyticsMetadata,
#'   UserContextData)
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user you wish to register.
#' @param Password &#91;required&#93; The password of the user you wish to register.
#' @param UserAttributes An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' @param ValidationData The validation data in the request to register a user.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' `SignUp` calls.
#' @param UserContextData Contextual data such as the user\'s device fingerprint, IP address, or
#' location used for evaluating the risk of an unexpected event by Amazon
#' Cognito advanced security.
#'
#' @section Request syntax:
#' ```
#' svc$sign_up(
#'   ClientId = "string",
#'   SecretHash = "string",
#'   Username = "string",
#'   Password = "string",
#'   UserAttributes = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ValidationData = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   AnalyticsMetadata = list(
#'     AnalyticsEndpointId = "string"
#'   ),
#'   UserContextData = list(
#'     EncodedData = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_sign_up
cognitoidentityprovider_sign_up <- function(ClientId, SecretHash = NULL, Username, Password, UserAttributes = NULL, ValidationData = NULL, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "SignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$sign_up_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, Password = Password, UserAttributes = UserAttributes, ValidationData = ValidationData, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$sign_up_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$sign_up <- cognitoidentityprovider_sign_up

#' Starts the user import
#'
#' Starts the user import.
#'
#' @usage
#' cognitoidentityprovider_start_user_import_job(UserPoolId, JobId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @section Request syntax:
#' ```
#' svc$start_user_import_job(
#'   UserPoolId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_start_user_import_job
cognitoidentityprovider_start_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "StartUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$start_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$start_user_import_job_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$start_user_import_job <- cognitoidentityprovider_start_user_import_job

#' Stops the user import job
#'
#' Stops the user import job.
#'
#' @usage
#' cognitoidentityprovider_stop_user_import_job(UserPoolId, JobId)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @section Request syntax:
#' ```
#' svc$stop_user_import_job(
#'   UserPoolId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_stop_user_import_job
cognitoidentityprovider_stop_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "StopUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$stop_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$stop_user_import_job_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$stop_user_import_job <- cognitoidentityprovider_stop_user_import_job

#' Assigns a set of tags to an Amazon Cognito user pool
#'
#' Assigns a set of tags to an Amazon Cognito user pool. A tag is a label
#' that you can use to categorize and manage user pools in different ways,
#' such as by purpose, owner, environment, or other criteria.
#' 
#' Each tag consists of a key and value, both of which you define. A key is
#' a general category for more specific values. For example, if you have
#' two versions of a user pool, one for testing and another for production,
#' you might assign an `Environment` tag key to both user pools. The value
#' of this key might be `Test` for one user pool and `Production` for the
#' other.
#' 
#' Tags are useful for cost tracking and access control. You can activate
#' your tags so that they appear on the Billing and Cost Management
#' console, where you can track the costs associated with your user pools.
#' In an IAM policy, you can constrain permissions for user pools based on
#' specific tags or tag values.
#' 
#' You can use this action up to 5 times per second, per account. A user
#' pool can have as many as 50 tags.
#'
#' @usage
#' cognitoidentityprovider_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool to assign the tags to.
#' @param Tags The tags to assign to the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_tag_resource
cognitoidentityprovider_tag_resource <- function(ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cognitoidentityprovider$tag_resource_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$tag_resource <- cognitoidentityprovider_tag_resource

#' Removes the specified tags from an Amazon Cognito user pool
#'
#' Removes the specified tags from an Amazon Cognito user pool. You can use
#' this action up to 5 times per second, per account
#'
#' @usage
#' cognitoidentityprovider_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool that the tags are
#' assigned to.
#' @param TagKeys The keys of the tags to remove from the user pool.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_untag_resource
cognitoidentityprovider_untag_resource <- function(ResourceArn, TagKeys = NULL) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cognitoidentityprovider$untag_resource_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$untag_resource <- cognitoidentityprovider_untag_resource

#' Provides the feedback for an authentication event whether it was from a
#' valid user or not
#'
#' Provides the feedback for an authentication event whether it was from a
#' valid user or not. This feedback is used for improving the risk
#' evaluation decision for the user pool as part of Amazon Cognito advanced
#' security.
#'
#' @usage
#' cognitoidentityprovider_update_auth_event_feedback(UserPoolId, Username,
#'   EventId, FeedbackToken, FeedbackValue)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username.
#' @param EventId &#91;required&#93; The event ID.
#' @param FeedbackToken &#91;required&#93; The feedback token.
#' @param FeedbackValue &#91;required&#93; The authentication event feedback value.
#'
#' @section Request syntax:
#' ```
#' svc$update_auth_event_feedback(
#'   UserPoolId = "string",
#'   Username = "string",
#'   EventId = "string",
#'   FeedbackToken = "string",
#'   FeedbackValue = "Valid"|"Invalid"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_auth_event_feedback
cognitoidentityprovider_update_auth_event_feedback <- function(UserPoolId, Username, EventId, FeedbackToken, FeedbackValue) {
  op <- new_operation(
    name = "UpdateAuthEventFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_auth_event_feedback_input(UserPoolId = UserPoolId, Username = Username, EventId = EventId, FeedbackToken = FeedbackToken, FeedbackValue = FeedbackValue)
  output <- .cognitoidentityprovider$update_auth_event_feedback_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_auth_event_feedback <- cognitoidentityprovider_update_auth_event_feedback

#' Updates the device status
#'
#' Updates the device status.
#'
#' @usage
#' cognitoidentityprovider_update_device_status(AccessToken, DeviceKey,
#'   DeviceRememberedStatus)
#'
#' @param AccessToken &#91;required&#93; The access token.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceRememberedStatus The status of whether a device is remembered.
#'
#' @section Request syntax:
#' ```
#' svc$update_device_status(
#'   AccessToken = "string",
#'   DeviceKey = "string",
#'   DeviceRememberedStatus = "remembered"|"not_remembered"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_device_status
cognitoidentityprovider_update_device_status <- function(AccessToken, DeviceKey, DeviceRememberedStatus = NULL) {
  op <- new_operation(
    name = "UpdateDeviceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_device_status_input(AccessToken = AccessToken, DeviceKey = DeviceKey, DeviceRememberedStatus = DeviceRememberedStatus)
  output <- .cognitoidentityprovider$update_device_status_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_device_status <- cognitoidentityprovider_update_device_status

#' Updates the specified group with the specified attributes
#'
#' Updates the specified group with the specified attributes.
#' 
#' Requires developer credentials.
#'
#' @usage
#' cognitoidentityprovider_update_group(GroupName, UserPoolId, Description,
#'   RoleArn, Precedence)
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Description A string containing the new description of the group.
#' @param RoleArn The new role ARN for the group. This is used for setting the
#' `cognito:roles` and `cognito:preferred_role` claims in the token.
#' @param Precedence The new precedence value for the group. For more information about this
#' parameter, see .
#'
#' @section Request syntax:
#' ```
#' svc$update_group(
#'   GroupName = "string",
#'   UserPoolId = "string",
#'   Description = "string",
#'   RoleArn = "string",
#'   Precedence = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_group
cognitoidentityprovider_update_group <- function(GroupName, UserPoolId, Description = NULL, RoleArn = NULL, Precedence = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_group_input(GroupName = GroupName, UserPoolId = UserPoolId, Description = Description, RoleArn = RoleArn, Precedence = Precedence)
  output <- .cognitoidentityprovider$update_group_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_group <- cognitoidentityprovider_update_group

#' Updates identity provider information for a user pool
#'
#' Updates identity provider information for a user pool.
#'
#' @usage
#' cognitoidentityprovider_update_identity_provider(UserPoolId,
#'   ProviderName, ProviderDetails, AttributeMapping, IdpIdentifiers)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The identity provider name.
#' @param ProviderDetails The identity provider details to be updated, such as `MetadataURL` and
#' `MetadataFile`.
#' @param AttributeMapping The identity provider attribute mapping to be changed.
#' @param IdpIdentifiers A list of identity provider identifiers.
#'
#' @section Request syntax:
#' ```
#' svc$update_identity_provider(
#'   UserPoolId = "string",
#'   ProviderName = "string",
#'   ProviderDetails = list(
#'     "string"
#'   ),
#'   AttributeMapping = list(
#'     "string"
#'   ),
#'   IdpIdentifiers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_identity_provider
cognitoidentityprovider_update_identity_provider <- function(UserPoolId, ProviderName, ProviderDetails = NULL, AttributeMapping = NULL, IdpIdentifiers = NULL) {
  op <- new_operation(
    name = "UpdateIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName, ProviderDetails = ProviderDetails, AttributeMapping = AttributeMapping, IdpIdentifiers = IdpIdentifiers)
  output <- .cognitoidentityprovider$update_identity_provider_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_identity_provider <- cognitoidentityprovider_update_identity_provider

#' Updates the name and scopes of resource server
#'
#' Updates the name and scopes of resource server. All other fields are
#' read-only.
#'
#' @usage
#' cognitoidentityprovider_update_resource_server(UserPoolId, Identifier,
#'   Name, Scopes)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Identifier &#91;required&#93; The identifier for the resource server.
#' @param Name &#91;required&#93; The name of the resource server.
#' @param Scopes The scope values to be set for the resource server.
#'
#' @section Request syntax:
#' ```
#' svc$update_resource_server(
#'   UserPoolId = "string",
#'   Identifier = "string",
#'   Name = "string",
#'   Scopes = list(
#'     list(
#'       ScopeName = "string",
#'       ScopeDescription = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_resource_server
cognitoidentityprovider_update_resource_server <- function(UserPoolId, Identifier, Name, Scopes = NULL) {
  op <- new_operation(
    name = "UpdateResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier, Name = Name, Scopes = Scopes)
  output <- .cognitoidentityprovider$update_resource_server_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_resource_server <- cognitoidentityprovider_update_resource_server

#' Allows a user to update a specific attribute (one at a time)
#'
#' Allows a user to update a specific attribute (one at a time).
#'
#' @usage
#' cognitoidentityprovider_update_user_attributes(UserAttributes,
#'   AccessToken)
#'
#' @param UserAttributes &#91;required&#93; An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' @param AccessToken &#91;required&#93; The access token for the request to update user attributes.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_attributes(
#'   UserAttributes = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   AccessToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_attributes
cognitoidentityprovider_update_user_attributes <- function(UserAttributes, AccessToken) {
  op <- new_operation(
    name = "UpdateUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_attributes_input(UserAttributes = UserAttributes, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$update_user_attributes_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_attributes <- cognitoidentityprovider_update_user_attributes

#' Updates the specified user pool with the specified attributes
#'
#' Updates the specified user pool with the specified attributes. If you
#' don\'t provide a value for an attribute, it will be set to the default
#' value. You can get a list of the current user pool settings with .
#'
#' @usage
#' cognitoidentityprovider_update_user_pool(UserPoolId, Policies,
#'   LambdaConfig, AutoVerifiedAttributes, SmsVerificationMessage,
#'   EmailVerificationMessage, EmailVerificationSubject,
#'   VerificationMessageTemplate, SmsAuthenticationMessage, MfaConfiguration,
#'   DeviceConfiguration, EmailConfiguration, SmsConfiguration, UserPoolTags,
#'   AdminCreateUserConfig, UserPoolAddOns)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to update.
#' @param Policies A container with the policies you wish to update in a user pool.
#' @param LambdaConfig The AWS Lambda configuration information from the request to update the
#' user pool.
#' @param AutoVerifiedAttributes The attributes that are automatically verified when the Amazon Cognito
#' service makes a request to update user pools.
#' @param SmsVerificationMessage A container with information about the SMS verification message.
#' @param EmailVerificationMessage The contents of the email verification message.
#' @param EmailVerificationSubject The subject of the email verification message.
#' @param VerificationMessageTemplate The template for verification messages.
#' @param SmsAuthenticationMessage The contents of the SMS authentication message.
#' @param MfaConfiguration Can be one of the following values:
#' 
#' -   `OFF` - MFA tokens are not required and cannot be specified during
#'     user registration.
#' 
#' -   `ON` - MFA tokens are required for all user registrations. You can
#'     only specify required when you are initially creating a user pool.
#' 
#' -   `OPTIONAL` - Users have the option when registering to create an MFA
#'     token.
#' @param DeviceConfiguration Device configuration.
#' @param EmailConfiguration Email configuration.
#' @param SmsConfiguration SMS configuration.
#' @param UserPoolTags The tag keys and values to assign to the user pool. A tag is a label
#' that you can use to categorize and manage user pools in different ways,
#' such as by purpose, owner, environment, or other criteria.
#' @param AdminCreateUserConfig The configuration for `AdminCreateUser` requests.
#' @param UserPoolAddOns Used to enable advanced security risk detection. Set the key
#' `AdvancedSecurityMode` to the value \"AUDIT\".
#'
#' @section Request syntax:
#' ```
#' svc$update_user_pool(
#'   UserPoolId = "string",
#'   Policies = list(
#'     PasswordPolicy = list(
#'       MinimumLength = 123,
#'       RequireUppercase = TRUE|FALSE,
#'       RequireLowercase = TRUE|FALSE,
#'       RequireNumbers = TRUE|FALSE,
#'       RequireSymbols = TRUE|FALSE
#'     )
#'   ),
#'   LambdaConfig = list(
#'     PreSignUp = "string",
#'     CustomMessage = "string",
#'     PostConfirmation = "string",
#'     PreAuthentication = "string",
#'     PostAuthentication = "string",
#'     DefineAuthChallenge = "string",
#'     CreateAuthChallenge = "string",
#'     VerifyAuthChallengeResponse = "string",
#'     PreTokenGeneration = "string",
#'     UserMigration = "string"
#'   ),
#'   AutoVerifiedAttributes = list(
#'     "phone_number"|"email"
#'   ),
#'   SmsVerificationMessage = "string",
#'   EmailVerificationMessage = "string",
#'   EmailVerificationSubject = "string",
#'   VerificationMessageTemplate = list(
#'     SmsMessage = "string",
#'     EmailMessage = "string",
#'     EmailSubject = "string",
#'     EmailMessageByLink = "string",
#'     EmailSubjectByLink = "string",
#'     DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
#'   ),
#'   SmsAuthenticationMessage = "string",
#'   MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
#'   DeviceConfiguration = list(
#'     ChallengeRequiredOnNewDevice = TRUE|FALSE,
#'     DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
#'   ),
#'   EmailConfiguration = list(
#'     SourceArn = "string",
#'     ReplyToEmailAddress = "string"
#'   ),
#'   SmsConfiguration = list(
#'     SnsCallerArn = "string",
#'     ExternalId = "string"
#'   ),
#'   UserPoolTags = list(
#'     "string"
#'   ),
#'   AdminCreateUserConfig = list(
#'     AllowAdminCreateUserOnly = TRUE|FALSE,
#'     UnusedAccountValidityDays = 123,
#'     InviteMessageTemplate = list(
#'       SMSMessage = "string",
#'       EmailMessage = "string",
#'       EmailSubject = "string"
#'     )
#'   ),
#'   UserPoolAddOns = list(
#'     AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool
cognitoidentityprovider_update_user_pool <- function(UserPoolId, Policies = NULL, LambdaConfig = NULL, AutoVerifiedAttributes = NULL, SmsVerificationMessage = NULL, EmailVerificationMessage = NULL, EmailVerificationSubject = NULL, VerificationMessageTemplate = NULL, SmsAuthenticationMessage = NULL, MfaConfiguration = NULL, DeviceConfiguration = NULL, EmailConfiguration = NULL, SmsConfiguration = NULL, UserPoolTags = NULL, AdminCreateUserConfig = NULL, UserPoolAddOns = NULL) {
  op <- new_operation(
    name = "UpdateUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_input(UserPoolId = UserPoolId, Policies = Policies, LambdaConfig = LambdaConfig, AutoVerifiedAttributes = AutoVerifiedAttributes, SmsVerificationMessage = SmsVerificationMessage, EmailVerificationMessage = EmailVerificationMessage, EmailVerificationSubject = EmailVerificationSubject, VerificationMessageTemplate = VerificationMessageTemplate, SmsAuthenticationMessage = SmsAuthenticationMessage, MfaConfiguration = MfaConfiguration, DeviceConfiguration = DeviceConfiguration, EmailConfiguration = EmailConfiguration, SmsConfiguration = SmsConfiguration, UserPoolTags = UserPoolTags, AdminCreateUserConfig = AdminCreateUserConfig, UserPoolAddOns = UserPoolAddOns)
  output <- .cognitoidentityprovider$update_user_pool_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool <- cognitoidentityprovider_update_user_pool

#' Updates the specified user pool app client with the specified attributes
#'
#' Updates the specified user pool app client with the specified
#' attributes. If you don\'t provide a value for an attribute, it will be
#' set to the default value. You can get a list of the current user pool
#' app client settings with .
#'
#' @usage
#' cognitoidentityprovider_update_user_pool_client(UserPoolId, ClientId,
#'   ClientName, RefreshTokenValidity, ReadAttributes, WriteAttributes,
#'   ExplicitAuthFlows, SupportedIdentityProviders, CallbackURLs, LogoutURLs,
#'   DefaultRedirectURI, AllowedOAuthFlows, AllowedOAuthScopes,
#'   AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration)
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to update the user
#' pool client.
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param ClientName The client name from the update user pool client request.
#' @param RefreshTokenValidity The time limit, in days, after which the refresh token is no longer
#' valid and cannot be used.
#' @param ReadAttributes The read-only attributes of the user pool.
#' @param WriteAttributes The writeable attributes of the user pool.
#' @param ExplicitAuthFlows Explicit authentication flows.
#' @param SupportedIdentityProviders A list of provider names for the identity providers that are supported
#' on this client.
#' @param CallbackURLs A list of allowed redirect (callback) URLs for the identity providers.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param LogoutURLs A list of allowed logout URLs for the identity providers.
#' @param DefaultRedirectURI The default redirect URI. Must be in the `CallbackURLs` list.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param AllowedOAuthFlows Set to `code` to initiate a code grant flow, which provides an
#' authorization code as the response. This code can be exchanged for
#' access tokens with the token endpoint.
#' 
#' Set to `token` to specify that the client should get the access token
#' (and, optionally, ID token, based on scopes) directly.
#' @param AllowedOAuthScopes A list of allowed `OAuth` scopes. Currently supported values are
#' `"phone"`, `"email"`, `"openid"`, and `"Cognito"`.
#' @param AllowedOAuthFlowsUserPoolClient Set to TRUE if the client is allowed to follow the OAuth protocol when
#' interacting with Cognito user pools.
#' @param AnalyticsConfiguration The Amazon Pinpoint analytics configuration for collecting metrics for
#' this user pool.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_pool_client(
#'   UserPoolId = "string",
#'   ClientId = "string",
#'   ClientName = "string",
#'   RefreshTokenValidity = 123,
#'   ReadAttributes = list(
#'     "string"
#'   ),
#'   WriteAttributes = list(
#'     "string"
#'   ),
#'   ExplicitAuthFlows = list(
#'     "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"
#'   ),
#'   SupportedIdentityProviders = list(
#'     "string"
#'   ),
#'   CallbackURLs = list(
#'     "string"
#'   ),
#'   LogoutURLs = list(
#'     "string"
#'   ),
#'   DefaultRedirectURI = "string",
#'   AllowedOAuthFlows = list(
#'     "code"|"implicit"|"client_credentials"
#'   ),
#'   AllowedOAuthScopes = list(
#'     "string"
#'   ),
#'   AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
#'   AnalyticsConfiguration = list(
#'     ApplicationId = "string",
#'     RoleArn = "string",
#'     ExternalId = "string",
#'     UserDataShared = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool_client
cognitoidentityprovider_update_user_pool_client <- function(UserPoolId, ClientId, ClientName = NULL, RefreshTokenValidity = NULL, ReadAttributes = NULL, WriteAttributes = NULL, ExplicitAuthFlows = NULL, SupportedIdentityProviders = NULL, CallbackURLs = NULL, LogoutURLs = NULL, DefaultRedirectURI = NULL, AllowedOAuthFlows = NULL, AllowedOAuthScopes = NULL, AllowedOAuthFlowsUserPoolClient = NULL, AnalyticsConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId, ClientName = ClientName, RefreshTokenValidity = RefreshTokenValidity, ReadAttributes = ReadAttributes, WriteAttributes = WriteAttributes, ExplicitAuthFlows = ExplicitAuthFlows, SupportedIdentityProviders = SupportedIdentityProviders, CallbackURLs = CallbackURLs, LogoutURLs = LogoutURLs, DefaultRedirectURI = DefaultRedirectURI, AllowedOAuthFlows = AllowedOAuthFlows, AllowedOAuthScopes = AllowedOAuthScopes, AllowedOAuthFlowsUserPoolClient = AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration = AnalyticsConfiguration)
  output <- .cognitoidentityprovider$update_user_pool_client_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool_client <- cognitoidentityprovider_update_user_pool_client

#' Updates the Secure Sockets Layer (SSL) certificate for the custom domain
#' for your user pool
#'
#' Updates the Secure Sockets Layer (SSL) certificate for the custom domain
#' for your user pool.
#' 
#' You can use this operation to provide the Amazon Resource Name (ARN) of
#' a new certificate to Amazon Cognito. You cannot use it to change the
#' domain for a user pool.
#' 
#' A custom domain is used to host the Amazon Cognito hosted UI, which
#' provides sign-up and sign-in pages for your application. When you set up
#' a custom domain, you provide a certificate that you manage with AWS
#' Certificate Manager (ACM). When necessary, you can use this operation to
#' change the certificate that you applied to your custom domain.
#' 
#' Usually, this is unnecessary following routine certificate renewal with
#' ACM. When you renew your existing certificate in ACM, the ARN for your
#' certificate remains the same, and your custom domain uses the new
#' certificate automatically.
#' 
#' However, if you replace your existing certificate with a new one, ACM
#' gives the new certificate a new ARN. To apply the new certificate to
#' your custom domain, you must provide this ARN to Amazon Cognito.
#' 
#' When you add your new certificate in ACM, you must choose US East (N.
#' Virginia) as the AWS Region.
#' 
#' After you submit your request, Amazon Cognito requires up to 1 hour to
#' distribute your new certificate to your custom domain.
#' 
#' For more information about adding a custom domain to your user pool, see
#' [Using Your Own Domain for the Hosted
#' UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
#'
#' @usage
#' cognitoidentityprovider_update_user_pool_domain(Domain, UserPoolId,
#'   CustomDomainConfig)
#'
#' @param Domain &#91;required&#93; The domain name for the custom domain that hosts the sign-up and sign-in
#' pages for your application. For example: `auth.example.com`.
#' 
#' This string can include only lowercase letters, numbers, and hyphens. Do
#' not use a hyphen for the first or last character. Use periods to
#' separate subdomain names.
#' @param UserPoolId &#91;required&#93; The ID of the user pool that is associated with the custom domain that
#' you are updating the certificate for.
#' @param CustomDomainConfig &#91;required&#93; The configuration for a custom domain that hosts the sign-up and sign-in
#' pages for your application. Use this object to specify an SSL
#' certificate that is managed by ACM.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_pool_domain(
#'   Domain = "string",
#'   UserPoolId = "string",
#'   CustomDomainConfig = list(
#'     CertificateArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool_domain
cognitoidentityprovider_update_user_pool_domain <- function(Domain, UserPoolId, CustomDomainConfig) {
  op <- new_operation(
    name = "UpdateUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId, CustomDomainConfig = CustomDomainConfig)
  output <- .cognitoidentityprovider$update_user_pool_domain_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool_domain <- cognitoidentityprovider_update_user_pool_domain

#' Use this API to register a user's entered TOTP code and mark the user's
#' software token MFA status as "verified" if successful
#'
#' Use this API to register a user\'s entered TOTP code and mark the
#' user\'s software token MFA status as \"verified\" if successful. The
#' request takes an access token or a session string, but not both.
#'
#' @usage
#' cognitoidentityprovider_verify_software_token(AccessToken, Session,
#'   UserCode, FriendlyDeviceName)
#'
#' @param AccessToken The access token.
#' @param Session The session which should be passed both ways in challenge-response calls
#' to the service.
#' @param UserCode &#91;required&#93; The one time password computed using the secret code returned by
#' @param FriendlyDeviceName The friendly device name.
#'
#' @section Request syntax:
#' ```
#' svc$verify_software_token(
#'   AccessToken = "string",
#'   Session = "string",
#'   UserCode = "string",
#'   FriendlyDeviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_verify_software_token
cognitoidentityprovider_verify_software_token <- function(AccessToken = NULL, Session = NULL, UserCode, FriendlyDeviceName = NULL) {
  op <- new_operation(
    name = "VerifySoftwareToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$verify_software_token_input(AccessToken = AccessToken, Session = Session, UserCode = UserCode, FriendlyDeviceName = FriendlyDeviceName)
  output <- .cognitoidentityprovider$verify_software_token_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$verify_software_token <- cognitoidentityprovider_verify_software_token

#' Verifies the specified user attributes in the user pool
#'
#' Verifies the specified user attributes in the user pool.
#'
#' @usage
#' cognitoidentityprovider_verify_user_attribute(AccessToken,
#'   AttributeName, Code)
#'
#' @param AccessToken &#91;required&#93; Represents the access token of the request to verify user attributes.
#' @param AttributeName &#91;required&#93; The attribute name in the request to verify user attributes.
#' @param Code &#91;required&#93; The verification code in the request to verify user attributes.
#'
#' @section Request syntax:
#' ```
#' svc$verify_user_attribute(
#'   AccessToken = "string",
#'   AttributeName = "string",
#'   Code = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_verify_user_attribute
cognitoidentityprovider_verify_user_attribute <- function(AccessToken, AttributeName, Code) {
  op <- new_operation(
    name = "VerifyUserAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$verify_user_attribute_input(AccessToken = AccessToken, AttributeName = AttributeName, Code = Code)
  output <- .cognitoidentityprovider$verify_user_attribute_output()
  svc <- .cognitoidentityprovider$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$verify_user_attribute <- cognitoidentityprovider_verify_user_attribute
