% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_instance_profile}
\alias{iam_get_instance_profile}
\title{Retrieves information about the specified instance profile, including
the instance profile's path, GUID, ARN, and role}
\usage{
iam_get_instance_profile(InstanceProfileName)
}
\arguments{
\item{InstanceProfileName}{[required] The name of the instance profile to get information about.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}
}
\description{
Retrieves information about the specified instance profile, including
the instance profile's path, GUID, ARN, and role. For more information
about instance profiles, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html}{About Instance Profiles}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_instance_profile(
  InstanceProfileName = "string"
)
}
}

\examples{
# The following command gets information about the instance profile named
# ExampleInstanceProfile.
\donttest{svc$get_instance_profile(
  InstanceProfileName = "ExampleInstanceProfile"
)}

}
\keyword{internal}
