# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Certificate Manager
#'
#' @description
#' Welcome to the AWS Certificate Manager (ACM) API documentation.
#' 
#' You can use ACM to manage SSL/TLS certificates for your AWS-based
#' websites and applications. For general information about using ACM, see
#' the [*AWS Certificate Manager User
#' Guide*](https://docs.aws.amazon.com/acm/latest/userguide/) .
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- acm(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- acm()
#' svc$add_tags_to_certificate(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=acm_add_tags_to_certificate]{add_tags_to_certificate} \tab Adds one or more tags to an ACM certificate\cr
#'  \link[=acm_delete_certificate]{delete_certificate} \tab Deletes a certificate and its associated private key\cr
#'  \link[=acm_describe_certificate]{describe_certificate} \tab Returns detailed metadata about the specified ACM certificate\cr
#'  \link[=acm_export_certificate]{export_certificate} \tab Exports a private certificate issued by a private certificate authority (CA) for use anywhere\cr
#'  \link[=acm_get_certificate]{get_certificate} \tab Retrieves an Amazon-issued certificate and its certificate chain\cr
#'  \link[=acm_import_certificate]{import_certificate} \tab Imports a certificate into AWS Certificate Manager (ACM) to use with services that are integrated with ACM\cr
#'  \link[=acm_list_certificates]{list_certificates} \tab Retrieves a list of certificate ARNs and domain names\cr
#'  \link[=acm_list_tags_for_certificate]{list_tags_for_certificate} \tab Lists the tags that have been applied to the ACM certificate\cr
#'  \link[=acm_remove_tags_from_certificate]{remove_tags_from_certificate} \tab Remove one or more tags from an ACM certificate\cr
#'  \link[=acm_renew_certificate]{renew_certificate} \tab Renews an eligable ACM certificate\cr
#'  \link[=acm_request_certificate]{request_certificate} \tab Requests an ACM certificate for use with other AWS services\cr
#'  \link[=acm_resend_validation_email]{resend_validation_email} \tab Resends the email that requests domain ownership validation\cr
#'  \link[=acm_update_certificate_options]{update_certificate_options} \tab Updates a certificate
#' }
#'
#' @rdname acm
#' @export
acm <- function(config = list()) {
  svc <- .acm$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.acm <- list()

.acm$operations <- list()

.acm$metadata <- list(
  service_name = "acm",
  endpoints = list("*" = list(endpoint = "acm.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "acm.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "acm.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "acm.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "ACM",
  api_version = "2015-12-08",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "CertificateManager"
)

.acm$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.acm$metadata, handlers, config)
}
