% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_threat_intel_set}
\alias{guardduty_create_threat_intel_set}
\title{Creates a new ThreatIntelSet}
\usage{
guardduty_create_threat_intel_set(DetectorId, Name, Format, Location,
  Activate, ClientToken, Tags)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account that you want to
create a threatIntelSet for.}

\item{Name}{[required] A user-friendly ThreatIntelSet name displayed in all findings that are
generated by activity that involves IP addresses included in this
ThreatIntelSet.}

\item{Format}{[required] The format of the file that contains the ThreatIntelSet.}

\item{Location}{[required] The URI of the file that contains the ThreatIntelSet. For example:
https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.}

\item{Activate}{[required] A Boolean value that indicates whether GuardDuty is to start using the
uploaded ThreatIntelSet.}

\item{ClientToken}{The idempotency token for the create request.}

\item{Tags}{The tags to be added to a new threat list resource.}
}
\description{
Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious
IP addresses. GuardDuty generates findings based on ThreatIntelSets.
Only users of the administrator account can use this operation.
}
\section{Request syntax}{
\preformatted{svc$create_threat_intel_set(
  DetectorId = "string",
  Name = "string",
  Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
  Location = "string",
  Activate = TRUE|FALSE,
  ClientToken = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
