% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_role_policy}
\alias{iam_delete_role_policy}
\title{Deletes the specified inline policy that is embedded in the specified
IAM role}
\usage{
iam_delete_role_policy(RoleName, PolicyName)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) identifying the role that the policy
is embedded in.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{PolicyName}{[required] The name of the inline policy to delete from the specified IAM role.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Deletes the specified inline policy that is embedded in the specified
IAM role.

A role can also have managed policies attached to it. To detach a
managed policy from a role, use DetachRolePolicy. For more information
about policies, refer to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_role_policy(
  RoleName = "string",
  PolicyName = "string"
)
}
}

\examples{
\dontrun{
# The following command removes the policy named ExamplePolicy from the
# role named Test-Role.
svc$delete_role_policy(
  PolicyName = "ExamplePolicy",
  RoleName = "Test-Role"
)
}

}
\keyword{internal}
