% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_saml_provider}
\alias{iam_delete_saml_provider}
\title{Deletes a SAML provider resource in IAM}
\usage{
iam_delete_saml_provider(SAMLProviderArn)
}
\arguments{
\item{SAMLProviderArn}{[required] The Amazon Resource Name (ARN) of the SAML provider to delete.}
}
\description{
Deletes a SAML provider resource in IAM.

Deleting the provider resource from IAM does not update any roles that
reference the SAML provider resource's ARN as a principal in their trust
policies. Any attempt to assume a role that references a non-existent
provider resource ARN fails.

This operation requires \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4}.
}
\section{Request syntax}{
\preformatted{svc$delete_saml_provider(
  SAMLProviderArn = "string"
)
}
}

\keyword{internal}
