% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_user_policy}
\alias{iam_delete_user_policy}
\title{Deletes the specified inline policy that is embedded in the specified
IAM user}
\usage{
iam_delete_user_policy(UserName, PolicyName)
}
\arguments{
\item{UserName}{[required] The name (friendly name, not ARN) identifying the user that the policy
is embedded in.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{PolicyName}{[required] The name identifying the policy document to delete.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Deletes the specified inline policy that is embedded in the specified
IAM user.

A user can also have managed policies attached to it. To detach a
managed policy from a user, use DetachUserPolicy. For more information
about policies, refer to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_user_policy(
  UserName = "string",
  PolicyName = "string"
)
}
}

\examples{
\dontrun{
# The following delete-user-policy command removes the specified policy
# from the IAM user named Juan:
svc$delete_user_policy(
  PolicyName = "ExamplePolicy",
  UserName = "Juan"
)
}

}
\keyword{internal}
