% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_user_tags}
\alias{iam_list_user_tags}
\title{Lists the tags that are attached to the specified user}
\usage{
iam_list_user_tags(UserName, Marker, MaxItems)
}
\arguments{
\item{UserName}{[required] The name of the IAM user whose tags you want to see.

This parameter accepts (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that consist of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: =,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{(Optional) Use this only when paginating results to indicate the maximum
number of items that you want in the response. If additional items exist
beyond the maximum that you specify, the \code{IsTruncated} response element
is \code{true}.

If you do not include this parameter, it defaults to 100. Note that IAM
might return fewer results, even when more results are available. In
that case, the \code{IsTruncated} response element returns \code{true}, and
\code{Marker} contains a value to include in the subsequent call that tells
the service where to continue from.}
}
\description{
Lists the tags that are attached to the specified user. The returned
list of tags is sorted by tag key. For more information about tagging,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM Identities}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_user_tags(
  UserName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following example shows how to list the tags attached to a user.
svc$list_user_tags(
  UserName = "anika"
)
}

}
\keyword{internal}
