% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_request_certificate}
\alias{acm_request_certificate}
\title{Requests an ACM certificate for use with other AWS services}
\usage{
acm_request_certificate(DomainName, ValidationMethod,
  SubjectAlternativeNames, IdempotencyToken, DomainValidationOptions,
  Options, CertificateAuthorityArn, Tags)
}
\arguments{
\item{DomainName}{[required] Fully qualified domain name (FQDN), such as www.example.com, that you
want to secure with an ACM certificate. Use an asterisk (*) to create a
wildcard certificate that protects several sites in the same domain. For
example, *.example.com protects www.example.com, site.example.com, and
images.example.com.

The first domain name you enter cannot exceed 64 octets, including
periods. Each subsequent Subject Alternative Name (SAN), however, can be
up to 253 octets in length.}

\item{ValidationMethod}{The method you want to use if you are requesting a public certificate to
validate that you own or control domain. You can \href{https://docs.aws.amazon.com/acm/latest/userguide/}{validate with DNS} or \href{https://docs.aws.amazon.com/acm/latest/userguide/}{validate with email}. We
recommend that you use DNS validation.}

\item{SubjectAlternativeNames}{Additional FQDNs to be included in the Subject Alternative Name
extension of the ACM certificate. For example, add the name
www.example.net to a certificate for which the \code{DomainName} field is
www.example.com if users can reach your site by using either name. The
maximum number of domain names that you can add to an ACM certificate is
100. However, the initial quota is 10 domain names. If you need more
than 10 names, you must request a quota increase. For more information,
see
\href{https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html}{Quotas}.

The maximum length of a SAN DNS name is 253 octets. The name is made up
of multiple labels separated by periods. No label can be longer than 63
octets. Consider the following examples:
\itemize{
\item \verb{(63 octets).(63 octets).(63 octets).(61 octets)} is legal because
the total length is 253 octets (63+1+63+1+63+1+61) and no label
exceeds 63 octets.
\item \verb{(64 octets).(63 octets).(63 octets).(61 octets)} is not legal
because the total length exceeds 253 octets (64+1+63+1+63+1+61) and
the first label exceeds 63 octets.
\item \verb{(63 octets).(63 octets).(63 octets).(62 octets)} is not legal
because the total length of the DNS name (63+1+63+1+63+1+62) exceeds
253 octets.
}}

\item{IdempotencyToken}{Customer chosen string that can be used to distinguish between calls to
\code{\link[=acm_request_certificate]{request_certificate}}. Idempotency tokens
time out after one hour. Therefore, if you call
\code{\link[=acm_request_certificate]{request_certificate}} multiple times with the
same idempotency token within one hour, ACM recognizes that you are
requesting only one certificate and will issue only one. If you change
the idempotency token for each call, ACM recognizes that you are
requesting multiple certificates.}

\item{DomainValidationOptions}{The domain name that you want ACM to use to send you emails so that you
can validate domain ownership.}

\item{Options}{Currently, you can use this parameter to specify whether to add the
certificate to a certificate transparency log. Certificate transparency
makes it possible to detect SSL/TLS certificates that have been
mistakenly or maliciously issued. Certificates that have not been logged
typically produce an error message in a browser. For more information,
see \href{https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency}{Opting Out of Certificate Transparency Logging}.}

\item{CertificateAuthorityArn}{The Amazon Resource Name (ARN) of the private certificate authority (CA)
that will be used to issue the certificate. If you do not provide an ARN
and you are trying to request a private certificate, ACM will attempt to
issue a public certificate. For more information about private CAs, see
the \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html}{AWS Certificate Manager Private Certificate Authority (PCA)}
user guide. The ARN must have the following form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012}}

\item{Tags}{One or more resource tags to associate with the certificate.}
}
\value{
A list with the following syntax:\preformatted{list(
  CertificateArn = "string"
)
}
}
\description{
Requests an ACM certificate for use with other AWS services. To request
an ACM certificate, you must specify a fully qualified domain name
(FQDN) in the \code{DomainName} parameter. You can also specify additional
FQDNs in the \code{SubjectAlternativeNames} parameter.

If you are requesting a private certificate, domain validation is not
required. If you are requesting a public certificate, each domain name
that you specify must be validated to verify that you own or control the
domain. You can use \href{https://docs.aws.amazon.com/acm/latest/userguide/}{DNS validation} or \href{https://docs.aws.amazon.com/acm/latest/userguide/}{email validation}. We
recommend that you use DNS validation. ACM issues public certificates
after receiving approval from the domain owner.
}
\section{Request syntax}{
\preformatted{svc$request_certificate(
  DomainName = "string",
  ValidationMethod = "EMAIL"|"DNS",
  SubjectAlternativeNames = list(
    "string"
  ),
  IdempotencyToken = "string",
  DomainValidationOptions = list(
    list(
      DomainName = "string",
      ValidationDomain = "string"
    )
  ),
  Options = list(
    CertificateTransparencyLoggingPreference = "ENABLED"|"DISABLED"
  ),
  CertificateAuthorityArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
