% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_get_object_attributes}
\alias{clouddirectory_get_object_attributes}
\title{Retrieves attributes within a facet that are associated with an object}
\usage{
clouddirectory_get_object_attributes(DirectoryArn, ObjectReference,
  ConsistencyLevel, SchemaFacet, AttributeNames)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the object resides.}

\item{ObjectReference}{[required] Reference that identifies the object whose attributes will be retrieved.}

\item{ConsistencyLevel}{The consistency level at which to retrieve the attributes on an object.}

\item{SchemaFacet}{[required] Identifier for the facet whose attributes will be retrieved. See
SchemaFacet for details.}

\item{AttributeNames}{[required] List of attribute names whose values will be retrieved.}
}
\value{
A list with the following syntax:\preformatted{list(
  Attributes = list(
    list(
      Key = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      Value = list(
        StringValue = "string",
        BinaryValue = raw,
        BooleanValue = TRUE|FALSE,
        NumberValue = "string",
        DatetimeValue = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  )
)
}
}
\description{
Retrieves attributes within a facet that are associated with an object.
}
\section{Request syntax}{
\preformatted{svc$get_object_attributes(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL",
  SchemaFacet = list(
    SchemaArn = "string",
    FacetName = "string"
  ),
  AttributeNames = list(
    "string"
  )
)
}
}

\keyword{internal}
