% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_modify_cluster}
\alias{cloudhsmv2_modify_cluster}
\title{Modifies AWS CloudHSM cluster}
\usage{
cloudhsmv2_modify_cluster(BackupRetentionPolicy, ClusterId)
}
\arguments{
\item{BackupRetentionPolicy}{[required] A policy that defines how the service retains backups.}

\item{ClusterId}{[required] The identifier (ID) of the cluster that you want to modify. To find the
cluster ID, use \code{\link[=cloudhsmv2_describe_clusters]{describe_clusters}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Cluster = list(
    BackupPolicy = "DEFAULT",
    BackupRetentionPolicy = list(
      Type = "DAYS",
      Value = "string"
    ),
    ClusterId = "string",
    CreateTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Hsms = list(
      list(
        AvailabilityZone = "string",
        ClusterId = "string",
        SubnetId = "string",
        EniId = "string",
        EniIp = "string",
        HsmId = "string",
        State = "CREATE_IN_PROGRESS"|"ACTIVE"|"DEGRADED"|"DELETE_IN_PROGRESS"|"DELETED",
        StateMessage = "string"
      )
    ),
    HsmType = "string",
    PreCoPassword = "string",
    SecurityGroup = "string",
    SourceBackupId = "string",
    State = "CREATE_IN_PROGRESS"|"UNINITIALIZED"|"INITIALIZE_IN_PROGRESS"|"INITIALIZED"|"ACTIVE"|"UPDATE_IN_PROGRESS"|"DELETE_IN_PROGRESS"|"DELETED"|"DEGRADED",
    StateMessage = "string",
    SubnetMapping = list(
      "string"
    ),
    VpcId = "string",
    Certificates = list(
      ClusterCsr = "string",
      HsmCertificate = "string",
      AwsHardwareCertificate = "string",
      ManufacturerHardwareCertificate = "string",
      ClusterCertificate = "string"
    ),
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Modifies AWS CloudHSM cluster.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster(
  BackupRetentionPolicy = list(
    Type = "DAYS",
    Value = "string"
  ),
  ClusterId = "string"
)
}
}

\keyword{internal}
