% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_list_devices}
\alias{cognitoidentityprovider_admin_list_devices}
\title{Lists devices, as an administrator}
\usage{
cognitoidentityprovider_admin_list_devices(UserPoolId, Username, Limit,
  PaginationToken)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{Username}{[required] The user name.}

\item{Limit}{The limit of the devices request.}

\item{PaginationToken}{The pagination token.}
}
\value{
A list with the following syntax:\preformatted{list(
  Devices = list(
    list(
      DeviceKey = "string",
      DeviceAttributes = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      DeviceCreateDate = as.POSIXct(
        "2015-01-01"
      ),
      DeviceLastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      DeviceLastAuthenticatedDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  PaginationToken = "string"
)
}
}
\description{
Lists devices, as an administrator.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_list_devices(
  UserPoolId = "string",
  Username = "string",
  Limit = 123,
  PaginationToken = "string"
)
}
}

\keyword{internal}
