% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_ip_set}
\alias{guardduty_get_ip_set}
\title{Retrieves the IPSet specified by the ipSetId}
\usage{
guardduty_get_ip_set(DetectorId, IpSetId)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector that the IPSet is associated with.}

\item{IpSetId}{[required] The unique ID of the IPSet to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Name = "string",
  Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
  Location = "string",
  Status = "INACTIVE"|"ACTIVATING"|"ACTIVE"|"DEACTIVATING"|"ERROR"|"DELETE_PENDING"|"DELETED",
  Tags = list(
    "string"
  )
)
}
}
\description{
Retrieves the IPSet specified by the \code{ipSetId}.
}
\section{Request syntax}{
\preformatted{svc$get_ip_set(
  DetectorId = "string",
  IpSetId = "string"
)
}
}

\keyword{internal}
