% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_reset_service_specific_credential}
\alias{iam_reset_service_specific_credential}
\title{Resets the password for a service-specific credential}
\usage{
iam_reset_service_specific_credential(UserName,
  ServiceSpecificCredentialId)
}
\arguments{
\item{UserName}{The name of the IAM user associated with the service-specific
credential. If this value is not specified, then the operation assumes
the user whose credentials are used to call the operation.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{ServiceSpecificCredentialId}{[required] The unique identifier of the service-specific credential.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that can consist of any upper or lowercased letter or digit.}
}
\value{
A list with the following syntax:\preformatted{list(
  ServiceSpecificCredential = list(
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    ServiceName = "string",
    ServiceUserName = "string",
    ServicePassword = "string",
    ServiceSpecificCredentialId = "string",
    UserName = "string",
    Status = "Active"|"Inactive"
  )
)
}
}
\description{
Resets the password for a service-specific credential. The new password
is AWS generated and cryptographically strong. It cannot be configured
by the user. Resetting the password immediately invalidates the previous
password associated with this user.
}
\section{Request syntax}{
\preformatted{svc$reset_service_specific_credential(
  UserName = "string",
  ServiceSpecificCredentialId = "string"
)
}
}

\keyword{internal}
