% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_list_tags_for_resource}
\alias{inspector_list_tags_for_resource}
\title{Lists all tags associated with an assessment template}
\usage{
inspector_list_tags_for_resource(resourceArn)
}
\arguments{
\item{resourceArn}{[required] The ARN that specifies the assessment template whose tags you want to
list.}
}
\value{
A list with the following syntax:\preformatted{list(
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}
\description{
Lists all tags associated with an assessment template.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  resourceArn = "string"
)
}
}

\examples{
\dontrun{
# Lists all tags associated with an assessment template.
svc$list_tags_for_resource(
  resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq..."
)
}

}
\keyword{internal}
