% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_describe_standards}
\alias{securityhub_describe_standards}
\title{Returns a list of the available standards in Security Hub}
\usage{
securityhub_describe_standards(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{The token that is required for pagination. On your first call to the
\code{\link[=securityhub_describe_standards]{describe_standards}} operation, set
the value of this parameter to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}

\item{MaxResults}{The maximum number of standards to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Standards = list(
    list(
      StandardsArn = "string",
      Name = "string",
      Description = "string",
      EnabledByDefault = TRUE|FALSE
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of the available standards in Security Hub.

For each standard, the results include the standard ARN, the name, and a
description.
}
\section{Request syntax}{
\preformatted{svc$describe_standards(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
