% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_update_object_attributes}
\alias{clouddirectory_update_object_attributes}
\title{Updates a given object's attributes}
\usage{
clouddirectory_update_object_attributes(DirectoryArn, ObjectReference,
  AttributeUpdates)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the object resides. For more information, see arns.}

\item{ObjectReference}{[required] The reference that identifies the object.}

\item{AttributeUpdates}{[required] The attributes update structure.}
}
\description{
Updates a given object's attributes.
}
\section{Request syntax}{
\preformatted{svc$update_object_attributes(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  AttributeUpdates = list(
    list(
      ObjectAttributeKey = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      ObjectAttributeAction = list(
        ObjectAttributeActionType = "CREATE_OR_UPDATE"|"DELETE",
        ObjectAttributeUpdateValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
