% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_open_id_connect_provider}
\alias{iam_delete_open_id_connect_provider}
\title{Deletes an OpenID Connect identity provider (IdP) resource object in IAM}
\usage{
iam_delete_open_id_connect_provider(OpenIDConnectProviderArn)
}
\arguments{
\item{OpenIDConnectProviderArn}{[required] The Amazon Resource Name (ARN) of the IAM OpenID Connect provider
resource object to delete. You can get a list of OpenID Connect provider
resource ARNs by using the ListOpenIDConnectProviders operation.}
}
\description{
Deletes an OpenID Connect identity provider (IdP) resource object in
IAM.
}
\details{
Deleting an IAM OIDC provider resource does not update any roles that
reference the provider as a principal in their trust policies. Any
attempt to assume a role that references a deleted provider fails.

This operation is idempotent; it does not fail or return an error if you
call the operation for a provider that does not exist.
}
\section{Request syntax}{
\preformatted{svc$delete_open_id_connect_provider(
  OpenIDConnectProviderArn = "string"
)
}
}

\keyword{internal}
