% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_describe_key}
\alias{kms_describe_key}
\title{Provides detailed information about the specified customer master key
(CMK)}
\usage{
kms_describe_key(KeyId, GrantTokens)
}
\arguments{
\item{KeyId}{[required] Describes the specified customer master key (CMK).

If you specify a predefined AWS alias (an AWS alias with no key ID), KMS
associates the alias with an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys}{AWS managed CMK}
and returns its \code{KeyId} and \code{Arn} in the response.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Provides detailed information about the specified customer master key
(CMK).
}
\details{
You can use \code{DescribeKey} on a predefined AWS alias, that is, an AWS
alias with no key ID. When you do, AWS KMS associates the alias with an
\href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys}{AWS managed CMK}
and returns its \code{KeyId} and \code{Arn} in the response.

To perform this operation on a CMK in a different AWS account, specify
the key ARN or alias ARN in the value of the KeyId parameter.
}
\section{Request syntax}{
\preformatted{svc$describe_key(
  KeyId = "string",
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example returns information (metadata) about the specified
# CMK.
\donttest{svc$describe_key(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
