% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_key_policy}
\alias{kms_get_key_policy}
\title{Gets a key policy attached to the specified customer master key (CMK)}
\usage{
kms_get_key_policy(KeyId, PolicyName)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{PolicyName}{[required] Specifies the name of the key policy. The only valid name is \code{default}.
To get the names of key policies, use ListKeyPolicies.}
}
\description{
Gets a key policy attached to the specified customer master key (CMK).
You cannot perform this operation on a CMK in a different AWS account.
}
\section{Request syntax}{
\preformatted{svc$get_key_policy(
  KeyId = "string",
  PolicyName = "string"
)
}
}

\examples{
# The following example retrieves the key policy for the specified
# customer master key (CMK).
\donttest{svc$get_key_policy(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  PolicyName = "default"
)}

}
\keyword{internal}
