% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_create_secret}
\alias{secretsmanager_create_secret}
\title{Creates a new secret}
\usage{
secretsmanager_create_secret(Name, ClientRequestToken, Description,
  KmsKeyId, SecretBinary, SecretString, Tags)
}
\arguments{
\item{Name}{[required] Specifies the friendly name of the new secret.

The secret name must be ASCII letters, digits, or the following
characters : /\\_+=.@-

Do not end your secret name with a hyphen followed by six characters. If
you do so, you risk confusion and unexpected results when searching for
a secret by partial ARN. Secrets Manager automatically adds a hyphen and
six random characters at the end of the ARN.}

\item{ClientRequestToken}{(Optional) If you include \code{SecretString} or \code{SecretBinary}, then an
initial version is created as part of the secret, and this parameter
specifies a unique identifier for the new version.

If you use the AWS CLI or one of the AWS SDK to call this operation,
then you can leave this parameter empty. The CLI or SDK generates a
random UUID for you and includes it as the value for this parameter in
the request. If you don\'t use the SDK and instead generate a raw HTTP
request to the Secrets Manager service endpoint, then you must generate
a \code{ClientRequestToken} yourself for the new version and include the
value in the request.

This value helps ensure idempotency. Secrets Manager uses this value to
prevent the accidental creation of duplicate versions if there are
failures and retries during a rotation. We recommend that you generate a
\href{https://wikipedia.org/wiki/Universally_unique_identifier}{UUID-type}
value to ensure uniqueness of your versions within the specified secret.
\itemize{
\item If the \code{ClientRequestToken} value isn\'t already associated with a
version of the secret then a new version of the secret is created.
\item If a version with this value already exists and the version
\code{SecretString} and \code{SecretBinary} values are the same as those in
the request, then the request is ignored.
\item If a version with this value already exists and that version\'s
\code{SecretString} and \code{SecretBinary} values are different from those in
the request then the request fails because you cannot modify an
existing version. Instead, use PutSecretValue to create a new
version.
}

This value becomes the \code{VersionId} of the new version.}

\item{Description}{(Optional) Specifies a user-provided description of the secret.}

\item{KmsKeyId}{(Optional) Specifies the ARN, Key ID, or alias of the AWS KMS customer
master key (CMK) to be used to encrypt the \code{SecretString} or
\code{SecretBinary} values in the versions stored in this secret.

You can specify any of the supported ways to identify a AWS KMS key ID.
If you need to reference a CMK in a different account, you can use only
the key ARN or the alias ARN.

If you don\'t specify this value, then Secrets Manager defaults to using
the AWS account\'s default CMK (the one named \code{aws/secretsmanager}). If
a AWS KMS CMK with that name doesn\'t yet exist, then Secrets Manager
creates it for you automatically the first time it needs to encrypt a
version\'s \code{SecretString} or \code{SecretBinary} fields.

You can use the account default CMK to encrypt and decrypt only if you
call this operation using credentials from the same account that owns
the secret. If the secret resides in a different account, then you must
create a custom CMK and specify the ARN in this field.}

\item{SecretBinary}{(Optional) Specifies binary data that you want to encrypt and store in
the new version of the secret. To use this parameter in the command-line
tools, we recommend that you store your binary data in a file and then
use the appropriate technique for your tool to pass the contents of the
file as a parameter.

Either \code{SecretString} or \code{SecretBinary} must have a value, but not both.
They cannot both be empty.

This parameter is not available using the Secrets Manager console. It
can be accessed only by using the AWS CLI or one of the AWS SDKs.}

\item{SecretString}{(Optional) Specifies text data that you want to encrypt and store in
this new version of the secret.

Either \code{SecretString} or \code{SecretBinary} must have a value, but not both.
They cannot both be empty.

If you create a secret by using the Secrets Manager console then Secrets
Manager puts the protected secret text in only the \code{SecretString}
parameter. The Secrets Manager console stores the information as a JSON
structure of key/value pairs that the Lambda rotation function knows how
to parse.

For storing multiple values, we recommend that you use a JSON text
string argument and specify key/value pairs. For information on how to
format a JSON parameter for the various command line tool environments,
see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json}{Using JSON for Parameters}
in the \emph{AWS CLI User Guide}. For example:

\verb{\\\{"username":"bob","password":"abc123xyz456"\\\}}

If your command-line tool or SDK requires quotation marks around the
parameter, you should use single quotes to avoid confusion with the
double quotes required in the JSON text.}

\item{Tags}{(Optional) Specifies a list of user-defined tags that are attached to
the secret. Each tag is a \"Key\" and \"Value\" pair of strings. This
operation only appends tags to the existing list of tags. To remove
tags, you must use UntagResource.
\itemize{
\item Secrets Manager tag key names are case sensitive. A tag with the key
\"ABC\" is a different tag from one with key \"abc\".
\item If you check tags in IAM policy \code{Condition} elements as part of your
security strategy, then adding or removing a tag can change
permissions. If the successful completion of this operation would
result in you losing your permissions for this secret, then this
operation is blocked and returns an \verb{Access Denied} error.
}

This parameter requires a JSON text string argument. For information on
how to format a JSON parameter for the various command line tool
environments, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json}{Using JSON for Parameters}
in the \emph{AWS CLI User Guide}. For example:

\verb{\\\[\\\{"Key":"CostCenter","Value":"12345"\\\},\\\{"Key":"environment","Value":"production"\\\}\\\]}

If your command-line tool or SDK requires quotation marks around the
parameter, you should use single quotes to avoid confusion with the
double quotes required in the JSON text.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per secret---50
\item Maximum key length---127 Unicode characters in UTF-8
\item Maximum value length---255 Unicode characters in UTF-8
\item Tag keys and values are case sensitive.
\item Do not use the \verb{aws:} prefix in your tag names or values because AWS
reserves it for AWS use. You can\'t edit or delete tag names or
values with this prefix. Tags with this prefix do not count against
your tags per secret limit.
\item If you use your tagging schema across multiple services and
resources, remember other services might have restrictions on
allowed characters. Generally allowed characters: letters, spaces,
and numbers representable in UTF-8, plus the following special
characters: + - = . \\_ : / @.
}}
}
\description{
Creates a new secret. A secret in Secrets Manager consists of both the
protected secret data and the important information needed to manage the
secret.
}
\details{
Secrets Manager stores the encrypted secret data in one of a collection
of \"versions\" associated with the secret. Each version contains a copy
of the encrypted secret data. Each version is associated with one or
more \"staging labels\" that identify where the version is in the
rotation cycle. The \code{SecretVersionsToStages} field of the secret
contains the mapping of staging labels to the active versions of the
secret. Versions without a staging label are considered deprecated and
not included in the list.

You provide the secret data to be encrypted by putting text in either
the \code{SecretString} parameter or binary data in the \code{SecretBinary}
parameter, but not both. If you include \code{SecretString} or \code{SecretBinary}
then Secrets Manager also creates an initial secret version and
automatically attaches the staging label \code{AWSCURRENT} to the new
version.
\itemize{
\item If you call an operation to encrypt or decrypt the \code{SecretString} or
\code{SecretBinary} for a secret in the same account as the calling user
and that secret doesn\'t specify a AWS KMS encryption key, Secrets
Manager uses the account\'s default AWS managed customer master key
(CMK) with the alias \code{aws/secretsmanager}. If this key doesn\'t
already exist in your account then Secrets Manager creates it for
you automatically. All users and roles in the same AWS account
automatically have access to use the default CMK. Note that if an
Secrets Manager API call results in AWS creating the account\'s
AWS-managed CMK, it can result in a one-time significant delay in
returning the result.
\item If the secret resides in a different AWS account from the
credentials calling an API that requires encryption or decryption of
the secret value then you must create and use a custom AWS KMS CMK
because you can\'t access the default CMK for the account using
credentials from a different AWS account. Store the ARN of the CMK
in the secret when you create the secret or when you update it by
including it in the \code{KMSKeyId}. If you call an API that must encrypt
or decrypt \code{SecretString} or \code{SecretBinary} using credentials from a
different account then the AWS KMS key policy must grant
cross-account access to that other account\'s user or role for both
the kms:GenerateDataKey and kms:Decrypt operations.
}

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:CreateSecret
\item kms:GenerateDataKey - needed only if you use a customer-managed AWS
KMS key to encrypt the secret. You do not need this permission to
use the account default AWS managed CMK for Secrets Manager.
\item kms:Decrypt - needed only if you use a customer-managed AWS KMS key
to encrypt the secret. You do not need this permission to use the
account default AWS managed CMK for Secrets Manager.
\item secretsmanager:TagResource - needed only if you include the \code{Tags}
parameter.
}

\strong{Related operations}
\itemize{
\item To delete a secret, use DeleteSecret.
\item To modify an existing secret, use UpdateSecret.
\item To create a new version of a secret, use PutSecretValue.
\item To retrieve the encrypted secure string and secure binary values,
use GetSecretValue.
\item To retrieve all other details for a secret, use DescribeSecret. This
does not include the encrypted secure string and secure binary
values.
\item To retrieve the list of secret versions associated with the current
secret, use DescribeSecret and examine the \code{SecretVersionsToStages}
response value.
}
}
\section{Request syntax}{
\preformatted{svc$create_secret(
  Name = "string",
  ClientRequestToken = "string",
  Description = "string",
  KmsKeyId = "string",
  SecretBinary = raw,
  SecretString = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following example shows how to create a secret. The credentials
# stored in the encrypted secret value are retrieved from a file on disk
# named mycreds.json.
svc$create_secret(
  ClientRequestToken = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
  Description = "My test database secret created with the CLI",
  Name = "MyTestDatabaseSecret",
  SecretString = "\{\"username\":\"david\",\"password\":\"BnQw!XDWgaEeT9XGTT29\"\}"
)
}

}
\keyword{internal}
