% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_list_resources_for_web_acl}
\alias{wafregional_list_resources_for_web_acl}
\title{This is AWS WAF CLASSIC REGIONAL documentation}
\usage{
wafregional_list_resources_for_web_acl(WebACLId, ResourceType)
}
\arguments{
\item{WebACLId}{[required] The unique identifier (ID) of the web ACL for which to list the
associated resources.}

\item{ResourceType}{The type of resource to list, either an application load balancer or
Amazon API Gateway.}
}
\description{
This is \strong{AWS WAF Classic Regional} documentation. For more
information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns an array of resources associated with the specified web ACL.
}
\section{Request syntax}{
\preformatted{svc$list_resources_for_web_acl(
  WebACLId = "string",
  ResourceType = "APPLICATION_LOAD_BALANCER"|"API_GATEWAY"
)
}
}

\keyword{internal}
