% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_import_certificate}
\alias{acm_import_certificate}
\title{Imports a certificate into Amazon Web Services Certificate Manager (ACM)
to use with services that are integrated with ACM}
\usage{
acm_import_certificate(
  CertificateArn = NULL,
  Certificate,
  PrivateKey,
  CertificateChain = NULL,
  Tags = NULL
)
}
\arguments{
\item{CertificateArn}{The \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name (ARN)}
of an imported certificate to replace. To import a new certificate, omit
this field.}

\item{Certificate}{[required] The certificate to import.}

\item{PrivateKey}{[required] The private key that matches the public key in the certificate.}

\item{CertificateChain}{The PEM encoded certificate chain.}

\item{Tags}{One or more resource tags to associate with the imported certificate.

Note: You cannot apply tags when reimporting a certificate.}
}
\description{
Imports a certificate into Amazon Web Services Certificate Manager (ACM) to use with services that are integrated with ACM. Note that \href{https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html}{integrated services} allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see \href{https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html}{Importing Certificates} in the \emph{Amazon Web Services Certificate Manager User Guide}.

See \url{https://paws-r.github.io/docs/acm/import_certificate.html} for full documentation.
}
\keyword{internal}
