% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_access_key}
\alias{iam_delete_access_key}
\title{Deletes the access key pair associated with the specified IAM user}
\usage{
iam_delete_access_key(UserName = NULL, AccessKeyId)
}
\arguments{
\item{UserName}{The name of the user whose access key pair you want to delete.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{AccessKeyId}{[required] The access key ID for the access key ID and secret access key you want
to delete.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that can consist of any upper or lowercased letter or digit.}
}
\description{
Deletes the access key pair associated with the specified IAM user.

See \url{https://paws-r.github.io/docs/iam/delete_access_key.html} for full documentation.
}
\keyword{internal}
