% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_schedule_key_deletion}
\alias{kms_schedule_key_deletion}
\title{Schedules the deletion of a KMS key}
\usage{
kms_schedule_key_deletion(KeyId, PendingWindowInDays = NULL)
}
\arguments{
\item{KeyId}{[required] The unique identifier of the KMS key to delete.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{PendingWindowInDays}{The waiting period, specified in number of days. After the waiting
period ends, KMS deletes the KMS key.

If the KMS key is a multi-Region primary key with replica keys, the
waiting period begins when the last of its replica keys is deleted.
Otherwise, the waiting period begins immediately.

This value is optional. If you include a value, it must be between 7 and
30, inclusive. If you do not include a value, it defaults to 30.}
}
\description{
Schedules the deletion of a KMS key. By default, KMS applies a waiting period of 30 days, but you can specify a waiting period of 7-30 days. When this operation is successful, the key state of the KMS key changes to \code{PendingDeletion} and the key can't be used in any cryptographic operations. It remains in this state for the duration of the waiting period. Before the waiting period ends, you can use \code{\link[=kms_cancel_key_deletion]{cancel_key_deletion}} to cancel the deletion of the KMS key. After the waiting period ends, KMS deletes the KMS key, its key material, and all KMS data associated with it, including all aliases that refer to it.

See \url{https://paws-r.github.io/docs/kms/schedule_key_deletion.html} for full documentation.
}
\keyword{internal}
