# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pcaconnectorad_service.R
NULL

#' Creates a connector between Amazon Web Services Private CA and an Active
#' Directory
#'
#' @description
#' Creates a connector between Amazon Web Services Private CA and an Active Directory. You must specify the private CA, directory ID, and security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_create_connector/](https://www.paws-r-sdk.com/docs/pcaconnectorad_create_connector/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the certificate authority being used.
#' @param ClientToken Idempotency token.
#' @param DirectoryId &#91;required&#93; The identifier of the Active Directory.
#' @param Tags Metadata assigned to a connector consisting of a key-value pair.
#' @param VpcInformation &#91;required&#93; Security group IDs that describe the inbound and outbound rules.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_create_connector
pcaconnectorad_create_connector <- function(CertificateAuthorityArn, ClientToken = NULL, DirectoryId, Tags = NULL, VpcInformation) {
  op <- new_operation(
    name = "CreateConnector",
    http_method = "POST",
    http_path = "/connectors",
    paginator = list()
  )
  input <- .pcaconnectorad$create_connector_input(CertificateAuthorityArn = CertificateAuthorityArn, ClientToken = ClientToken, DirectoryId = DirectoryId, Tags = Tags, VpcInformation = VpcInformation)
  output <- .pcaconnectorad$create_connector_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$create_connector <- pcaconnectorad_create_connector

#' Creates a directory registration that authorizes communication between
#' Amazon Web Services Private CA and an Active Directory
#'
#' @description
#' Creates a directory registration that authorizes communication between Amazon Web Services Private CA and an Active Directory
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_create_directory_registration/](https://www.paws-r-sdk.com/docs/pcaconnectorad_create_directory_registration/) for full documentation.
#'
#' @param ClientToken Idempotency token.
#' @param DirectoryId &#91;required&#93; The identifier of the Active Directory.
#' @param Tags Metadata assigned to a directory registration consisting of a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_create_directory_registration
pcaconnectorad_create_directory_registration <- function(ClientToken = NULL, DirectoryId, Tags = NULL) {
  op <- new_operation(
    name = "CreateDirectoryRegistration",
    http_method = "POST",
    http_path = "/directoryRegistrations",
    paginator = list()
  )
  input <- .pcaconnectorad$create_directory_registration_input(ClientToken = ClientToken, DirectoryId = DirectoryId, Tags = Tags)
  output <- .pcaconnectorad$create_directory_registration_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$create_directory_registration <- pcaconnectorad_create_directory_registration

#' Creates a service principal name (SPN) for the service account in Active
#' Directory
#'
#' @description
#' Creates a service principal name (SPN) for the service account in Active Directory. Kerberos authentication uses SPNs to associate a service instance with a service sign-in account.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_create_service_principal_name/](https://www.paws-r-sdk.com/docs/pcaconnectorad_create_service_principal_name/) for full documentation.
#'
#' @param ClientToken Idempotency token.
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_create_service_principal_name
pcaconnectorad_create_service_principal_name <- function(ClientToken = NULL, ConnectorArn, DirectoryRegistrationArn) {
  op <- new_operation(
    name = "CreateServicePrincipalName",
    http_method = "POST",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$create_service_principal_name_input(ClientToken = ClientToken, ConnectorArn = ConnectorArn, DirectoryRegistrationArn = DirectoryRegistrationArn)
  output <- .pcaconnectorad$create_service_principal_name_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$create_service_principal_name <- pcaconnectorad_create_service_principal_name

#' Creates an Active Directory compatible certificate template
#'
#' @description
#' Creates an Active Directory compatible certificate template. The connectors issues certificates using these templates based on the requester’s Active Directory group membership.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template/](https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template/) for full documentation.
#'
#' @param ClientToken Idempotency token.
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#' @param Definition &#91;required&#93; Template configuration to define the information included in
#' certificates. Define certificate validity and renewal periods,
#' certificate request handling and enrollment options, key usage
#' extensions, application policies, and cryptography settings.
#' @param Name &#91;required&#93; Name of the template. The template name must be unique.
#' @param Tags Metadata assigned to a template consisting of a key-value pair.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_create_template
pcaconnectorad_create_template <- function(ClientToken = NULL, ConnectorArn, Definition, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateTemplate",
    http_method = "POST",
    http_path = "/templates",
    paginator = list()
  )
  input <- .pcaconnectorad$create_template_input(ClientToken = ClientToken, ConnectorArn = ConnectorArn, Definition = Definition, Name = Name, Tags = Tags)
  output <- .pcaconnectorad$create_template_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$create_template <- pcaconnectorad_create_template

#' Create a group access control entry
#'
#' @description
#' Create a group access control entry. Allow or deny Active Directory groups from enrolling and/or autoenrolling with the template based on the group security identifiers (SIDs).
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template_group_access_control_entry/](https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template_group_access_control_entry/) for full documentation.
#'
#' @param AccessRights &#91;required&#93; Allow or deny permissions for an Active Directory group to enroll or
#' autoenroll certificates for a template.
#' @param ClientToken Idempotency token.
#' @param GroupDisplayName &#91;required&#93; Name of the Active Directory group. This name does not need to match the
#' group name in Active Directory.
#' @param GroupSecurityIdentifier &#91;required&#93; Security identifier (SID) of the group object from Active Directory. The
#' SID starts with "S-".
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_create_template_group_access_control_entry
pcaconnectorad_create_template_group_access_control_entry <- function(AccessRights, ClientToken = NULL, GroupDisplayName, GroupSecurityIdentifier, TemplateArn) {
  op <- new_operation(
    name = "CreateTemplateGroupAccessControlEntry",
    http_method = "POST",
    http_path = "/templates/{TemplateArn}/accessControlEntries",
    paginator = list()
  )
  input <- .pcaconnectorad$create_template_group_access_control_entry_input(AccessRights = AccessRights, ClientToken = ClientToken, GroupDisplayName = GroupDisplayName, GroupSecurityIdentifier = GroupSecurityIdentifier, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$create_template_group_access_control_entry_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$create_template_group_access_control_entry <- pcaconnectorad_create_template_group_access_control_entry

#' Deletes a connector for Active Directory
#'
#' @description
#' Deletes a connector for Active Directory. You must provide the Amazon Resource Name (ARN) of the connector that you want to delete. You can find the ARN by calling the [https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors.html) action. Deleting a connector does not deregister your directory with Amazon Web Services Private CA. You can deregister your directory by calling the [https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration.html) action.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_connector/](https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_connector/) for full documentation.
#'
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_delete_connector
pcaconnectorad_delete_connector <- function(ConnectorArn) {
  op <- new_operation(
    name = "DeleteConnector",
    http_method = "DELETE",
    http_path = "/connectors/{ConnectorArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$delete_connector_input(ConnectorArn = ConnectorArn)
  output <- .pcaconnectorad$delete_connector_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$delete_connector <- pcaconnectorad_delete_connector

#' Deletes a directory registration
#'
#' @description
#' Deletes a directory registration. Deleting a directory registration deauthorizes Amazon Web Services Private CA with the directory.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_directory_registration/](https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_directory_registration/) for full documentation.
#'
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_delete_directory_registration
pcaconnectorad_delete_directory_registration <- function(DirectoryRegistrationArn) {
  op <- new_operation(
    name = "DeleteDirectoryRegistration",
    http_method = "DELETE",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$delete_directory_registration_input(DirectoryRegistrationArn = DirectoryRegistrationArn)
  output <- .pcaconnectorad$delete_directory_registration_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$delete_directory_registration <- pcaconnectorad_delete_directory_registration

#' Deletes the service principal name (SPN) used by a connector to
#' authenticate with your Active Directory
#'
#' @description
#' Deletes the service principal name (SPN) used by a connector to authenticate with your Active Directory.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_service_principal_name/](https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_service_principal_name/) for full documentation.
#'
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_delete_service_principal_name
pcaconnectorad_delete_service_principal_name <- function(ConnectorArn, DirectoryRegistrationArn) {
  op <- new_operation(
    name = "DeleteServicePrincipalName",
    http_method = "DELETE",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$delete_service_principal_name_input(ConnectorArn = ConnectorArn, DirectoryRegistrationArn = DirectoryRegistrationArn)
  output <- .pcaconnectorad$delete_service_principal_name_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$delete_service_principal_name <- pcaconnectorad_delete_service_principal_name

#' Deletes a template
#'
#' @description
#' Deletes a template. Certificates issued using the template are still valid until they are revoked or expired.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_template/](https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_template/) for full documentation.
#'
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_delete_template
pcaconnectorad_delete_template <- function(TemplateArn) {
  op <- new_operation(
    name = "DeleteTemplate",
    http_method = "DELETE",
    http_path = "/templates/{TemplateArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$delete_template_input(TemplateArn = TemplateArn)
  output <- .pcaconnectorad$delete_template_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$delete_template <- pcaconnectorad_delete_template

#' Deletes a group access control entry
#'
#' @description
#' Deletes a group access control entry.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_template_group_access_control_entry/](https://www.paws-r-sdk.com/docs/pcaconnectorad_delete_template_group_access_control_entry/) for full documentation.
#'
#' @param GroupSecurityIdentifier &#91;required&#93; Security identifier (SID) of the group object from Active Directory. The
#' SID starts with "S-".
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_delete_template_group_access_control_entry
pcaconnectorad_delete_template_group_access_control_entry <- function(GroupSecurityIdentifier, TemplateArn) {
  op <- new_operation(
    name = "DeleteTemplateGroupAccessControlEntry",
    http_method = "DELETE",
    http_path = "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
    paginator = list()
  )
  input <- .pcaconnectorad$delete_template_group_access_control_entry_input(GroupSecurityIdentifier = GroupSecurityIdentifier, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$delete_template_group_access_control_entry_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$delete_template_group_access_control_entry <- pcaconnectorad_delete_template_group_access_control_entry

#' Lists information about your connector
#'
#' @description
#' Lists information about your connector. You specify the connector on input by its ARN (Amazon Resource Name).
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_get_connector/](https://www.paws-r-sdk.com/docs/pcaconnectorad_get_connector/) for full documentation.
#'
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_get_connector
pcaconnectorad_get_connector <- function(ConnectorArn) {
  op <- new_operation(
    name = "GetConnector",
    http_method = "GET",
    http_path = "/connectors/{ConnectorArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$get_connector_input(ConnectorArn = ConnectorArn)
  output <- .pcaconnectorad$get_connector_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$get_connector <- pcaconnectorad_get_connector

#' A structure that contains information about your directory registration
#'
#' @description
#' A structure that contains information about your directory registration.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_get_directory_registration/](https://www.paws-r-sdk.com/docs/pcaconnectorad_get_directory_registration/) for full documentation.
#'
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_get_directory_registration
pcaconnectorad_get_directory_registration <- function(DirectoryRegistrationArn) {
  op <- new_operation(
    name = "GetDirectoryRegistration",
    http_method = "GET",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$get_directory_registration_input(DirectoryRegistrationArn = DirectoryRegistrationArn)
  output <- .pcaconnectorad$get_directory_registration_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$get_directory_registration <- pcaconnectorad_get_directory_registration

#' Lists the service principal name that the connector uses to authenticate
#' with Active Directory
#'
#' @description
#' Lists the service principal name that the connector uses to authenticate with Active Directory.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_get_service_principal_name/](https://www.paws-r-sdk.com/docs/pcaconnectorad_get_service_principal_name/) for full documentation.
#'
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_get_service_principal_name
pcaconnectorad_get_service_principal_name <- function(ConnectorArn, DirectoryRegistrationArn) {
  op <- new_operation(
    name = "GetServicePrincipalName",
    http_method = "GET",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$get_service_principal_name_input(ConnectorArn = ConnectorArn, DirectoryRegistrationArn = DirectoryRegistrationArn)
  output <- .pcaconnectorad$get_service_principal_name_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$get_service_principal_name <- pcaconnectorad_get_service_principal_name

#' Retrieves a certificate template that the connector uses to issue
#' certificates from a private CA
#'
#' @description
#' Retrieves a certificate template that the connector uses to issue certificates from a private CA.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_get_template/](https://www.paws-r-sdk.com/docs/pcaconnectorad_get_template/) for full documentation.
#'
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_get_template
pcaconnectorad_get_template <- function(TemplateArn) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "GET",
    http_path = "/templates/{TemplateArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$get_template_input(TemplateArn = TemplateArn)
  output <- .pcaconnectorad$get_template_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$get_template <- pcaconnectorad_get_template

#' Retrieves the group access control entries for a template
#'
#' @description
#' Retrieves the group access control entries for a template.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_get_template_group_access_control_entry/](https://www.paws-r-sdk.com/docs/pcaconnectorad_get_template_group_access_control_entry/) for full documentation.
#'
#' @param GroupSecurityIdentifier &#91;required&#93; Security identifier (SID) of the group object from Active Directory. The
#' SID starts with "S-".
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_get_template_group_access_control_entry
pcaconnectorad_get_template_group_access_control_entry <- function(GroupSecurityIdentifier, TemplateArn) {
  op <- new_operation(
    name = "GetTemplateGroupAccessControlEntry",
    http_method = "GET",
    http_path = "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
    paginator = list()
  )
  input <- .pcaconnectorad$get_template_group_access_control_entry_input(GroupSecurityIdentifier = GroupSecurityIdentifier, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$get_template_group_access_control_entry_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$get_template_group_access_control_entry <- pcaconnectorad_get_template_group_access_control_entry

#' Lists the connectors that you created by using the https://docs
#'
#' @description
#' Lists the connectors that you created by using the [https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) action.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_connectors/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_connectors/) for full documentation.
#'
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_connectors
pcaconnectorad_list_connectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConnectors",
    http_method = "GET",
    http_path = "/connectors",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Connectors")
  )
  input <- .pcaconnectorad$list_connectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .pcaconnectorad$list_connectors_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_connectors <- pcaconnectorad_list_connectors

#' Lists the directory registrations that you created by using the
#' https://docs
#'
#' @description
#' Lists the directory registrations that you created by using the [https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html) action.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_directory_registrations/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_directory_registrations/) for full documentation.
#'
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_directory_registrations
pcaconnectorad_list_directory_registrations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDirectoryRegistrations",
    http_method = "GET",
    http_path = "/directoryRegistrations",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DirectoryRegistrations")
  )
  input <- .pcaconnectorad$list_directory_registrations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .pcaconnectorad$list_directory_registrations_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_directory_registrations <- pcaconnectorad_list_directory_registrations

#' Lists the service principal names that the connector uses to
#' authenticate with Active Directory
#'
#' @description
#' Lists the service principal names that the connector uses to authenticate with Active Directory.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_service_principal_names/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_service_principal_names/) for full documentation.
#'
#' @param DirectoryRegistrationArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_directory_registration`][pcaconnectorad_create_directory_registration].
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_service_principal_names
pcaconnectorad_list_service_principal_names <- function(DirectoryRegistrationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServicePrincipalNames",
    http_method = "GET",
    http_path = "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ServicePrincipalNames")
  )
  input <- .pcaconnectorad$list_service_principal_names_input(DirectoryRegistrationArn = DirectoryRegistrationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .pcaconnectorad$list_service_principal_names_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_service_principal_names <- pcaconnectorad_list_service_principal_names

#' Lists the tags, if any, that are associated with your resource
#'
#' @description
#' Lists the tags, if any, that are associated with your resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you created the
#' resource.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_tags_for_resource
pcaconnectorad_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pcaconnectorad$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_tags_for_resource <- pcaconnectorad_list_tags_for_resource

#' Lists group access control entries you created
#'
#' @description
#' Lists group access control entries you created.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_template_group_access_control_entries/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_template_group_access_control_entries/) for full documentation.
#'
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_template_group_access_control_entries
pcaconnectorad_list_template_group_access_control_entries <- function(MaxResults = NULL, NextToken = NULL, TemplateArn) {
  op <- new_operation(
    name = "ListTemplateGroupAccessControlEntries",
    http_method = "GET",
    http_path = "/templates/{TemplateArn}/accessControlEntries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AccessControlEntries")
  )
  input <- .pcaconnectorad$list_template_group_access_control_entries_input(MaxResults = MaxResults, NextToken = NextToken, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$list_template_group_access_control_entries_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_template_group_access_control_entries <- pcaconnectorad_list_template_group_access_control_entries

#' Lists the templates, if any, that are associated with a connector
#'
#' @description
#' Lists the templates, if any, that are associated with a connector.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_list_templates/](https://www.paws-r-sdk.com/docs/pcaconnectorad_list_templates/) for full documentation.
#'
#' @param ConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_connector`][pcaconnectorad_create_connector].
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_list_templates
pcaconnectorad_list_templates <- function(ConnectorArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "GET",
    http_path = "/templates",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Templates")
  )
  input <- .pcaconnectorad$list_templates_input(ConnectorArn = ConnectorArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .pcaconnectorad$list_templates_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$list_templates <- pcaconnectorad_list_templates

#' Adds one or more tags to your resource
#'
#' @description
#' Adds one or more tags to your resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_tag_resource/](https://www.paws-r-sdk.com/docs/pcaconnectorad_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you created the
#' resource.
#' @param Tags &#91;required&#93; Metadata assigned to a directory registration consisting of a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_tag_resource
pcaconnectorad_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .pcaconnectorad$tag_resource_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$tag_resource <- pcaconnectorad_tag_resource

#' Removes one or more tags from your resource
#'
#' @description
#' Removes one or more tags from your resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_untag_resource/](https://www.paws-r-sdk.com/docs/pcaconnectorad_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you created the
#' resource.
#' @param TagKeys &#91;required&#93; Specifies a list of tag keys that you want to remove from the specified
#' resources.
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_untag_resource
pcaconnectorad_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pcaconnectorad$untag_resource_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$untag_resource <- pcaconnectorad_untag_resource

#' Update template configuration to define the information included in
#' certificates
#'
#' @description
#' Update template configuration to define the information included in certificates.
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_update_template/](https://www.paws-r-sdk.com/docs/pcaconnectorad_update_template/) for full documentation.
#'
#' @param Definition Template configuration to define the information included in
#' certificates. Define certificate validity and renewal periods,
#' certificate request handling and enrollment options, key usage
#' extensions, application policies, and cryptography settings.
#' @param ReenrollAllCertificateHolders This setting allows the major version of a template to be increased
#' automatically. All members of Active Directory groups that are allowed
#' to enroll with a template will receive a new certificate issued using
#' that template.
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_update_template
pcaconnectorad_update_template <- function(Definition = NULL, ReenrollAllCertificateHolders = NULL, TemplateArn) {
  op <- new_operation(
    name = "UpdateTemplate",
    http_method = "PATCH",
    http_path = "/templates/{TemplateArn}",
    paginator = list()
  )
  input <- .pcaconnectorad$update_template_input(Definition = Definition, ReenrollAllCertificateHolders = ReenrollAllCertificateHolders, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$update_template_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$update_template <- pcaconnectorad_update_template

#' Update a group access control entry you created using
#' CreateTemplateGroupAccessControlEntry
#'
#' @description
#' Update a group access control entry you created using [`create_template_group_access_control_entry`][pcaconnectorad_create_template_group_access_control_entry].
#'
#' See [https://www.paws-r-sdk.com/docs/pcaconnectorad_update_template_group_access_control_entry/](https://www.paws-r-sdk.com/docs/pcaconnectorad_update_template_group_access_control_entry/) for full documentation.
#'
#' @param AccessRights Allow or deny permissions for an Active Directory group to enroll or
#' autoenroll certificates for a template.
#' @param GroupDisplayName Name of the Active Directory group. This name does not need to match the
#' group name in Active Directory.
#' @param GroupSecurityIdentifier &#91;required&#93; Security identifier (SID) of the group object from Active Directory. The
#' SID starts with "S-".
#' @param TemplateArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_template`][pcaconnectorad_create_template].
#'
#' @keywords internal
#'
#' @rdname pcaconnectorad_update_template_group_access_control_entry
pcaconnectorad_update_template_group_access_control_entry <- function(AccessRights = NULL, GroupDisplayName = NULL, GroupSecurityIdentifier, TemplateArn) {
  op <- new_operation(
    name = "UpdateTemplateGroupAccessControlEntry",
    http_method = "PATCH",
    http_path = "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
    paginator = list()
  )
  input <- .pcaconnectorad$update_template_group_access_control_entry_input(AccessRights = AccessRights, GroupDisplayName = GroupDisplayName, GroupSecurityIdentifier = GroupSecurityIdentifier, TemplateArn = TemplateArn)
  output <- .pcaconnectorad$update_template_group_access_control_entry_output()
  config <- get_config()
  svc <- .pcaconnectorad$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pcaconnectorad$operations$update_template_group_access_control_entry <- pcaconnectorad_update_template_group_access_control_entry
