% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detective_operations.R
\name{detective_list_indicators}
\alias{detective_list_indicators}
\title{Gets the indicators from an investigation}
\usage{
detective_list_indicators(
  GraphArn,
  InvestigationId,
  IndicatorType = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{GraphArn}{[required] The Amazon Resource Name (ARN) of the behavior graph.}

\item{InvestigationId}{[required] The investigation ID of the investigation report.}

\item{IndicatorType}{For the list of indicators of compromise that are generated by Detective
investigations, see \href{https://docs.aws.amazon.com/detective/latest/userguide/}{Detective investigations}.}

\item{NextToken}{Lists if there are more results available. The value of nextToken is a
unique pagination token for each page. Repeat the call using the
returned token to retrieve the next page. Keep all other arguments
unchanged.

Each pagination token expires after 24 hours. Using an expired
pagination token will return a Validation Exception error.}

\item{MaxResults}{Lists the maximum number of indicators in a page.}
}
\description{
Gets the indicators from an investigation. You can use the information from the indicators to determine if an IAM user and/or IAM role is involved in an unusual activity that could indicate malicious behavior and its impact.

See \url{https://www.paws-r-sdk.com/docs/detective_list_indicators/} for full documentation.
}
\keyword{internal}
