% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_add_user_to_group}
\alias{cognitoidentityprovider_admin_add_user_to_group}
\title{Adds a user to a group}
\usage{
cognitoidentityprovider_admin_add_user_to_group(
  UserPoolId,
  Username,
  GroupName
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool that contains the group that you want to add the
user to.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{GroupName}{[required] The name of the group that you want to add your user to.}
}
\description{
Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and populates a \code{cognito:groups} claim to their access and identity tokens.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_add_user_to_group/} for full documentation.
}
\keyword{internal}
