% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_managed_login_branding}
\alias{cognitoidentityprovider_update_managed_login_branding}
\title{Configures the branding settings for a user pool style}
\usage{
cognitoidentityprovider_update_managed_login_branding(
  UserPoolId = NULL,
  ManagedLoginBrandingId = NULL,
  UseCognitoProvidedValues = NULL,
  Settings = NULL,
  Assets = NULL
)
}
\arguments{
\item{UserPoolId}{The ID of the user pool that contains the managed login branding style
that you want to update.}

\item{ManagedLoginBrandingId}{The ID of the managed login branding style that you want to update.}

\item{UseCognitoProvidedValues}{When true, applies the default branding style options. This option
reverts to default style options that are managed by Amazon Cognito. You
can modify them later in the branding designer.

When you specify \code{true} for this option, you must also omit values for
\code{Settings} and \code{Assets} in the request.}

\item{Settings}{A JSON file, encoded as a \code{Document} type, with the the settings that
you want to apply to your style.}

\item{Assets}{An array of image files that you want to apply to roles like
backgrounds, logos, and icons. Each object must also indicate whether it
is for dark mode, light mode, or browser-adaptive mode.}
}
\description{
Configures the branding settings for a user pool style. This operation is the programmatic option for the configuration of a style in the branding designer.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_managed_login_branding/} for full documentation.
}
\keyword{internal}
