% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_snapshot_schedule}
\alias{storagegateway_update_snapshot_schedule}
\title{Updates a snapshot schedule configured for a gateway volume}
\usage{
storagegateway_update_snapshot_schedule(VolumeARN, StartAt,
  RecurrenceInHours, Description, Tags)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
operation to return a list of gateway volumes.}

\item{StartAt}{[required] The hour of the day at which the snapshot schedule begins represented as
\emph{hh}, where \emph{hh} is the hour (0 to 23). The hour of the day is in the
time zone of the gateway.}

\item{RecurrenceInHours}{[required] Frequency of snapshots. Specify the number of hours between snapshots.}

\item{Description}{Optional description of the snapshot that overwrites the existing
description.}

\item{Tags}{A list of up to 50 tags that can be assigned to a snapshot. Each tag is
a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . \\_ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\description{
Updates a snapshot schedule configured for a gateway volume. This
operation is only supported in the cached volume and stored volume
gateway types.

The default snapshot schedule for volume is once every 24 hours,
starting at the creation time of the volume. You can use this API to
change the snapshot schedule configured for the volume.

In the request you must identify the gateway volume whose snapshot
schedule you want to update, and the schedule information, including
when you want the snapshot to begin on a day and the frequency (in
hours) of snapshots.
}
\section{Request syntax}{
\preformatted{svc$update_snapshot_schedule(
  VolumeARN = "string",
  StartAt = 123,
  RecurrenceInHours = 123,
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Updates a snapshot schedule configured for a gateway volume.
svc$update_snapshot_schedule(
  Description = "Hourly snapshot",
  RecurrenceInHours = 1L,
  StartAt = 0L,
  VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
)
}

}
\keyword{internal}
