% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_metrics_configuration}
\alias{s3_put_bucket_metrics_configuration}
\title{Sets a metrics configuration (specified by the metrics configuration ID)
for the bucket}
\usage{
s3_put_bucket_metrics_configuration(Bucket, Id, MetricsConfiguration,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which the metrics configuration is set.}

\item{Id}{[required] The ID used to identify the metrics configuration.}

\item{MetricsConfiguration}{[required] Specifies the metrics configuration.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
An empty list.
}
\description{
Sets a metrics configuration (specified by the metrics configuration ID)
for the bucket. You can have up to 1,000 metrics configurations per
bucket. If you're updating an existing metrics configuration, note that
this is a full replacement of the existing metrics configuration. If you
don't include the elements you want to keep, they are erased.

To use this operation, you must have permissions to perform the
\code{s3:PutMetricsConfiguration} action. The bucket owner has this
permission by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

For information about CloudWatch request metrics for Amazon S3, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/cloudwatch-monitoring.html}{Monitoring Metrics with Amazon CloudWatch}.

The following operations are related to
\code{\link[=s3_put_bucket_metrics_configuration]{put_bucket_metrics_configuration}}:
\itemize{
\item \code{\link[=s3_delete_bucket_metrics_configuration]{delete_bucket_metrics_configuration}}
\item \code{\link[=s3_put_bucket_metrics_configuration]{put_bucket_metrics_configuration}}
\item \code{\link[=s3_list_bucket_metrics_configurations]{list_bucket_metrics_configurations}}
}

\code{\link[=s3_get_bucket_lifecycle]{get_bucket_lifecycle}} has the following
special error:
\itemize{
\item Error code: \code{TooManyConfigurations}
\itemize{
\item Description: You are attempting to create a new configuration
but have already reached the 1,000-configuration limit.
\item HTTP Status Code: HTTP 400 Bad Request
}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_metrics_configuration(
  Bucket = "string",
  Id = "string",
  MetricsConfiguration = list(
    Id = "string",
    Filter = list(
      Prefix = "string",
      Tag = list(
        Key = "string",
        Value = "string"
      ),
      And = list(
        Prefix = "string",
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      )
    )
  ),
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
