% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_volumes}
\alias{storagegateway_list_volumes}
\title{Lists the iSCSI stored volumes of a gateway}
\usage{
storagegateway_list_volumes(GatewayARN, Marker, Limit)
}
\arguments{
\item{GatewayARN}{}

\item{Marker}{A string that indicates the position at which to begin the returned list
of volumes. Obtain the marker from the response of a previous List iSCSI
Volumes request.}

\item{Limit}{Specifies that the list of volumes returned be limited to the specified
number of items.}
}
\description{
Lists the iSCSI stored volumes of a gateway. Results are sorted by
volume ARN. The response includes only the volume ARNs. If you want
additional volume information, use the DescribeStorediSCSIVolumes or the
DescribeCachediSCSIVolumes API.
}
\details{
The operation supports pagination. By default, the operation returns a
maximum of up to 100 volumes. You can optionally specify the \code{Limit}
field in the body to limit the number of volumes in the response. If the
number of volumes returned in the response is truncated, the response
includes a Marker field. You can use this Marker value in your
subsequent request to retrieve the next set of volumes. This operation
is only supported in the cached volume and stored volume gateway types.
}
\section{Request syntax}{
\preformatted{svc$list_volumes(
  GatewayARN = "string",
  Marker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# Lists the iSCSI stored volumes of a gateway. Results are sorted by
# volume ARN up to a maximum of 100 volumes.
svc$list_volumes(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
  Limit = 2L,
  Marker = "1"
)
}

}
\keyword{internal}
