% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backupstorage_operations.R
\name{backupstorage_put_object}
\alias{backupstorage_put_object}
\title{Upload object that can store object metadata String and data blob in
single API call using inline chunk field}
\usage{
backupstorage_put_object(
  BackupJobId,
  ObjectName,
  MetadataString = NULL,
  InlineChunk = NULL,
  InlineChunkLength = NULL,
  InlineChunkChecksum = NULL,
  InlineChunkChecksumAlgorithm = NULL,
  ObjectChecksum = NULL,
  ObjectChecksumAlgorithm = NULL,
  ThrowOnDuplicate = NULL
)
}
\arguments{
\item{BackupJobId}{[required] Backup job Id for the in-progress backup.}

\item{ObjectName}{[required] The name of the Object to be uploaded.}

\item{MetadataString}{Store user defined metadata like backup checksum, disk ids, restore
metadata etc.}

\item{InlineChunk}{Inline chunk data to be uploaded.}

\item{InlineChunkLength}{Length of the inline chunk data.}

\item{InlineChunkChecksum}{Inline chunk checksum}

\item{InlineChunkChecksumAlgorithm}{Inline chunk checksum algorithm}

\item{ObjectChecksum}{object checksum}

\item{ObjectChecksumAlgorithm}{object checksum algorithm}

\item{ThrowOnDuplicate}{Throw an exception if Object name is already exist.}
}
\description{
Upload object that can store object metadata String and data blob in single API call using inline chunk field.

See \url{https://paws-r.github.io/docs/backupstorage/put_object.html} for full documentation.
}
\keyword{internal}
