% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_update_user}
\alias{finspacedata_update_user}
\title{Modifies the details of the specified user account}
\usage{
finspacedata_update_user(
  userId,
  type = NULL,
  firstName = NULL,
  lastName = NULL,
  apiAccess = NULL,
  apiAccessPrincipalArn = NULL,
  clientToken = NULL
)
}
\arguments{
\item{userId}{[required] The unique identifier for the user account to update.}

\item{type}{The option to indicate the type of user.
\itemize{
\item \code{SUPER_USER}– A user with permission to all the functionality and
data in FinSpace.
\item \code{APP_USER} – A user with specific permissions in FinSpace. The users
are assigned permissions by adding them to a permission group.
}}

\item{firstName}{The first name of the user.}

\item{lastName}{The last name of the user.}

\item{apiAccess}{The option to indicate whether the user can use the
\code{\link[=finspacedata_get_programmatic_access_credentials]{get_programmatic_access_credentials}}
API to obtain credentials that can then be used to access other FinSpace
Data API operations.
\itemize{
\item \code{ENABLED} – The user has permissions to use the APIs.
\item \code{DISABLED} – The user does not have permissions to use any APIs.
}}

\item{apiAccessPrincipalArn}{The ARN identifier of an AWS user or role that is allowed to call the
\code{\link[=finspacedata_get_programmatic_access_credentials]{get_programmatic_access_credentials}}
API to obtain a credentials token for a specific FinSpace user. This
must be an IAM role within your FinSpace account.}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Modifies the details of the specified user account. You cannot update the \code{userId} for a user.

See \url{https://paws-r.github.io/docs/finspacedata/update_user.html} for full documentation.
}
\keyword{internal}
