% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_backup}
\alias{fsx_create_backup}
\title{Creates a backup of an existing Amazon FSx for Windows File Server file
system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP
volume, or Amazon FSx for OpenZFS file system}
\usage{
fsx_create_backup(
  FileSystemId = NULL,
  ClientRequestToken = NULL,
  Tags = NULL,
  VolumeId = NULL
)
}
\arguments{
\item{FileSystemId}{The ID of the file system to back up.}

\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent creation. This string is automatically filled on your
behalf when you use the Command Line Interface (CLI) or an Amazon Web
Services SDK.}

\item{Tags}{(Optional) The tags to apply to the backup at backup creation. The key
value of the \code{Name} tag appears in the console as the backup name. If
you have set \code{CopyTagsToBackups} to \code{true}, and you specify one or more
tags using the \code{\link[=fsx_create_backup]{create_backup}} operation, no
existing file system tags are copied from the file system to the backup.}

\item{VolumeId}{(Optional) The ID of the FSx for ONTAP volume to back up.}
}
\description{
Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.

See \url{https://paws-r.github.io/docs/fsx/create_backup.html} for full documentation.
}
\keyword{internal}
