% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_bucket}
\alias{s3_create_bucket}
\title{Creates a new S3 bucket}
\usage{
s3_create_bucket(
  ACL = NULL,
  Bucket,
  CreateBucketConfiguration = NULL,
  GrantFullControl = NULL,
  GrantRead = NULL,
  GrantReadACP = NULL,
  GrantWrite = NULL,
  GrantWriteACP = NULL,
  ObjectLockEnabledForBucket = NULL,
  ObjectOwnership = NULL
)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.}

\item{Bucket}{[required] The name of the bucket to create.}

\item{CreateBucketConfiguration}{The configuration information for the bucket.}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.}

\item{GrantWrite}{Allows grantee to create new objects in the bucket.

For the bucket and object owners of existing objects, also allows
deletions and overwrites of those objects.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.}

\item{ObjectLockEnabledForBucket}{Specifies whether you want S3 Object Lock to be enabled for the new
bucket.}

\item{ObjectOwnership}{}
}
\description{
Creates a new S3 bucket. To create a bucket, you must register with Amazon S3 and have a valid Amazon Web Services Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the bucket, you become the bucket owner.

See \url{https://paws-r.github.io/docs/s3/create_bucket.html} for full documentation.
}
\keyword{internal}
