% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_encryption}
\alias{s3_put_bucket_encryption}
\title{This action uses the encryption subresource to configure default
encryption and Amazon S3 Bucket Key for an existing bucket}
\usage{
s3_put_bucket_encryption(
  Bucket,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  ServerSideEncryptionConfiguration,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] Specifies default encryption for a bucket using server-side encryption
with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS).
For information about the Amazon S3 default encryption feature, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html}{Amazon S3 Default Bucket Encryption}
in the \emph{Amazon S3 User Guide}.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the server-side encryption
configuration.

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{ServerSideEncryptionConfiguration}{[required]}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This action uses the \code{encryption} subresource to configure default encryption and Amazon S3 Bucket Key for an existing bucket.

See \url{https://paws-r.github.io/docs/s3/put_bucket_encryption.html} for full documentation.
}
\keyword{internal}
