% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_describe_multi_region_access_point_operation}
\alias{s3control_describe_multi_region_access_point_operation}
\title{Retrieves the status of an asynchronous request to manage a Multi-Region
Access Point}
\usage{
s3control_describe_multi_region_access_point_operation(
  AccountId,
  RequestTokenARN
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID for the owner of the Multi-Region
Access Point.}

\item{RequestTokenARN}{[required] The request token associated with the request you want to know about.
This request token is returned as part of the response when you make an
asynchronous request. You provide this token to query about the status
of the asynchronous action.}
}
\description{
Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html}{Managing Multi-Region Access Points} in the \emph{Amazon S3 User Guide}.

See \url{https://paws-r.github.io/docs/s3control/describe_multi_region_access_point_operation.html} for full documentation.
}
\keyword{internal}
