% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_delete_data_repository_association}
\alias{fsx_delete_data_repository_association}
\title{Deletes a data repository association on an Amazon FSx for Lustre file
system}
\usage{
fsx_delete_data_repository_association(
  AssociationId,
  ClientRequestToken = NULL,
  DeleteDataInFileSystem = NULL
)
}
\arguments{
\item{AssociationId}{[required] The ID of the data repository association that you want to delete.}

\item{ClientRequestToken}{}

\item{DeleteDataInFileSystem}{Set to \code{true} to delete the data in the file system that corresponds to
the data repository association.}
}
\description{
Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding \code{scratch_1} deployment type.

See \url{https://www.paws-r-sdk.com/docs/fsx_delete_data_repository_association/} for full documentation.
}
\keyword{internal}
