% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_directory_buckets}
\alias{s3_list_directory_buckets}
\title{Returns a list of all Amazon S3 directory buckets owned by the
authenticated sender of the request}
\usage{
s3_list_directory_buckets(ContinuationToken = NULL, MaxDirectoryBuckets = NULL)
}
\arguments{
\item{ContinuationToken}{\code{ContinuationToken} indicates to Amazon S3 that the list is being
continued on buckets in this account with a token. \code{ContinuationToken}
is obfuscated and is not a real bucket name. You can use this
\code{ContinuationToken} for the pagination of the list results.}

\item{MaxDirectoryBuckets}{Maximum number of buckets to be returned in response. When the number is
more than the count of buckets that are owned by an Amazon Web Services
account, return all the buckets in response.}
}
\description{
Returns a list of all Amazon S3 directory buckets owned by the authenticated sender of the request. For more information about directory buckets, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html}{Directory buckets} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3_list_directory_buckets/} for full documentation.
}
\keyword{internal}
