% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{health}
\alias{health}
\title{AWS Health APIs and Notifications}
\usage{
health()
}
\description{
AWS Health

The AWS Health API provides programmatic access to the AWS Health
information that is presented in the \href{https://phd.aws.amazon.com/phd/home#/}{AWS Personal Health Dashboard}. You can get
information about events that affect your AWS resources:
\itemize{
\item DescribeEvents: Summary information about events.
\item DescribeEventDetails: Detailed information about one or more events.
\item DescribeAffectedEntities: Information about AWS resources that are
affected by one or more events.
}

In addition, these operations provide information about event types and
summary counts of events or affected entities:
\itemize{
\item DescribeEventTypes: Information about the kinds of events that AWS
Health tracks.
\item DescribeEventAggregates: A count of the number of events that meet
specified criteria.
\item DescribeEntityAggregates: A count of the number of affected entities
that meet specified criteria.
}

The Health API requires a Business or Enterprise support plan from \href{http://aws.amazon.com/premiumsupport/}{AWS Support}. Calling the Health API
from an account that does not have a Business or Enterprise support plan
causes a \code{SubscriptionRequiredException}.

For authentication of requests, AWS Health uses the \href{http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

See the \href{http://docs.aws.amazon.com/health/latest/ug/what-is-aws-health.html}{AWS Health User Guide}
for information about how to use the API.

\strong{Service Endpoint}

The HTTP endpoint for the AWS Health API is:
\itemize{
\item https://health.us-east-1.amazonaws.com
}
}
\section{Operations}{

\tabular{ll}{
\link[=health_describe_affected_entities]{describe_affected_entities} \tab Returns a list of entities that have been affected by the specified events, based on the specified filter criteria\cr
\link[=health_describe_entity_aggregates]{describe_entity_aggregates} \tab Returns the number of entities that are affected by each of the specified events \cr
\link[=health_describe_event_aggregates]{describe_event_aggregates} \tab Returns the number of events of each event type (issue, scheduled change, and account notification) \cr
\link[=health_describe_event_details]{describe_event_details} \tab Returns detailed information about one or more specified events \cr
\link[=health_describe_event_types]{describe_event_types} \tab Returns the event types that meet the specified filter criteria \cr
\link[=health_describe_events]{describe_events} \tab Returns information about events that meet the specified filter criteria
}
}

\examples{
\donttest{svc <- health()
svc$describe_affected_entities(
  Foo = 123
)}

}
