% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{directoryservice}
\alias{directoryservice}
\title{AWS Directory Service}
\usage{
directoryservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Directory Service is a web service that makes it easy for you to
setup and run directories in the AWS cloud, or connect your AWS
resources with an existing on-premises Microsoft Active Directory. This
guide provides detailed information about AWS Directory Service
operations, data types, parameters, and errors. For information about
AWS Directory Services features, see \href{https://aws.amazon.com/directoryservice/}{AWS Directory Service} and the \href{http://docs.aws.amazon.com/directoryservice/latest/admin-guide/what_is.html}{AWS Directory Service Administration Guide}.

AWS provides SDKs that consist of libraries and sample code for various
programming languages and platforms (Java, Ruby, .Net, iOS, Android,
etc.). The SDKs provide a convenient way to create programmatic access
to AWS Directory Service and other AWS services. For more information
about the AWS SDKs, including how to download and install them, see
\href{http://aws.amazon.com/tools/}{Tools for Amazon Web Services}.
}
\section{Service syntax}{
\preformatted{svc <- directoryservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=directoryservice_accept_shared_directory]{accept_shared_directory} \tab Accepts a directory sharing request that was sent from the directory owner account \cr
\link[=directoryservice_add_ip_routes]{add_ip_routes} \tab If the DNS server for your on-premises domain uses a publicly addressable IP address, you must add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services\cr
\link[=directoryservice_add_tags_to_resource]{add_tags_to_resource} \tab Adds or overwrites one or more tags for the specified directory \cr
\link[=directoryservice_cancel_schema_extension]{cancel_schema_extension} \tab Cancels an in-progress schema extension to a Microsoft AD directory \cr
\link[=directoryservice_connect_directory]{connect_directory} \tab Creates an AD Connector to connect to an on-premises directory \cr
\link[=directoryservice_create_alias]{create_alias} \tab Creates an alias for a directory and assigns the alias to the directory \cr
\link[=directoryservice_create_computer]{create_computer} \tab Creates a computer account in the specified directory, and joins the computer to the directory \cr
\link[=directoryservice_create_conditional_forwarder]{create_conditional_forwarder} \tab Creates a conditional forwarder associated with your AWS directory \cr
\link[=directoryservice_create_directory]{create_directory} \tab Creates a Simple AD directory \cr
\link[=directoryservice_create_log_subscription]{create_log_subscription} \tab Creates a subscription to forward real-time Directory Service domain controller security logs to the specified Amazon CloudWatch log group in your AWS account \cr
\link[=directoryservice_create_microsoft_ad]{create_microsoft_ad} \tab Creates a Microsoft AD directory in the AWS Cloud \cr
\link[=directoryservice_create_snapshot]{create_snapshot} \tab Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS cloud \cr
\link[=directoryservice_create_trust]{create_trust} \tab AWS Directory Service for Microsoft Active Directory allows you to configure trust relationships \cr
\link[=directoryservice_delete_conditional_forwarder]{delete_conditional_forwarder} \tab Deletes a conditional forwarder that has been set up for your AWS directory \cr
\link[=directoryservice_delete_directory]{delete_directory} \tab Deletes an AWS Directory Service directory \cr
\link[=directoryservice_delete_log_subscription]{delete_log_subscription} \tab Deletes the specified log subscription \cr
\link[=directoryservice_delete_snapshot]{delete_snapshot} \tab Deletes a directory snapshot \cr
\link[=directoryservice_delete_trust]{delete_trust} \tab Deletes an existing trust relationship between your AWS Managed Microsoft AD directory and an external domain \cr
\link[=directoryservice_deregister_certificate]{deregister_certificate} \tab Deletes from the system the certificate that was registered for a secured LDAP connection \cr
\link[=directoryservice_deregister_event_topic]{deregister_event_topic} \tab Removes the specified directory as a publisher to the specified SNS topic \cr
\link[=directoryservice_describe_certificate]{describe_certificate} \tab Displays information about the certificate registered for a secured LDAP connection \cr
\link[=directoryservice_describe_conditional_forwarders]{describe_conditional_forwarders} \tab Obtains information about the conditional forwarders for this account \cr
\link[=directoryservice_describe_directories]{describe_directories} \tab Obtains information about the directories that belong to this account \cr
\link[=directoryservice_describe_domain_controllers]{describe_domain_controllers} \tab Provides information about any domain controllers in your directory \cr
\link[=directoryservice_describe_event_topics]{describe_event_topics} \tab Obtains information about which SNS topics receive status messages from the specified directory \cr
\link[=directoryservice_describe_ldaps_settings]{describe_ldaps_settings} \tab Describes the status of LDAP security for the specified directory \cr
\link[=directoryservice_describe_shared_directories]{describe_shared_directories} \tab Returns the shared directories in your account \cr
\link[=directoryservice_describe_snapshots]{describe_snapshots} \tab Obtains information about the directory snapshots that belong to this account \cr
\link[=directoryservice_describe_trusts]{describe_trusts} \tab Obtains information about the trust relationships for this account \cr
\link[=directoryservice_disable_ldaps]{disable_ldaps} \tab Deactivates LDAP secure calls for the specified directory \cr
\link[=directoryservice_disable_radius]{disable_radius} \tab Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory \cr
\link[=directoryservice_disable_sso]{disable_sso} \tab Disables single-sign on for a directory \cr
\link[=directoryservice_enable_ldaps]{enable_ldaps} \tab Activates the switch for the specific directory to always use LDAP secure calls \cr
\link[=directoryservice_enable_radius]{enable_radius} \tab Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory \cr
\link[=directoryservice_enable_sso]{enable_sso} \tab Enables single sign-on for a directory \cr
\link[=directoryservice_get_directory_limits]{get_directory_limits} \tab Obtains directory limit information for the current Region \cr
\link[=directoryservice_get_snapshot_limits]{get_snapshot_limits} \tab Obtains the manual snapshot limits for a directory \cr
\link[=directoryservice_list_certificates]{list_certificates} \tab For the specified directory, lists all the certificates registered for a secured LDAP connection \cr
\link[=directoryservice_list_ip_routes]{list_ip_routes} \tab Lists the address blocks that you have added to a directory \cr
\link[=directoryservice_list_log_subscriptions]{list_log_subscriptions} \tab Lists the active log subscriptions for the AWS account \cr
\link[=directoryservice_list_schema_extensions]{list_schema_extensions} \tab Lists all schema extensions applied to a Microsoft AD Directory \cr
\link[=directoryservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on a directory \cr
\link[=directoryservice_register_certificate]{register_certificate} \tab Registers a certificate for secured LDAP connection \cr
\link[=directoryservice_register_event_topic]{register_event_topic} \tab Associates a directory with an SNS topic \cr
\link[=directoryservice_reject_shared_directory]{reject_shared_directory} \tab Rejects a directory sharing request that was sent from the directory owner account \cr
\link[=directoryservice_remove_ip_routes]{remove_ip_routes} \tab Removes IP address blocks from a directory \cr
\link[=directoryservice_remove_tags_from_resource]{remove_tags_from_resource} \tab Removes tags from a directory \cr
\link[=directoryservice_reset_user_password]{reset_user_password} \tab Resets the password for any user in your AWS Managed Microsoft AD or Simple AD directory \cr
\link[=directoryservice_restore_from_snapshot]{restore_from_snapshot} \tab Restores a directory using an existing directory snapshot \cr
\link[=directoryservice_share_directory]{share_directory} \tab Shares a specified directory (DirectoryId) in your AWS account (directory owner) with another AWS account (directory consumer) \cr
\link[=directoryservice_start_schema_extension]{start_schema_extension} \tab Applies a schema extension to a Microsoft AD directory \cr
\link[=directoryservice_unshare_directory]{unshare_directory} \tab Stops the directory sharing between the directory owner and consumer accounts \cr
\link[=directoryservice_update_conditional_forwarder]{update_conditional_forwarder} \tab Updates a conditional forwarder that has been set up for your AWS directory \cr
\link[=directoryservice_update_number_of_domain_controllers]{update_number_of_domain_controllers} \tab Adds or removes domain controllers to or from the directory \cr
\link[=directoryservice_update_radius]{update_radius} \tab Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or Microsoft AD directory \cr
\link[=directoryservice_update_trust]{update_trust} \tab Updates the trust that has been set up between your AWS Managed Microsoft AD directory and an on-premises Active Directory \cr
\link[=directoryservice_verify_trust]{verify_trust} \tab AWS Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships
}
}

\examples{
\dontrun{svc <- directoryservice()
svc$accept_shared_directory(
  Foo = 123
)}

}
