% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ivschat}
\alias{ivschat}
\title{Amazon Interactive Video Service Chat}
\usage{
ivschat(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
\strong{Introduction}

The Amazon IVS Chat control-plane API enables you to create and manage
Amazon IVS Chat resources. You also need to integrate with the \href{https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/}{Amazon IVS Chat Messaging API}, to
enable users to interact with chat rooms in real time.

The API is an AWS regional service. For a list of supported regions and
Amazon IVS Chat HTTPS service endpoints, see the Amazon IVS Chat
information on the \href{https://docs.aws.amazon.com/general/latest/gr/ivs.html}{Amazon IVS page} in the
\emph{AWS General Reference}.

\strong{Notes on terminology:}
\itemize{
\item You create service applications using the Amazon IVS Chat API. We
refer to these as \emph{applications}.
\item You create front-end client applications (browser and Android/iOS
apps) using the Amazon IVS Chat Messaging API. We refer to these as
\emph{clients}.
}

\strong{Resources}

The following resources are part of Amazon IVS Chat:
\itemize{
\item \strong{LoggingConfiguration} — A configuration that allows customers to
store and record sent messages in a chat room. See the Logging
Configuration endpoints for more information.
\item \strong{Room} — The central Amazon IVS Chat resource through which
clients connect to and exchange chat messages. See the Room
endpoints for more information.
}

\strong{Tagging}

A \emph{tag} is a metadata label that you assign to an AWS resource. A tag
comprises a \emph{key} and a \emph{value}, both set by you. For example, you might
set a tag as \code{topic:nature} to label a particular video category. See
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging AWS Resources}
for more information, including restrictions that apply to tags and "Tag
naming limits and requirements"; Amazon IVS Chat has no service-specific
constraints beyond what is documented there.

Tags can help you identify and organize your AWS resources. For example,
you can use the same tag for different resources to indicate that they
are related. You can also use tags to manage access (see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Access Tags}).

The Amazon IVS Chat API has these tag-related endpoints:
\code{tag_resource},
\code{untag_resource}, and
\code{list_tags_for_resource}. The
following resource supports tagging: Room.

At most 50 tags can be applied to a resource.

\strong{API Access Security}

Your Amazon IVS Chat applications (service applications and clients)
must be authenticated and authorized to access Amazon IVS Chat
resources. Note the differences between these concepts:
\itemize{
\item \emph{Authentication} is about verifying identity. Requests to the Amazon
IVS Chat API must be signed to verify your identity.
\item \emph{Authorization} is about granting permissions. Your IAM roles need
to have permissions for Amazon IVS Chat API requests.
}

Users (viewers) connect to a room using secure access tokens that you
create using the \code{create_chat_token}
endpoint through the AWS SDK. You call CreateChatToken for every user’s
chat session, passing identity and authorization information about the
user.

\strong{Signing API Requests}

HTTP API requests must be signed with an AWS SigV4 signature using your
AWS security credentials. The AWS Command Line Interface (CLI) and the
AWS SDKs take care of signing the underlying API calls for you. However,
if your application calls the Amazon IVS Chat HTTP API directly, it’s
your responsibility to sign the requests.

You generate a signature using valid AWS credentials for an IAM role
that has permission to perform the requested action. For example,
DeleteMessage requests must be made using an IAM role that has the
\code{ivschat:DeleteMessage} permission.

For more information:
\itemize{
\item Authentication and generating signatures — See \href{https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html}{Authenticating Requests (Amazon Web Services Signature Version 4)}
in the \emph{Amazon Web Services General Reference}.
\item Managing Amazon IVS permissions — See \href{https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html}{Identity and Access Management}
on the Security page of the \emph{Amazon IVS User Guide}.
}

\strong{Amazon Resource Names (ARNs)}

ARNs uniquely identify AWS resources. An ARN is required when you need
to specify a resource unambiguously across all of AWS, such as in IAM
policies and API calls. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names}
in the \emph{AWS General Reference}.

\strong{Messaging Endpoints}
\itemize{
\item \code{delete_message} — Sends an event to a
specific room which directs clients to delete a specific message;
that is, unrender it from view and delete it from the client’s chat
history. This event’s \code{EventName} is \code{aws:DELETE_MESSAGE}. This
replicates the
\href{https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html}{DeleteMessage}
WebSocket operation in the Amazon IVS Chat Messaging API.
\item \code{disconnect_user} — Disconnects all
connections using a specified user ID from a room. This replicates
the
\href{https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html}{DisconnectUser}
WebSocket operation in the Amazon IVS Chat Messaging API.
\item \code{send_event} — Sends an event to a room. Use
this within your application’s business logic to send events to
clients of a room; e.g., to notify clients to change the way the
chat UI is rendered.
}

\strong{Chat Token Endpoint}
\itemize{
\item \code{create_chat_token} — Creates an
encrypted token that is used by a chat participant to establish an
individual WebSocket chat connection to a room. When the token is
used to connect to chat, the connection is valid for the session
duration specified in the request. The token becomes invalid at the
token-expiration timestamp included in the response.
}

\strong{Room Endpoints}
\itemize{
\item \code{create_room} — Creates a room that allows
clients to connect and pass messages.
\item \code{delete_room} — Deletes the specified room.
\item \code{get_room} — Gets the specified room.
\item \code{list_rooms} — Gets summary information about
all your rooms in the AWS region where the API request is processed.
\item \code{update_room} — Updates a room’s
configuration.
}

\strong{Logging Configuration Endpoints}
\itemize{
\item \code{create_logging_configuration}
— Creates a logging configuration that allows clients to store and
record sent messages.
\item \code{delete_logging_configuration}
— Deletes the specified logging configuration.
\item \code{get_logging_configuration} —
Gets the specified logging configuration.
\item \code{list_logging_configurations}
— Gets summary information about all your logging configurations in
the AWS region where the API request is processed.
\item \code{update_logging_configuration}
— Updates a specified logging configuration.
}

\strong{Tags Endpoints}
\itemize{
\item \code{list_tags_for_resource} — Gets
information about AWS tags for the specified ARN.
\item \code{tag_resource} — Adds or updates tags for
the AWS resource with the specified ARN.
\item \code{untag_resource} — Removes tags from the
resource with the specified ARN.
}

All the above are HTTP operations. There is a separate \emph{messaging} API
for managing Chat resources; see the \href{https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/}{Amazon IVS Chat Messaging API Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ivschat(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.end.user.computing:ivschat_create_chat_token]{create_chat_token} \tab Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room\cr
\link[paws.end.user.computing:ivschat_create_logging_configuration]{create_logging_configuration} \tab Creates a logging configuration that allows clients to store and record sent messages\cr
\link[paws.end.user.computing:ivschat_create_room]{create_room} \tab Creates a room that allows clients to connect and pass messages\cr
\link[paws.end.user.computing:ivschat_delete_logging_configuration]{delete_logging_configuration} \tab Deletes the specified logging configuration\cr
\link[paws.end.user.computing:ivschat_delete_message]{delete_message} \tab Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history\cr
\link[paws.end.user.computing:ivschat_delete_room]{delete_room} \tab Deletes the specified room\cr
\link[paws.end.user.computing:ivschat_disconnect_user]{disconnect_user} \tab Disconnects all connections using a specified user ID from a room\cr
\link[paws.end.user.computing:ivschat_get_logging_configuration]{get_logging_configuration} \tab Gets the specified logging configuration\cr
\link[paws.end.user.computing:ivschat_get_room]{get_room} \tab Gets the specified room\cr
\link[paws.end.user.computing:ivschat_list_logging_configurations]{list_logging_configurations} \tab Gets summary information about all your logging configurations in the AWS region where the API request is processed\cr
\link[paws.end.user.computing:ivschat_list_rooms]{list_rooms} \tab Gets summary information about all your rooms in the AWS region where the API request is processed\cr
\link[paws.end.user.computing:ivschat_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about AWS tags for the specified ARN\cr
\link[paws.end.user.computing:ivschat_send_event]{send_event} \tab Sends an event to a room\cr
\link[paws.end.user.computing:ivschat_tag_resource]{tag_resource} \tab Adds or updates tags for the AWS resource with the specified ARN\cr
\link[paws.end.user.computing:ivschat_untag_resource]{untag_resource} \tab Removes tags from the resource with the specified ARN\cr
\link[paws.end.user.computing:ivschat_update_logging_configuration]{update_logging_configuration} \tab Updates a specified logging configuration\cr
\link[paws.end.user.computing:ivschat_update_room]{update_room} \tab Updates a room’s configuration
}
}

\examples{
\dontrun{
svc <- ivschat()
svc$create_chat_token(
  Foo = 123
)
}

}
